/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.graph;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.graph.ArcId;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;

public class ChildDiffLoader
implements GraphChangeHandler {
    static final ThreadLocal<Boolean> childDiffProcessing = ThreadLocal.withInitial(() -> false);
    protected ObjectContext context;

    public static boolean isProcessingChildDiff() {
        return childDiffProcessing.get();
    }

    public static void setExternalChange(Boolean flag) {
        childDiffProcessing.set(flag);
    }

    public ChildDiffLoader(ObjectContext context) {
        this.context = context;
    }

    @Override
    public void nodeIdChanged(Object nodeId, Object newId) {
        throw new CayenneRuntimeException("Not supported", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeCreated(Object nodeId) {
        ChildDiffLoader.setExternalChange(Boolean.TRUE);
        try {
            Persistent dataObject;
            ObjectId id = (ObjectId)nodeId;
            if (id.getEntityName() == null) {
                throw new NullPointerException("Null entity name in id " + id);
            }
            ObjEntity entity = this.context.getEntityResolver().getObjEntity(id.getEntityName());
            if (entity == null) {
                throw new IllegalArgumentException("Entity not mapped with Cayenne: " + id);
            }
            Class javaClass = this.context.getEntityResolver().getObjectFactory().getJavaClass(entity.getJavaClassName());
            try {
                dataObject = (Persistent)javaClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new CayenneRuntimeException("Error instantiating object.", (Throwable)ex, new Object[0]);
            }
            dataObject.setObjectId(id);
            this.context.registerNewObject(dataObject);
        }
        finally {
            ChildDiffLoader.setExternalChange(Boolean.FALSE);
        }
    }

    @Override
    public void nodeRemoved(Object nodeId) {
        ChildDiffLoader.setExternalChange(Boolean.TRUE);
        Persistent object = this.findObject(nodeId);
        if (object != null) {
            try {
                this.context.deleteObjects(object);
            }
            finally {
                ChildDiffLoader.setExternalChange(Boolean.FALSE);
            }
        } else {
            ChildDiffLoader.setExternalChange(Boolean.FALSE);
        }
    }

    @Override
    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        Persistent object = this.findObject(nodeId);
        ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(((ObjectId)nodeId).getEntityName());
        ChildDiffLoader.setExternalChange(Boolean.TRUE);
        try {
            descriptor.getProperty(property).writeProperty(object, oldValue, newValue);
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error setting property: " + property, (Throwable)e, new Object[0]);
        }
        finally {
            ChildDiffLoader.setExternalChange(Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void arcCreated(Object nodeId, Object targetNodeId, ArcId arcId) {
        final Persistent source = this.findObject(nodeId);
        final Persistent target = this.findObject(targetNodeId);
        if (target == null) {
            return;
        }
        ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(((ObjectId)nodeId).getEntityName());
        ArcProperty property = (ArcProperty)descriptor.getProperty(arcId.toString());
        ChildDiffLoader.setExternalChange(Boolean.TRUE);
        try {
            property.visit(new PropertyVisitor(){

                @Override
                public boolean visitAttribute(AttributeProperty property) {
                    return false;
                }

                @Override
                public boolean visitToMany(ToManyProperty property) {
                    ArcProperty reverseArc = property.getComplimentaryReverseArc();
                    boolean autoConnectReverse = reverseArc != null && reverseArc.getRelationship().isRuntime();
                    property.addTarget(source, target, autoConnectReverse);
                    return false;
                }

                @Override
                public boolean visitToOne(ToOneProperty property) {
                    property.setTarget(source, target, false);
                    return false;
                }
            });
        }
        finally {
            ChildDiffLoader.setExternalChange(Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void arcDeleted(Object nodeId, final Object targetNodeId, ArcId arcId) {
        final Persistent source = this.findObject(nodeId);
        if (source == null) {
            return;
        }
        ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(((ObjectId)nodeId).getEntityName());
        PropertyDescriptor property = descriptor.getProperty(arcId.toString());
        ChildDiffLoader.setExternalChange(Boolean.TRUE);
        try {
            property.visit(new PropertyVisitor(){

                @Override
                public boolean visitAttribute(AttributeProperty property) {
                    return false;
                }

                @Override
                public boolean visitToMany(ToManyProperty property) {
                    ArcProperty reverseArc = property.getComplimentaryReverseArc();
                    boolean autoConnectReverse = reverseArc != null && reverseArc.getRelationship().isRuntime();
                    Persistent target = ChildDiffLoader.this.findObject(targetNodeId);
                    if (target == null) {
                        target = ChildDiffLoader.this.findObjectInCollection(targetNodeId, property.readProperty(source));
                    }
                    if (target != null) {
                        property.removeTarget(source, target, autoConnectReverse);
                    }
                    return false;
                }

                @Override
                public boolean visitToOne(ToOneProperty property) {
                    property.setTarget(source, null, false);
                    return false;
                }
            });
        }
        finally {
            ChildDiffLoader.setExternalChange(Boolean.FALSE);
        }
    }

    protected Persistent findObject(Object nodeId) {
        Persistent object = (Persistent)this.context.getGraphManager().getNode(nodeId);
        if (object != null) {
            return object;
        }
        ObjectId id = (ObjectId)nodeId;
        if (id.isTemporary()) {
            return null;
        }
        ObjectIdQuery query = new ObjectIdQuery((ObjectId)nodeId);
        QueryResponse response = this.context.getChannel().onQuery(this.context, query);
        List objects = response.firstList();
        if (objects.size() == 0) {
            throw new CayenneRuntimeException("No object for ID exists: %s", nodeId);
        }
        if (objects.size() > 1) {
            throw new CayenneRuntimeException("Expected zero or one object, instead query matched: %d", objects.size());
        }
        return (Persistent)objects.get(0);
    }

    protected Persistent findObjectInCollection(Object nodeId, Object toManyHolder) {
        Collection c = toManyHolder instanceof Map ? ((Map)toManyHolder).values() : (Collection)toManyHolder;
        for (Object o : c) {
            Persistent p = (Persistent)o;
            if (!nodeId.equals(p.getObjectId())) continue;
            return p;
        }
        return null;
    }
}

