/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.FunctionExpressionFactory;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.Property;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.query.ColumnSelect;

public interface ComparableProperty<E>
extends Property<E> {
    default public Expression between(E lower, E upper) {
        return ExpressionFactory.betweenExp(this.getExpression(), lower, upper);
    }

    default public Expression between(ComparableProperty<?> lower, ComparableProperty<?> upper) {
        return ExpressionFactory.betweenExp(this.getExpression(), (Object)lower.getExpression(), (Object)upper.getExpression());
    }

    default public Expression gt(E value) {
        return ExpressionFactory.greaterExp(this.getExpression(), value);
    }

    default public Expression gt(ComparableProperty<?> value) {
        return ExpressionFactory.greaterExp(this.getExpression(), (Object)value.getExpression());
    }

    default public Expression gte(E value) {
        return ExpressionFactory.greaterOrEqualExp(this.getExpression(), value);
    }

    default public Expression gte(ComparableProperty<?> value) {
        return ExpressionFactory.greaterOrEqualExp(this.getExpression(), (Object)value.getExpression());
    }

    default public Expression lt(E value) {
        return ExpressionFactory.lessExp(this.getExpression(), value);
    }

    default public Expression lt(ComparableProperty<?> value) {
        return ExpressionFactory.lessExp(this.getExpression(), (Object)value.getExpression());
    }

    default public Expression lte(E value) {
        return ExpressionFactory.lessOrEqualExp(this.getExpression(), value);
    }

    default public Expression lte(ComparableProperty<?> value) {
        return ExpressionFactory.lessOrEqualExp(this.getExpression(), (Object)value.getExpression());
    }

    default public BaseProperty<E> max() {
        return PropertyFactory.createBase(FunctionExpressionFactory.maxExp(this.getExpression()), this.getType());
    }

    default public BaseProperty<E> min() {
        return PropertyFactory.createBase(FunctionExpressionFactory.minExp(this.getExpression()), this.getType());
    }

    default public Expression ltAll(ColumnSelect<E> subquery) {
        ComparableProperty.assertValidateSubqueryForComparison(subquery);
        return ExpressionFactory.lessExp(this.getExpression(), (Object)ExpressionFactory.all(subquery));
    }

    default public Expression lteAll(ColumnSelect<E> subquery) {
        ComparableProperty.assertValidateSubqueryForComparison(subquery);
        return ExpressionFactory.lessOrEqualExp(this.getExpression(), (Object)ExpressionFactory.all(subquery));
    }

    default public Expression gtAll(ColumnSelect<E> subquery) {
        ComparableProperty.assertValidateSubqueryForComparison(subquery);
        return ExpressionFactory.greaterExp(this.getExpression(), (Object)ExpressionFactory.all(subquery));
    }

    default public Expression gteAll(ColumnSelect<E> subquery) {
        ComparableProperty.assertValidateSubqueryForComparison(subquery);
        return ExpressionFactory.greaterOrEqualExp(this.getExpression(), (Object)ExpressionFactory.all(subquery));
    }

    default public Expression ltAny(ColumnSelect<E> subquery) {
        ComparableProperty.assertValidateSubqueryForComparison(subquery);
        return ExpressionFactory.lessExp(this.getExpression(), (Object)ExpressionFactory.any(subquery));
    }

    default public Expression lteAny(ColumnSelect<E> subquery) {
        ComparableProperty.assertValidateSubqueryForComparison(subquery);
        return ExpressionFactory.lessOrEqualExp(this.getExpression(), (Object)ExpressionFactory.any(subquery));
    }

    default public Expression gtAny(ColumnSelect<E> subquery) {
        ComparableProperty.assertValidateSubqueryForComparison(subquery);
        return ExpressionFactory.greaterExp(this.getExpression(), (Object)ExpressionFactory.any(subquery));
    }

    default public Expression gteAny(ColumnSelect<E> subquery) {
        ComparableProperty.assertValidateSubqueryForComparison(subquery);
        return ExpressionFactory.greaterOrEqualExp(this.getExpression(), (Object)ExpressionFactory.any(subquery));
    }

    private static <E> void assertValidateSubqueryForComparison(ColumnSelect<E> subquery) {
        if (subquery.getColumns().size() != 1) {
            throw new CayenneRuntimeException("Only single-column query could be used in the comparison.", new Object[0]);
        }
    }
}

