/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.FunctionExpressionFactory;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.Property;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.query.ColumnSelect;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.Orderings;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.reflect.PropertyUtils;

public class BaseProperty<E>
implements Property<E> {
    protected final String name;
    protected final Supplier<Expression> expressionSupplier;
    protected final Class<E> type;

    protected BaseProperty(final String name, final Expression expression, Class<? super E> type) {
        this.name = name;
        this.expressionSupplier = expression == null ? new Supplier<Expression>(){

            @Override
            public Expression get() {
                return ExpressionFactory.pathExp(name);
            }
        } : new Supplier<Expression>(){

            @Override
            public Expression get() {
                return expression.deepCopy();
            }
        };
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias() {
        if (this.getName() == null) {
            return null;
        }
        Expression exp = this.getExpression();
        if (exp instanceof ASTPath && ((ASTPath)exp).getPath().equals(this.getName())) {
            return null;
        }
        return this.getName();
    }

    @Override
    public Expression getExpression() {
        return this.expressionSupplier.get();
    }

    public int hashCode() {
        int result;
        int n = result = this.name != null ? this.name.hashCode() : this.expressionSupplier.get().hashCode();
        if (this.type != null) {
            result = 31 * result + this.type.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseProperty property = (BaseProperty)o;
        if (this.name != null ? !this.name.equals(property.name) : property.name != null) {
            return false;
        }
        if (this.name == null && !this.expressionSupplier.get().equals(property.expressionSupplier.get())) {
            return false;
        }
        return this.type == null ? property.type == null : this.type.equals(property.type);
    }

    public Expression isNull() {
        return ExpressionFactory.matchExp(this.getExpression(), null);
    }

    public Expression isNotNull() {
        return ExpressionFactory.noMatchExp(this.getExpression(), null);
    }

    public Ordering asc() {
        return new Ordering(this.getExpression(), SortOrder.ASCENDING);
    }

    public Orderings ascs() {
        return new Orderings(this.asc());
    }

    public Ordering ascInsensitive() {
        return new Ordering(this.getExpression(), SortOrder.ASCENDING_INSENSITIVE);
    }

    public Orderings ascInsensitives() {
        return new Orderings(this.ascInsensitive());
    }

    public Ordering desc() {
        return new Ordering(this.getExpression(), SortOrder.DESCENDING);
    }

    public Orderings descs() {
        return new Orderings(this.desc());
    }

    public Ordering descInsensitive() {
        return new Ordering(this.getExpression(), SortOrder.DESCENDING_INSENSITIVE);
    }

    public Orderings descInsensitives() {
        return new Orderings(this.descInsensitive());
    }

    public E getFrom(Object bean) {
        return (E)PropertyUtils.getProperty(bean, this.getName());
    }

    public List<E> getFromAll(Collection<?> beans) {
        ArrayList<E> result = new ArrayList<E>(beans.size());
        for (Object bean : beans) {
            result.add(this.getFrom(bean));
        }
        return result;
    }

    public void setIn(Object bean, E value) {
        PropertyUtils.setProperty(bean, this.getName(), value);
    }

    public void setInAll(Collection<?> beans, E value) {
        for (Object bean : beans) {
            this.setIn(bean, value);
        }
    }

    public NumericProperty<Long> count() {
        return PropertyFactory.createNumeric(FunctionExpressionFactory.countExp(this.getExpression()), Long.class);
    }

    public NumericProperty<Long> countDistinct() {
        return PropertyFactory.createNumeric(FunctionExpressionFactory.countDistinctExp(this.getExpression()), Long.class);
    }

    public BaseProperty<E> alias(String alias) {
        return PropertyFactory.createBase(alias, this.getExpression(), this.getType());
    }

    @Override
    public Class<E> getType() {
        return this.type;
    }

    public Expression isTrue() {
        return ExpressionFactory.matchExp(this.getExpression(), (Object)Boolean.TRUE);
    }

    public Expression isFalse() {
        return ExpressionFactory.matchExp(this.getExpression(), (Object)Boolean.FALSE);
    }

    public Expression eq(E value) {
        return ExpressionFactory.matchExp(this.getExpression(), value);
    }

    public Expression eq(BaseProperty<?> value) {
        return ExpressionFactory.matchExp(this.getExpression(), (Object)value.getExpression());
    }

    public Expression ne(E value) {
        return ExpressionFactory.noMatchExp(this.getExpression(), value);
    }

    public Expression ne(BaseProperty<?> value) {
        return ExpressionFactory.noMatchExp(this.getExpression(), (Object)value.getExpression());
    }

    public Expression in(E firstValue, E ... moreValues) {
        int moreValuesLength = moreValues != null ? moreValues.length : 0;
        Object[] values = new Object[moreValuesLength + 1];
        values[0] = firstValue;
        if (moreValuesLength > 0) {
            System.arraycopy(moreValues, 0, values, 1, moreValuesLength);
        }
        return ExpressionFactory.inExp(this.getExpression(), values);
    }

    public Expression nin(E firstValue, E ... moreValues) {
        int moreValuesLength = moreValues != null ? moreValues.length : 0;
        Object[] values = new Object[moreValuesLength + 1];
        values[0] = firstValue;
        if (moreValuesLength > 0) {
            System.arraycopy(moreValues, 0, values, 1, moreValuesLength);
        }
        return ExpressionFactory.notInExp(this.getExpression(), values);
    }

    public Expression in(Collection<E> values) {
        return ExpressionFactory.inExp(this.getExpression(), values);
    }

    public Expression nin(Collection<E> values) {
        return ExpressionFactory.notInExp(this.getExpression(), values);
    }

    public Expression in(ColumnSelect<? extends E> subquery) {
        return ExpressionFactory.inExp(this.getExpression(), subquery);
    }

    public Expression nin(ColumnSelect<? extends E> subquery) {
        return ExpressionFactory.notInExp(this.getExpression(), subquery);
    }

    public BaseProperty<E> enclosing() {
        return PropertyFactory.createBase(ExpressionFactory.enclosingObjectExp(this.getExpression()), this.getType());
    }

    public <T> BaseProperty<T> function(String functionName, Class<T> returnType, BaseProperty<?> ... arguments) {
        Object[] expressions = new Expression[arguments.length + 1];
        expressions[0] = this.getExpression();
        for (int i = 1; i <= arguments.length; ++i) {
            expressions[i] = arguments[i - 1].getExpression();
        }
        return PropertyFactory.createBase(FunctionExpressionFactory.functionCall(functionName, expressions), returnType);
    }

    public <T> BaseProperty<T> function(String functionName, Class<T> returnType, Object ... arguments) {
        Object[] expressions = new Object[arguments.length + 1];
        expressions[0] = this.getExpression();
        System.arraycopy(arguments, 0, expressions, 1, arguments.length);
        return PropertyFactory.createBase(FunctionExpressionFactory.functionCall(functionName, expressions), returnType);
    }

    public <T> BaseProperty<T> operator(String operator, Class<T> returnType, BaseProperty<?> ... arguments) {
        Object[] expressions = new Expression[arguments.length + 1];
        expressions[0] = this.getExpression();
        for (int i = 1; i <= arguments.length; ++i) {
            expressions[i] = arguments[i - 1].getExpression();
        }
        return PropertyFactory.createBase(FunctionExpressionFactory.operator(operator, expressions), returnType);
    }

    public <T> BaseProperty<T> operator(String operator, Class<T> returnType, Object ... arguments) {
        Object[] expressions = new Object[arguments.length + 1];
        expressions[0] = this.getExpression();
        System.arraycopy(arguments, 0, expressions, 1, arguments.length);
        return PropertyFactory.createBase(FunctionExpressionFactory.operator(operator, expressions), returnType);
    }
}

