/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlserver;

import java.util.Arrays;
import java.util.List;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.SQLTreeProcessor;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.sqlserver.SQLServerActionBuilder;
import org.apache.cayenne.dba.sqlserver.SQLServerTreeProcessor;
import org.apache.cayenne.dba.sqlserver.SQLServerTreeProcessorV12;
import org.apache.cayenne.dba.sybase.SybaseAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.resource.ResourceLocator;

public class SQLServerAdapter
extends SybaseAdapter {
    private Integer version;
    private final List<String> SYSTEM_SCHEMAS = Arrays.asList("db_accessadmin", "db_backupoperator", "db_datareader", "db_datawriter", "db_ddladmin", "db_denydatareader", "db_denydatawriter", "sys", "db_owner", "db_securityadmin", "INFORMATION_SCHEMA");
    private final List<String> SYSTEM_CATALOGS = Arrays.asList("model", "msdb", "tempdb");

    public SQLServerAdapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.server.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.server.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.server.type_factories") List<ExtendedTypeFactory> extendedTypeFactories, @Inject(value="cayenne.server.resource_locator") ResourceLocator resourceLocator, @Inject ValueObjectTypeRegistry valueObjectTypeRegistry) {
        super(runtimeProperties, defaultExtendedTypes, userExtendedTypes, extendedTypeFactories, resourceLocator, valueObjectTypeRegistry);
        this.setSupportsBatchUpdates(true);
    }

    @Override
    public boolean supportsGeneratedKeysForBatchInserts() {
        return false;
    }

    @Override
    public SQLTreeProcessor getSqlTreeProcessor() {
        if (this.getVersion() != null && this.getVersion() >= 12) {
            return new SQLServerTreeProcessorV12();
        }
        return new SQLServerTreeProcessor();
    }

    @Override
    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new SQLServerActionBuilder(node, this.getVersion()));
    }

    @Override
    public List<String> getSystemSchemas() {
        return this.SYSTEM_SCHEMAS;
    }

    @Override
    public List<String> getSystemCatalogs() {
        return this.SYSTEM_CATALOGS;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }
}

