/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.derby;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.SQLTreeProcessor;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslatorFactory;
import org.apache.cayenne.access.types.ByteType;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.access.types.JsonType;
import org.apache.cayenne.access.types.ShortType;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.derby.DerbyActionBuilder;
import org.apache.cayenne.dba.derby.DerbyEJBQLTranslatorFactory;
import org.apache.cayenne.dba.derby.DerbySQLTreeProcessor;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.resource.ResourceLocator;

public class DerbyAdapter
extends JdbcAdapter {
    static final String FOR_BIT_DATA_SUFFIX = " FOR BIT DATA";

    public DerbyAdapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.server.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.server.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.server.type_factories") List<ExtendedTypeFactory> extendedTypeFactories, @Inject(value="cayenne.server.resource_locator") ResourceLocator resourceLocator, @Inject ValueObjectTypeRegistry valueObjectTypeRegistry) {
        super(runtimeProperties, defaultExtendedTypes, userExtendedTypes, extendedTypeFactories, resourceLocator, valueObjectTypeRegistry);
        this.setSupportsGeneratedKeys(true);
        this.setSupportsBatchUpdates(true);
    }

    @Override
    public boolean supportsGeneratedKeysForBatchInserts() {
        return false;
    }

    @Override
    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new DerbyActionBuilder(node));
    }

    @Override
    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        CharType charType = new CharType(true, true);
        map.registerType(charType);
        map.registerType(new ShortType(true));
        map.registerType(new ByteType(true));
        map.registerType(new JsonType(charType, true));
    }

    @Override
    public void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        String type = DerbyAdapter.getType(this, column);
        String length = DerbyAdapter.sizeAndPrecision(this, column);
        sqlBuffer.append(this.quotingStrategy.quotedName(column));
        sqlBuffer.append(' ');
        int suffixIndex = type.indexOf(FOR_BIT_DATA_SUFFIX);
        if (!length.isEmpty() && suffixIndex > 0) {
            sqlBuffer.append(type.substring(0, suffixIndex)).append(length).append(FOR_BIT_DATA_SUFFIX);
        } else {
            sqlBuffer.append(type).append(" ").append(length);
        }
        if (column.isMandatory()) {
            sqlBuffer.append(" NOT NULL");
        }
        if (column.isGenerated()) {
            sqlBuffer.append(" GENERATED BY DEFAULT AS IDENTITY");
        }
    }

    @Override
    public boolean typeSupportsLength(int type) {
        switch (type) {
            case 2004: 
            case 2005: 
            case 2011: {
                return true;
            }
        }
        return super.typeSupportsLength(type);
    }

    @Override
    public SQLTreeProcessor getSqlTreeProcessor() {
        return new DerbySQLTreeProcessor();
    }

    @Override
    protected EJBQLTranslatorFactory createEJBQLTranslatorFactory() {
        DerbyEJBQLTranslatorFactory translatorFactory = new DerbyEJBQLTranslatorFactory();
        translatorFactory.setCaseInsensitive(this.caseInsensitiveCollations);
        return translatorFactory;
    }

    @Override
    public void bindParameter(PreparedStatement statement, ParameterBinding binding) throws SQLException, Exception {
        if (binding.getValue() == null && binding.getJdbcType() == 0) {
            statement.setNull(binding.getStatementPosition(), 12);
        } else {
            binding.setJdbcType(this.convertNTypes(binding.getJdbcType()));
            super.bindParameter(statement, binding);
        }
    }

    private int convertNTypes(int sqlType) {
        switch (sqlType) {
            case -15: {
                return 1;
            }
            case -9: {
                return 12;
            }
            case -16: {
                return -1;
            }
            case 2011: {
                return 2005;
            }
        }
        return sqlType;
    }
}

