/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import javax.xml.parsers.ParserConfigurationException;
import org.apache.cayenne.di.DIRuntimeException;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.util.Util;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLReaderProvider
implements Provider<XMLReader> {
    private final boolean supportInclude;

    public XMLReaderProvider(boolean supportInclude) {
        this.supportInclude = supportInclude;
    }

    public XMLReader get() throws DIRuntimeException {
        try {
            XMLReader reader = Util.createXmlReader();
            if (this.supportInclude) {
                reader.setFeature("http://apache.org/xml/features/xinclude", true);
            }
            return reader;
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new DIRuntimeException("Unable to create XMLReader", (Throwable)ex, new Object[0]);
        }
    }
}

