/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration;

import java.io.Serializable;
import java.util.Objects;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class DataSourceDescriptor
implements Serializable,
XMLSerializable {
    protected String jdbcDriver;
    protected String dataSourceUrl;
    protected String userName;
    protected String password;
    protected int minConnections = 1;
    protected int maxConnections = 1;

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public String getDataSourceUrl() {
        return this.dataSourceUrl;
    }

    public void setDataSourceUrl(String dataSourceUrl) {
        this.dataSourceUrl = dataSourceUrl;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getMinConnections() {
        return this.minConnections;
    }

    public void setMinConnections(int minConnections) {
        this.minConnections = minConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceDescriptor that = (DataSourceDescriptor)o;
        return this.minConnections == that.minConnections && this.maxConnections == that.maxConnections && Objects.equals(this.jdbcDriver, that.jdbcDriver) && Objects.equals(this.dataSourceUrl, that.dataSourceUrl) && Objects.equals(this.userName, that.userName) && Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(this.jdbcDriver, this.dataSourceUrl, this.userName, this.password, this.minConnections, this.maxConnections);
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder, ConfigurationNodeVisitor delegate) {
        encoder.start("data-source").start("driver").attribute("value", this.jdbcDriver).end().start("url").attribute("value", this.dataSourceUrl).end().start("login").attribute("userName", this.userName).attribute("password", this.password).end().start("connectionPool").attribute("min", this.minConnections).attribute("max", this.maxConnections).end().end();
    }

    public String toString() {
        return "[" + this.getClass().getName() + ":\n   driver: " + this.jdbcDriver + "\n   url: " + this.dataSourceUrl + "\n   user name: " + this.userName + "\n   password: **********\n   min. connections: " + this.minConnections + "\n   max. connections: " + this.maxConnections + "\n]";
    }
}

