/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.access.sqlbuilder.ExpressionNodeBuilder;
import org.apache.cayenne.access.sqlbuilder.SQLBuilder;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.translator.select.TranslationStage;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTDbPath;
import org.apache.cayenne.exp.parser.ASTPath;

class TableTreeQualifierStage
implements TranslationStage {
    TableTreeQualifierStage() {
    }

    @Override
    public void perform(TranslatorContext context) {
        context.getTableTree().visit(node -> {
            Expression dbQualifier = node.getEntity().getQualifier();
            if (dbQualifier != null) {
                String pathToRoot = node.getAttributePath().getPath();
                dbQualifier = dbQualifier.transform(input -> {
                    if (input instanceof ASTPath) {
                        Object path = ((ASTPath)input).getPath();
                        if (!pathToRoot.isEmpty()) {
                            path = pathToRoot + "." + (String)path;
                        }
                        return new ASTDbPath(path);
                    }
                    return input;
                });
                Node rootQualifier = context.getQualifierNode();
                Node translatedQualifier = context.getQualifierTranslator().translate(dbQualifier);
                if (rootQualifier != null) {
                    ExpressionNodeBuilder expressionNodeBuilder = SQLBuilder.exp(SQLBuilder.node(rootQualifier)).and(SQLBuilder.node(translatedQualifier));
                    context.setQualifierNode(expressionNodeBuilder.build());
                } else {
                    context.setQualifierNode(translatedQualifier);
                }
            }
        });
        if (context.getQualifierNode() != null) {
            context.getSelectBuilder().where(context.getQualifierNode());
        }
    }
}

