/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.EmbeddableObject;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.sqlbuilder.ExpressionNodeBuilder;
import org.apache.cayenne.access.sqlbuilder.NodeBuilder;
import org.apache.cayenne.access.sqlbuilder.SQLBuilder;
import org.apache.cayenne.access.sqlbuilder.ValueNodeBuilder;
import org.apache.cayenne.access.sqlbuilder.sqltree.BetweenNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.BitwiseNotNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.EmptyNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.EqualNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.FunctionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.InNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.LikeNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.NotEqualNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.NotNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.OpExpressionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.TextNode;
import org.apache.cayenne.access.translator.select.DefaultSelectTranslator;
import org.apache.cayenne.access.translator.select.PathTranslationResult;
import org.apache.cayenne.access.translator.select.PathTranslator;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.TraversalHandler;
import org.apache.cayenne.exp.parser.ASTCustomOperator;
import org.apache.cayenne.exp.parser.ASTDbIdPath;
import org.apache.cayenne.exp.parser.ASTDbPath;
import org.apache.cayenne.exp.parser.ASTFullObject;
import org.apache.cayenne.exp.parser.ASTFunctionCall;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.exp.parser.ASTSubquery;
import org.apache.cayenne.exp.parser.PatternMatchNode;
import org.apache.cayenne.exp.parser.SimpleNode;
import org.apache.cayenne.exp.property.Property;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;

class QualifierTranslator
implements TraversalHandler {
    private final TranslatorContext context;
    private final PathTranslator pathTranslator;
    private final Set<Object> expressionsToSkip;
    private final Deque<Node> nodeStack;
    private Node currentNode;

    QualifierTranslator(TranslatorContext context) {
        this.context = context;
        this.pathTranslator = context.getPathTranslator();
        this.expressionsToSkip = new HashSet<Object>();
        this.nodeStack = new ArrayDeque<Node>();
    }

    Node translate(Property<?> property) {
        if (property == null) {
            return null;
        }
        Node result = this.translate(property.getExpression());
        if (property.getAlias() != null) {
            return SQLBuilder.aliased(result, property.getAlias()).build();
        }
        return result;
    }

    Node translate(Expression qualifier) {
        boolean hasCurrentNode;
        if (qualifier == null) {
            return null;
        }
        EmptyNode rootNode = new EmptyNode();
        this.expressionsToSkip.clear();
        boolean bl = hasCurrentNode = this.currentNode != null;
        if (hasCurrentNode) {
            this.nodeStack.push(this.currentNode);
        }
        this.currentNode = rootNode;
        qualifier.traverse(this);
        this.currentNode = hasCurrentNode ? this.nodeStack.pop() : null;
        if (rootNode.getChildrenCount() == 1) {
            Node child = rootNode.getChild(0);
            child.setParent(null);
            return child;
        }
        return rootNode;
    }

    @Override
    public void startNode(Expression node, Expression parentNode) {
        if (this.expressionsToSkip.contains(node) || this.expressionsToSkip.contains(parentNode)) {
            return;
        }
        Node nextNode = this.expressionNodeToSqlNode(node, parentNode);
        if (nextNode == null) {
            return;
        }
        this.currentNode.addChild(nextNode);
        nextNode.setParent(this.currentNode);
        this.currentNode = nextNode;
    }

    private Node expressionNodeToSqlNode(Expression node, Expression parentNode) {
        switch (node.getType()) {
            case 36: {
                return new InNode(true);
            }
            case 10: {
                return new InNode(false);
            }
            case 9: 
            case 35: {
                return new BetweenNode(node.getType() == 35);
            }
            case 2: {
                return new NotNode();
            }
            case 39: {
                return new BitwiseNotNode();
            }
            case 3: {
                return new EqualNode();
            }
            case 4: {
                return new NotEqualNode();
            }
            case 11: 
            case 12: 
            case 37: 
            case 38: {
                PatternMatchNode patternMatchNode = (PatternMatchNode)node;
                boolean not = node.getType() == 37 || node.getType() == 38;
                return new LikeNode(patternMatchNode.isIgnoringCase(), not, patternMatchNode.getEscapeChar());
            }
            case 26: {
                String path = (String)node.getOperand(0);
                PathTranslationResult result = this.pathTranslator.translatePath(this.context.getMetadata().getObjEntity(), path);
                return this.processPathTranslationResult(node, parentNode, result);
            }
            case 27: {
                String dbPath = (String)node.getOperand(0);
                PathTranslationResult dbResult = this.pathTranslator.translatePath(this.context.getMetadata().getDbEntity(), dbPath);
                return this.processPathTranslationResult(node, parentNode, dbResult);
            }
            case 52: {
                String dbIdPath = (String)node.getOperand(0);
                PathTranslationResult dbIdResult = this.pathTranslator.translateIdPath(this.context.getMetadata().getObjEntity(), dbIdPath);
                return this.processPathTranslationResult(node, parentNode, dbIdResult);
            }
            case 45: {
                ASTFunctionCall functionCall = (ASTFunctionCall)node;
                return SQLBuilder.function(functionCall.getFunctionName(), new NodeBuilder[0]).build();
            }
            case 0: 
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                return new OpExpressionNode(this.expToStr(node.getType()));
            }
            case 21: 
            case 22: 
            case 46: {
                return new TextNode(" " + this.expToStr(node.getType()));
            }
            case 53: {
                return new OpExpressionNode(((ASTCustomOperator)node).getOperator());
            }
            case 49: {
                return new FunctionNode("EXISTS", null, false);
            }
            case 50: {
                return new FunctionNode("NOT EXISTS", null, false);
            }
            case 54: {
                return new FunctionNode("ALL", null, false);
            }
            case 55: {
                return new FunctionNode("ANY", null, false);
            }
            case 51: {
                ASTSubquery subquery = (ASTSubquery)node;
                DefaultSelectTranslator translator = new DefaultSelectTranslator(subquery.getQuery(), this.context);
                translator.translate();
                return translator.getContext().getSelectBuilder().build();
            }
            case 48: {
                Expression expression = (Expression)node.getOperand(0);
                if (this.context.getParentContext() == null) {
                    throw new CayenneRuntimeException("Unable to translate qualifier, no parent context to use for expression " + node, new Object[0]);
                }
                this.expressionsToSkip.add(expression);
                return this.context.getParentContext().getQualifierTranslator().translate(expression);
            }
            case 47: {
                ASTFullObject fullObject = (ASTFullObject)node;
                if (fullObject.getOperandCount() == 0) {
                    List<DbAttribute> dbAttributes = this.context.getMetadata().getDbEntity().getPrimaryKeys();
                    if (dbAttributes.size() > 1) {
                        throw new CayenneRuntimeException("Unable to translate reference on entity with more than one PK.", new Object[0]);
                    }
                    DbAttribute attribute = (DbAttribute)dbAttributes.iterator().next();
                    String alias = this.context.getTableTree().aliasForAttributePath(attribute.getName());
                    return SQLBuilder.table(alias).column(attribute).build();
                }
                return null;
            }
        }
        return null;
    }

    private Node processPathTranslationResult(Expression node, Expression parentNode, PathTranslationResult result) {
        if (result.getEmbeddable().isPresent()) {
            return this.createEmbeddableMatch(node, parentNode, result);
        }
        if (result.getDbRelationship().isPresent() && result.getDbAttributes().size() > 1 && result.getDbRelationship().get().getTargetEntity().getPrimaryKeys().size() > 1) {
            return this.createMultiAttributeMatch(node, parentNode, result);
        }
        if (result.getDbAttributes().isEmpty()) {
            return new EmptyNode();
        }
        String alias = this.context.getTableTree().aliasForPath(result.getLastAttributePath());
        return SQLBuilder.table(alias).column(result.getLastAttribute()).build();
    }

    private Node createEmbeddableMatch(Expression node, Expression parentNode, PathTranslationResult result) {
        Embeddable embeddable = result.getEmbeddable().orElseThrow(() -> new CayenneRuntimeException("Incorrect path '%s' translation, embeddable expected", result.getFinalPath()));
        Map<String, Object> valueSnapshot = this.getEmbeddableValueSnapshot(embeddable, node, parentNode);
        this.expressionsToSkip.add(node);
        this.expressionsToSkip.add(parentNode);
        return this.buildMultiValueComparison(result, valueSnapshot);
    }

    private Map<String, Object> getEmbeddableValueSnapshot(Embeddable embeddable, Expression node, Expression parentNode) {
        int siblings = parentNode.getOperandCount();
        for (int i = 0; i < siblings; ++i) {
            Object operand = parentNode.getOperand(i);
            if (node == operand || !(operand instanceof EmbeddableObject)) continue;
            EmbeddableObject embeddableObject = (EmbeddableObject)operand;
            HashMap<String, Object> snapshot = new HashMap<String, Object>(embeddable.getAttributes().size());
            embeddable.getAttributeMap().forEach((name, attr) -> snapshot.put(attr.getDbAttributeName(), embeddableObject.readPropertyDirectly((String)name)));
            return snapshot;
        }
        throw new CayenneRuntimeException("Embeddable attribute ObjPath isn't matched with a valid value.", new Object[0]);
    }

    private Node createMultiAttributeMatch(Expression node, Expression parentNode, PathTranslationResult result) {
        DbRelationship relationship = result.getDbRelationship().orElseThrow(() -> new CayenneRuntimeException("Incorrect path '%s' translation, relationship expected", result.getFinalPath()));
        DbEntity targetEntity = relationship.getTargetEntity();
        if (result.getDbAttributes().size() != targetEntity.getPrimaryKeys().size()) {
            throw new CayenneRuntimeException("Unsupported or incorrect mapping for relationship '%s.%s': target entity has different count of primary keys than count of joins.", relationship.getSourceEntityName(), relationship.getName());
        }
        Map<String, Object> valueSnapshot = this.getMultiAttributeValueSnapshot(node, parentNode);
        if (result.getLastAttribute().getEntity() == relationship.getSourceEntity()) {
            valueSnapshot = relationship.srcFkSnapshotWithTargetSnapshot(valueSnapshot);
        }
        Node multiValueComparison = this.buildMultiValueComparison(result, valueSnapshot);
        Node currentNodeParent = this.currentNode.getParent();
        currentNodeParent.replaceChild(currentNodeParent.getChildrenCount() - 1, multiValueComparison);
        multiValueComparison.setParent(currentNodeParent);
        this.currentNode = currentNodeParent;
        this.expressionsToSkip.add(node);
        this.expressionsToSkip.add(parentNode);
        for (int i = 0; i < parentNode.getOperandCount(); ++i) {
            this.expressionsToSkip.add(parentNode.getOperand(i));
        }
        return null;
    }

    private Map<String, Object> getMultiAttributeValueSnapshot(Expression node, Expression parentNode) {
        int siblings = parentNode.getOperandCount();
        for (int i = 0; i < siblings; ++i) {
            Object operand = parentNode.getOperand(i);
            if (node == operand) continue;
            if (operand instanceof Persistent) {
                return ((Persistent)operand).getObjectId().getIdSnapshot();
            }
            if (operand instanceof ObjectId) {
                return ((ObjectId)operand).getIdSnapshot();
            }
            if (!(operand instanceof ASTObjPath)) continue;
            throw new UnsupportedOperationException("Comparison of multiple attributes not supported for ObjPath");
        }
        throw new CayenneRuntimeException("Multi attribute ObjPath isn't matched with valid value. List or Persistent object required.", new Object[0]);
    }

    private Node buildMultiValueComparison(PathTranslationResult result, Map<String, Object> valueSnapshot) {
        ExpressionNodeBuilder expressionNodeBuilder = null;
        String path = result.getLastAttributePath();
        String alias = this.context.getTableTree().aliasForPath(path);
        for (DbAttribute attribute : result.getDbAttributes()) {
            Object nextValue = valueSnapshot.get(attribute.getName());
            ExpressionNodeBuilder eq = SQLBuilder.table(alias).column(attribute).eq(SQLBuilder.value(nextValue));
            if (expressionNodeBuilder == null) {
                expressionNodeBuilder = eq;
                continue;
            }
            expressionNodeBuilder = expressionNodeBuilder.and(eq);
        }
        return expressionNodeBuilder.build();
    }

    private boolean nodeProcessed(Expression node) {
        switch (node.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void endNode(Expression node, Expression parentNode) {
        if (this.expressionsToSkip.contains(node) || this.expressionsToSkip.contains(parentNode)) {
            return;
        }
        if (this.nodeProcessed(node) && this.currentNode.getParent() != null) {
            this.currentNode = this.currentNode.getParent();
        }
    }

    @Override
    public void objectNode(Object leaf, Expression parentNode) {
        if (this.expressionsToSkip.contains(parentNode)) {
            return;
        }
        if (parentNode.getType() == 26 || parentNode.getType() == 27 || parentNode.getType() == 52) {
            return;
        }
        ValueNodeBuilder valueNodeBuilder = SQLBuilder.value(leaf).attribute(this.findDbAttribute(parentNode));
        if (parentNode.getType() == 28) {
            valueNodeBuilder.array(true);
        }
        Node nextNode = valueNodeBuilder.build();
        this.currentNode.addChild(nextNode);
        nextNode.setParent(this.currentNode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DbAttribute findDbAttribute(Expression node) {
        if (node.getType() == 28) {
            if (node instanceof SimpleNode) {
                Expression parent = (Expression)((Object)((SimpleNode)node).jjtGetParent());
                if (parent == null) return null;
                node = parent;
            }
        } else if (node.getType() == 45) {
            return null;
        }
        PathTranslationResult result = null;
        for (int i = 0; i < node.getOperandCount(); ++i) {
            Object op = node.getOperand(i);
            if (op instanceof ASTObjPath) {
                result = this.pathTranslator.translatePath(this.context.getMetadata().getObjEntity(), ((ASTObjPath)op).getPath());
                break;
            }
            if (op instanceof ASTDbIdPath) {
                result = this.pathTranslator.translateIdPath(this.context.getMetadata().getObjEntity(), ((ASTDbIdPath)op).getPath());
                break;
            }
            if (!(op instanceof ASTDbPath)) continue;
            result = this.pathTranslator.translatePath(this.context.getMetadata().getDbEntity(), ((ASTDbPath)op).getPath());
            break;
        }
        if (result != null) return result.getLastAttribute();
        return null;
    }

    @Override
    public void finishedChild(Expression node, int childIndex, boolean hasMoreChildren) {
    }

    private String expToStr(int type) {
        switch (type) {
            case 0: {
                return "AND";
            }
            case 1: {
                return "OR";
            }
            case 5: {
                return "<";
            }
            case 7: {
                return "<=";
            }
            case 6: {
                return ">";
            }
            case 8: {
                return ">=";
            }
            case 16: {
                return "+";
            }
            case 17: 
            case 20: {
                return "-";
            }
            case 18: 
            case 46: {
                return "*";
            }
            case 19: {
                return "/";
            }
            case 40: {
                return "&";
            }
            case 41: {
                return "|";
            }
            case 42: {
                return "^";
            }
            case 39: {
                return "!";
            }
            case 43: {
                return "<<";
            }
            case 44: {
                return ">>";
            }
            case 21: {
                return "1=1";
            }
            case 22: {
                return "1=0";
            }
        }
        return "{other}";
    }
}

