/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.translator.select.DbIdPathTranslationResult;
import org.apache.cayenne.access.translator.select.DbPathProcessor;
import org.apache.cayenne.access.translator.select.ObjPathProcessor;
import org.apache.cayenne.access.translator.select.PathTranslationResult;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.map.ObjEntity;

class PathTranslator {
    private final Map<String, PathTranslationResult> objResultCache = new ConcurrentHashMap<String, PathTranslationResult>();
    private final Map<String, PathTranslationResult> dbResultCache = new ConcurrentHashMap<String, PathTranslationResult>();
    private final TranslatorContext context;

    PathTranslator(TranslatorContext context) {
        this.context = context;
    }

    PathTranslationResult translatePath(ObjEntity entity, String path, String parentPath) {
        return this.objResultCache.computeIfAbsent(parentPath + "." + entity.getName() + "." + path, k -> new ObjPathProcessor(this.context, entity, parentPath).process(path));
    }

    PathTranslationResult translatePath(ObjEntity entity, String path) {
        return this.translatePath(entity, path, null);
    }

    PathTranslationResult translatePath(DbEntity entity, String path, String parentPath, boolean flattenedPath) {
        return this.dbResultCache.computeIfAbsent(parentPath + "." + entity.getName() + "." + path, k -> new DbPathProcessor(this.context, entity, parentPath, flattenedPath).process(path));
    }

    PathTranslationResult translatePath(DbEntity entity, String path, String parentPath) {
        return this.translatePath(entity, path, parentPath, false);
    }

    PathTranslationResult translatePath(DbEntity entity, String path) {
        return this.translatePath(entity, path, null);
    }

    PathTranslationResult translateIdPath(ObjEntity entity, String path) {
        String pkName;
        int lastSegmentPos = path.lastIndexOf(46);
        String objPathPart = lastSegmentPos == -1 ? "" : path.substring(0, lastSegmentPos);
        String string = pkName = lastSegmentPos == -1 ? path : path.substring(lastSegmentPos + 1);
        if (objPathPart.isEmpty()) {
            if (pkName.isEmpty()) {
                throw new CayenneRuntimeException("Can't translate empty dbid path", new Object[0]);
            }
            DbAttribute pk = (DbAttribute)entity.getDbEntity().getAttribute(pkName);
            if (pk == null) {
                throw new CayenneRuntimeException("Can't translate dbid path '%s', no such pk", path);
            }
            return new DbIdPathTranslationResult("", pk);
        }
        PathTranslationResult dbIdResult = this.translatePath(entity, objPathPart);
        DbRelationship relationship = dbIdResult.getDbRelationship().orElseThrow(() -> new CayenneRuntimeException("Can't translate dbid path '%s', can't resolve relationship %s", path, objPathPart));
        JoinType joinType = objPathPart.endsWith("+") ? JoinType.LEFT_OUTER : JoinType.INNER;
        this.context.getTableTree().addJoinTable(dbIdResult.getFinalPath(), relationship, joinType);
        DbAttribute pk = (DbAttribute)relationship.getTargetEntity().getAttribute(pkName);
        if (pk == null) {
            throw new CayenneRuntimeException("Can't translate dbid path '%s', no such pk", path);
        }
        return new DbIdPathTranslationResult(dbIdResult.getFinalPath(), pk);
    }
}

