/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.translator.DbAttributeBinding;
import org.apache.cayenne.access.translator.select.ColumnDescriptorStage;
import org.apache.cayenne.access.translator.select.ColumnExtractorStage;
import org.apache.cayenne.access.translator.select.DistinctStage;
import org.apache.cayenne.access.translator.select.FluentSelectWrapper;
import org.apache.cayenne.access.translator.select.GroupByStage;
import org.apache.cayenne.access.translator.select.HavingTranslationStage;
import org.apache.cayenne.access.translator.select.LimitOffsetStage;
import org.apache.cayenne.access.translator.select.OrderingStage;
import org.apache.cayenne.access.translator.select.PrefetchNodeStage;
import org.apache.cayenne.access.translator.select.QualifierTranslationStage;
import org.apache.cayenne.access.translator.select.SQLGenerationStage;
import org.apache.cayenne.access.translator.select.SQLResultStage;
import org.apache.cayenne.access.translator.select.SelectTranslator;
import org.apache.cayenne.access.translator.select.TableTreeQualifierStage;
import org.apache.cayenne.access.translator.select.TableTreeStage;
import org.apache.cayenne.access.translator.select.TranslatableQueryWrapper;
import org.apache.cayenne.access.translator.select.TranslationStage;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.query.FluentSelect;

public class DefaultSelectTranslator
implements SelectTranslator {
    private static final TranslationStage[] TRANSLATION_STAGES = new TranslationStage[]{new ColumnExtractorStage(), new PrefetchNodeStage(), new OrderingStage(), new QualifierTranslationStage(), new HavingTranslationStage(), new GroupByStage(), new DistinctStage(), new LimitOffsetStage(), new ColumnDescriptorStage(), new TableTreeQualifierStage(), new TableTreeStage(), new SQLResultStage(), new SQLGenerationStage()};
    private final TranslatorContext context;

    DefaultSelectTranslator(TranslatableQueryWrapper query, TranslatorContext parentContext) {
        Objects.requireNonNull(query, "Query is null");
        Objects.requireNonNull(parentContext, "Parent context is null");
        this.context = new TranslatorContext(query, parentContext.getAdapter(), parentContext.getResolver(), parentContext);
        this.context.setSkipSQLGeneration(true);
    }

    DefaultSelectTranslator(TranslatableQueryWrapper query, DbAdapter adapter, EntityResolver entityResolver) {
        Objects.requireNonNull(query, "Query is null");
        Objects.requireNonNull(adapter, "DbAdapter is null");
        Objects.requireNonNull(entityResolver, "EntityResolver is null");
        this.context = new TranslatorContext(query, adapter, entityResolver, null);
    }

    public DefaultSelectTranslator(FluentSelect<?, ?> query, DbAdapter adapter, EntityResolver entityResolver) {
        this(new FluentSelectWrapper(query), adapter, entityResolver);
    }

    TranslatorContext getContext() {
        return this.context;
    }

    void translate() {
        for (TranslationStage stage : TRANSLATION_STAGES) {
            stage.perform(this.context);
        }
    }

    @Override
    public String getSql() {
        this.translate();
        return this.context.getFinalSQL();
    }

    @Override
    public DbAttributeBinding[] getBindings() {
        return this.context.getBindings().toArray(new DbAttributeBinding[0]);
    }

    @Override
    public Map<ObjAttribute, ColumnDescriptor> getAttributeOverrides() {
        return Collections.emptyMap();
    }

    @Override
    public ColumnDescriptor[] getResultColumns() {
        return this.context.getColumnDescriptors().toArray(new ColumnDescriptor[0]);
    }

    @Override
    public boolean isSuppressingDistinct() {
        return this.context.isDistinctSuppression();
    }

    @Override
    public boolean hasJoins() {
        return this.context.getTableCount() > 1;
    }
}

