/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.ejbql;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.translator.ejbql.EJBQLDbPathTranslator;
import org.apache.cayenne.access.translator.ejbql.EJBQLMultiColumnOperand;
import org.apache.cayenne.access.translator.ejbql.EJBQLPathTranslator;
import org.apache.cayenne.access.translator.ejbql.EJBQLTableId;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslationContext;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.util.CayenneMapEntry;

public class EJBQLSelectColumnsTranslator
extends EJBQLBaseVisitor {
    protected EJBQLTranslationContext context;
    private int expressionsCount;

    protected EJBQLSelectColumnsTranslator(EJBQLTranslationContext context) {
        this.context = context;
    }

    @Override
    public boolean visitSelectExpression(EJBQLExpression expression) {
        if (this.expressionsCount++ > 0) {
            this.context.append(",");
        }
        return true;
    }

    @Override
    public boolean visitAggregate(EJBQLExpression expression) {
        expression.visit(this.context.getTranslatorFactory().getAggregateColumnTranslator(this.context));
        return false;
    }

    @Override
    public boolean visitDbPath(EJBQLExpression expression, int finishedChildIndex) {
        EJBQLDbPathTranslator pathTranslator = new EJBQLDbPathTranslator(this.context){

            @Override
            protected void appendMultiColumnPath(EJBQLMultiColumnOperand operand) {
                throw new EJBQLException("Can't use multi-column paths in column clause", new Object[0]);
            }

            @Override
            protected void processTerminatingRelationship(DbRelationship relationship) {
                Map<String, String> xfields = null;
                if (EJBQLSelectColumnsTranslator.this.context.isAppendingResultColumns()) {
                    xfields = EJBQLSelectColumnsTranslator.this.context.nextEntityResult().getFields();
                }
                Map<String, String> fields = xfields;
                DbEntity table = relationship.getTargetEntity();
                Collection dbAttr = table.getAttributes();
                Iterator it = dbAttr.iterator();
                if (dbAttr.size() > 0) {
                    this.resolveJoin();
                }
                String alias = this.lastAlias != null ? this.lastAlias : EJBQLSelectColumnsTranslator.this.context.getTableAlias(this.idPath, EJBQLSelectColumnsTranslator.this.context.getQuotingStrategy().quotedFullyQualifiedName(table));
                boolean first = true;
                while (it.hasNext()) {
                    EJBQLSelectColumnsTranslator.this.context.append(!first ? ", " : " ");
                    DbAttribute dbAttribute = (DbAttribute)it.next();
                    EJBQLSelectColumnsTranslator.this.appendColumn(TypesMapping.getJavaBySqlType(dbAttribute), alias, dbAttribute, fields != null ? fields.get(dbAttribute.getName()) : "");
                    first = false;
                }
            }

            @Override
            protected void processTerminatingAttribute(DbAttribute attribute) {
                String alias = this.lastAlias != null ? this.lastAlias : EJBQLSelectColumnsTranslator.this.context.getTableAlias(this.idPath, EJBQLSelectColumnsTranslator.this.context.getQuotingStrategy().quotedFullyQualifiedName(this.currentEntity));
                EJBQLSelectColumnsTranslator.this.appendColumn(TypesMapping.getJavaBySqlType(attribute), alias, attribute, EJBQLSelectColumnsTranslator.this.context.isAppendingResultColumns() ? EJBQLSelectColumnsTranslator.this.context.nextColumnAlias() : "");
            }
        };
        expression.visit(pathTranslator);
        return false;
    }

    @Override
    public boolean visitPath(EJBQLExpression expression, int finishedChildIndex) {
        EJBQLPathTranslator pathTranslator = new EJBQLPathTranslator(this.context){

            @Override
            protected void appendMultiColumnPath(EJBQLMultiColumnOperand operand) {
                throw new EJBQLException("Can't use multi-column paths in column clause", new Object[0]);
            }

            @Override
            protected void processTerminatingRelationship(ObjRelationship relationship) {
                Map<String, String> xfields = null;
                if (EJBQLSelectColumnsTranslator.this.context.isAppendingResultColumns()) {
                    xfields = EJBQLSelectColumnsTranslator.this.context.nextEntityResult().getFields();
                }
                Map<String, String> fields = xfields;
                Collection dbAttr = relationship.getTargetEntity().getDbEntity().getAttributes();
                DbRelationship dbRelationship = relationship.getDbRelationships().get(0);
                DbEntity table = dbRelationship.getTargetEntity();
                Iterator it = dbAttr.iterator();
                if (dbAttr.size() > 0) {
                    this.resolveJoin();
                }
                String alias = this.lastAlias != null ? this.lastAlias : EJBQLSelectColumnsTranslator.this.context.getTableAlias(this.idPath, EJBQLSelectColumnsTranslator.this.context.getQuotingStrategy().quotedFullyQualifiedName(table));
                boolean first = true;
                while (it.hasNext()) {
                    EJBQLSelectColumnsTranslator.this.context.append(!first ? ", " : " ");
                    DbAttribute dbAttribute = (DbAttribute)it.next();
                    EJBQLSelectColumnsTranslator.this.appendColumn(TypesMapping.getJavaBySqlType(dbAttribute), alias, dbAttribute, fields != null ? fields.get(dbAttribute.getName()) : "");
                    first = false;
                }
            }

            @Override
            protected void processTerminatingAttribute(ObjAttribute attribute) {
                String alias;
                DbEntity table = this.currentEntity.getDbEntity();
                String string = alias = this.lastAlias != null ? this.lastAlias : EJBQLSelectColumnsTranslator.this.context.getTableAlias(this.idPath, EJBQLSelectColumnsTranslator.this.context.getQuotingStrategy().quotedFullyQualifiedName(table));
                if (attribute.isFlattened()) {
                    Iterator<CayenneMapEntry> dbPathIterator = attribute.getDbPathIterator();
                    EJBQLTableId lhsId = new EJBQLTableId(this.idPath);
                    while (dbPathIterator.hasNext()) {
                        CayenneMapEntry pathPart = dbPathIterator.next();
                        if (pathPart == null) {
                            throw new CayenneRuntimeException("ObjAttribute has no component: %s", attribute.getName());
                        }
                        if (!(pathPart instanceof DbAttribute)) continue;
                        DbAttribute dbAttribute = (DbAttribute)pathPart;
                        EJBQLSelectColumnsTranslator.this.appendColumn(attribute.getType(), EJBQLSelectColumnsTranslator.this.context.getTableAlias(lhsId.getEntityId(), EJBQLSelectColumnsTranslator.this.context.getQuotingStrategy().quotedFullyQualifiedName(dbAttribute.getEntity())), dbAttribute, EJBQLSelectColumnsTranslator.this.context.isAppendingResultColumns() ? EJBQLSelectColumnsTranslator.this.context.nextColumnAlias() : "");
                    }
                } else {
                    DbAttribute dbAttribute = attribute.getDbAttribute();
                    EJBQLSelectColumnsTranslator.this.appendColumn(attribute.getType(), alias, dbAttribute, EJBQLSelectColumnsTranslator.this.context.isAppendingResultColumns() ? EJBQLSelectColumnsTranslator.this.context.nextColumnAlias() : "");
                }
            }
        };
        expression.visit(pathTranslator);
        return false;
    }

    @Override
    public boolean visitIdentifier(EJBQLExpression expression) {
        expression.visit(this.context.getTranslatorFactory().getIdentifierColumnsTranslator(this.context));
        return false;
    }

    public void appendColumn(String javaType, String alias, DbAttribute dbAttribute, String columnAlias) {
        if (this.context.isAppendingResultColumns()) {
            this.context.append(" #result('");
        } else {
            this.context.append(' ');
        }
        this.context.append(alias).append('.').append(this.context.getQuotingStrategy().quotedName(dbAttribute));
        if (this.context.isAppendingResultColumns()) {
            this.context.append("' '").append(javaType).append("' '").append(columnAlias).append("' '").append(columnAlias).append("' " + dbAttribute.getType()).append(")");
        }
    }
}

