/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.ejbql;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.translator.ejbql.EJBQLDbPathTranslator;
import org.apache.cayenne.access.translator.ejbql.EJBQLMultiColumnOperand;
import org.apache.cayenne.access.translator.ejbql.EJBQLPathAnaliserTranslator;
import org.apache.cayenne.access.translator.ejbql.EJBQLPathTranslator;
import org.apache.cayenne.access.translator.ejbql.EJBQLSelectTranslator;
import org.apache.cayenne.access.translator.ejbql.EJBQLTableId;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslationContext;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.ejbql.parser.AggregateConditionNode;
import org.apache.cayenne.ejbql.parser.EJBQLDecimalLiteral;
import org.apache.cayenne.ejbql.parser.EJBQLEquals;
import org.apache.cayenne.ejbql.parser.EJBQLIdentificationVariable;
import org.apache.cayenne.ejbql.parser.EJBQLIntegerLiteral;
import org.apache.cayenne.ejbql.parser.EJBQLNamedInputParameter;
import org.apache.cayenne.ejbql.parser.EJBQLPath;
import org.apache.cayenne.ejbql.parser.EJBQLPositionalInputParameter;
import org.apache.cayenne.ejbql.parser.EJBQLSubselect;
import org.apache.cayenne.ejbql.parser.EJBQLTrimBoth;
import org.apache.cayenne.ejbql.parser.EJBQLTrimSpecification;
import org.apache.cayenne.ejbql.parser.Node;
import org.apache.cayenne.ejbql.parser.SimpleNode;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyDescriptor;

public class EJBQLConditionTranslator
extends EJBQLBaseVisitor {
    protected EJBQLTranslationContext context;
    protected List<EJBQLMultiColumnOperand> multiColumnOperands;

    public EJBQLConditionTranslator(EJBQLTranslationContext context) {
        this.context = context;
    }

    protected void addMultiColumnOperand(EJBQLMultiColumnOperand operand) {
        if (this.multiColumnOperands == null) {
            this.multiColumnOperands = new ArrayList<EJBQLMultiColumnOperand>(2);
        }
        this.multiColumnOperands.add(operand);
    }

    @Override
    public boolean visitAggregate(EJBQLExpression expression) {
        expression.visit(this.context.getTranslatorFactory().getAggregateColumnTranslator(this.context));
        return false;
    }

    @Override
    public boolean visitAnd(EJBQLExpression expression, int finishedChildIndex) {
        this.visitConditional((AggregateConditionNode)expression, " AND", finishedChildIndex);
        return true;
    }

    @Override
    public boolean visitBetween(EJBQLExpression expression, int finishedChildIndex) {
        switch (finishedChildIndex) {
            case 0: {
                if (expression.isNegated()) {
                    this.context.append(" NOT");
                }
                this.context.append(" BETWEEN");
                break;
            }
            case 1: {
                this.context.append(" AND");
            }
        }
        return true;
    }

    @Override
    public boolean visitExists(EJBQLExpression expression) {
        this.context.append(" EXISTS");
        return true;
    }

    @Override
    public boolean visitIsEmpty(EJBQLExpression expression) {
        if (expression.isNegated()) {
            this.context.pushMarker(this.context.makeDistinctMarker(), true);
            this.context.append(" DISTINCT");
            this.context.popMarker();
        }
        this.visitIsNull(expression, -1);
        for (int i = 0; i < expression.getChildrenCount(); ++i) {
            expression.getChild(i).visit(this);
            this.visitIsNull(expression, i);
        }
        return false;
    }

    @Override
    public boolean visitSize(EJBQLExpression expression) {
        if (expression.getChildrenCount() != 1) {
            throw new EJBQLException("SIZE must have exactly one child, got: " + expression.getChildrenCount(), new Object[0]);
        }
        if (!(expression.getChild(0) instanceof EJBQLPath)) {
            throw new EJBQLException("First child of SIZE must be a collection path, got: " + expression.getChild(1), new Object[0]);
        }
        QuotingStrategy quoter = this.context.getQuotingStrategy();
        EJBQLPath path = (EJBQLPath)expression.getChild(0);
        String id = path.getAbsolutePath();
        String correlatedEntityId = path.getId();
        ClassDescriptor correlatedEntityDescriptor = this.context.getEntityDescriptor(correlatedEntityId);
        String correlatedTableName = quoter.quotedFullyQualifiedName(correlatedEntityDescriptor.getEntity().getDbEntity());
        String correlatedTableAlias = this.context.getTableAlias(correlatedEntityId, correlatedTableName);
        String subqueryId = this.context.createIdAlias(id);
        ClassDescriptor targetDescriptor = this.context.getEntityDescriptor(subqueryId);
        if (expression.isNegated()) {
            this.context.append(" NOT");
        }
        this.context.append(" EXISTS (SELECT 1 FROM ");
        String subqueryTableName = quoter.quotedFullyQualifiedName(targetDescriptor.getEntity().getDbEntity());
        String subqueryRootAlias = this.context.getTableAlias(subqueryId, subqueryTableName);
        ObjRelationship relationship = correlatedEntityDescriptor.getEntity().getRelationship(path.getRelativePath());
        if (relationship.getDbRelationshipPath().contains(".")) {
            subqueryRootAlias = this.processFlattenedRelationShip(subqueryRootAlias, relationship);
        } else {
            this.context.append(subqueryTableName).append(' ').append(subqueryRootAlias);
        }
        this.context.append(" WHERE");
        DbRelationship correlatedJoinRelationship = this.context.getIncomingRelationships(new EJBQLTableId(id)).get(0);
        Iterator<DbJoin> it = correlatedJoinRelationship.getJoins().iterator();
        while (it.hasNext()) {
            DbJoin join = it.next();
            this.context.append(' ').append(subqueryRootAlias).append('.').append(join.getTargetName()).append(" = ");
            this.context.append(correlatedTableAlias).append('.').append(quoter.quotedSourceName(join));
            if (!it.hasNext()) continue;
            this.context.append(" AND");
        }
        this.context.append(")");
        return false;
    }

    @Override
    public boolean visitMemberOf(EJBQLExpression expression) {
        if (expression.getChildrenCount() != 2) {
            throw new EJBQLException("MEMBER OF must have exactly two children, got: " + expression.getChildrenCount(), new Object[0]);
        }
        if (!(expression.getChild(1) instanceof EJBQLPath)) {
            throw new EJBQLException("Second child of the MEMBER OF must be a collection path, got: " + expression.getChild(1), new Object[0]);
        }
        QuotingStrategy quoter = this.context.getQuotingStrategy();
        EJBQLPath path = (EJBQLPath)expression.getChild(1);
        String id = path.getAbsolutePath();
        String correlatedEntityId = path.getId();
        ClassDescriptor correlatedEntityDescriptor = this.context.getEntityDescriptor(correlatedEntityId);
        String correlatedTableName = quoter.quotedFullyQualifiedName(correlatedEntityDescriptor.getEntity().getDbEntity());
        String correlatedTableAlias = this.context.getTableAlias(correlatedEntityId, correlatedTableName);
        String subqueryId = this.context.createIdAlias(id);
        ClassDescriptor targetDescriptor = this.context.getEntityDescriptor(subqueryId);
        if (expression.isNegated()) {
            this.context.append(" NOT");
        }
        this.context.append(" EXISTS (SELECT 1 FROM ");
        String subqueryTableName = quoter.quotedFullyQualifiedName(targetDescriptor.getEntity().getDbEntity());
        String subqueryRootAlias = this.context.getTableAlias(subqueryId, subqueryTableName);
        ObjRelationship relationship = correlatedEntityDescriptor.getEntity().getRelationship(path.getRelativePath());
        if (relationship.getDbRelationshipPath().contains(".")) {
            subqueryRootAlias = this.processFlattenedRelationShip(subqueryRootAlias, relationship);
        } else {
            this.context.append(subqueryTableName).append(' ').append(subqueryRootAlias);
        }
        this.context.append(" WHERE");
        DbRelationship correlatedJoinRelationship = this.context.getIncomingRelationships(new EJBQLTableId(id)).get(0);
        for (DbJoin join : correlatedJoinRelationship.getJoins()) {
            this.context.append(' ').append(subqueryRootAlias).append('.').append(join.getTargetName()).append(" = ");
            this.context.append(correlatedTableAlias).append('.').append(quoter.quotedSourceName(join));
            this.context.append(" AND");
        }
        EJBQLEquals equals = new EJBQLEquals(-1);
        EJBQLIdentificationVariable identifier = new EJBQLIdentificationVariable(-1);
        identifier.setText(subqueryId);
        equals.jjtAddChild(identifier, 0);
        equals.jjtAddChild((Node)expression.getChild(0), 1);
        equals.visit(this);
        this.context.append(")");
        return false;
    }

    private String processFlattenedRelationShip(String subqueryRootAlias, ObjRelationship relationship) {
        QuotingStrategy quoter = this.context.getQuotingStrategy();
        List<DbRelationship> dbRelationships = relationship.getDbRelationships();
        for (int i = dbRelationships.size() - 1; i > 0; --i) {
            String subqueryTargetAlias;
            DbRelationship dbRelationship = dbRelationships.get(i);
            String subqueryTargetTableName = quoter.quotedFullyQualifiedName(dbRelationship.getTargetEntity());
            if (i == dbRelationships.size() - 1) {
                subqueryTargetAlias = subqueryRootAlias;
                this.context.append(subqueryTargetTableName).append(' ').append(subqueryTargetAlias);
            } else {
                subqueryTargetAlias = this.context.getTableAlias(subqueryTargetTableName, subqueryTargetTableName);
            }
            this.context.append(" JOIN ");
            String subquerySourceTableName = quoter.quotedFullyQualifiedName((DbEntity)dbRelationship.getSourceEntity());
            String subquerySourceAlias = this.context.getTableAlias(subquerySourceTableName, subquerySourceTableName);
            this.context.append(subquerySourceTableName).append(' ').append(subquerySourceAlias);
            this.context.append(" ON (");
            List<DbJoin> joins = dbRelationship.getJoins();
            Iterator<DbJoin> it = joins.iterator();
            while (it.hasNext()) {
                DbJoin join = it.next();
                this.context.append(' ').append(subqueryTargetAlias).append('.').append(join.getTargetName()).append(" = ");
                this.context.append(subquerySourceAlias).append('.').append(join.getSourceName());
                if (!it.hasNext()) continue;
                this.context.append(" AND");
            }
            this.context.append(" )");
            subqueryRootAlias = subquerySourceAlias;
        }
        return subqueryRootAlias;
    }

    @Override
    public boolean visitAll(EJBQLExpression expression) {
        this.context.append(" ALL");
        return true;
    }

    @Override
    public boolean visitAny(EJBQLExpression expression) {
        this.context.append(" ANY");
        return true;
    }

    @Override
    public boolean visitOr(EJBQLExpression expression, int finishedChildIndex) {
        this.visitConditional((AggregateConditionNode)expression, " OR", finishedChildIndex);
        return true;
    }

    protected boolean checkNullParameter(EJBQLExpression expression, String toAppend) {
        if (expression.getChildrenCount() == 2) {
            EJBQLPositionalInputParameter par;
            if (expression.getChild(1) instanceof EJBQLNamedInputParameter) {
                EJBQLNamedInputParameter par2 = (EJBQLNamedInputParameter)expression.getChild(1);
                if (this.context.namedParameters.containsKey(par2.getText()) && this.context.namedParameters.get(par2.getText()) == null) {
                    this.context.append(toAppend);
                    return true;
                }
            } else if (expression.getChild(1) instanceof EJBQLPositionalInputParameter && this.context.positionalParameters.containsKey((par = (EJBQLPositionalInputParameter)expression.getChild(1)).getPosition()) && this.context.positionalParameters.get(par.getPosition()) == null) {
                this.context.append(toAppend);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean visitEquals(EJBQLExpression expression, int finishedChildIndex) {
        switch (finishedChildIndex) {
            case 0: {
                if (this.checkNullParameter(expression, " IS NULL")) {
                    return false;
                }
                this.context.append(" =");
                break;
            }
            case 1: {
                if (this.multiColumnOperands == null) break;
                if (this.multiColumnOperands.size() != 2) {
                    throw new EJBQLException("Invalid multi-column equals expression. Expected 2 multi-column operands, got " + this.multiColumnOperands.size(), new Object[0]);
                }
                this.context.trim(2);
                EJBQLMultiColumnOperand lhs = this.multiColumnOperands.get(0);
                EJBQLMultiColumnOperand rhs = this.multiColumnOperands.get(1);
                Iterator it = lhs.getKeys().iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    lhs.appendValue(key);
                    this.context.append(" =");
                    rhs.appendValue(key);
                    if (!it.hasNext()) continue;
                    this.context.append(" AND");
                }
                this.multiColumnOperands = null;
            }
        }
        return true;
    }

    @Override
    public boolean visitNamedInputParameterForIn(EJBQLExpression expression) {
        List<String> parameters = this.context.bindNamedParameterFlatteningCollection(expression.getText());
        if (0 == parameters.size()) {
            throw new IllegalStateException("it is not possible for a named parameter to not be bound");
        }
        for (int i = 0; i < parameters.size(); ++i) {
            if (0 != i) {
                this.context.append(',');
            }
            this.processParameter(parameters.get(i), expression);
        }
        return true;
    }

    @Override
    public boolean visitNamedInputParameter(EJBQLExpression expression) {
        String parameter = this.context.bindNamedParameter(expression.getText());
        this.processParameter(parameter, expression);
        return true;
    }

    @Override
    public boolean visitNot(EJBQLExpression expression) {
        this.context.append(" NOT");
        return true;
    }

    @Override
    public boolean visitNotEquals(EJBQLExpression expression, int finishedChildIndex) {
        switch (finishedChildIndex) {
            case 0: {
                if (this.checkNullParameter(expression, " IS NOT NULL")) {
                    return false;
                }
                this.context.append(" <>");
                break;
            }
            case 1: {
                if (this.multiColumnOperands == null) break;
                if (this.multiColumnOperands.size() != 2) {
                    throw new EJBQLException("Invalid multi-column equals expression. Expected 2 multi-column operands, got " + this.multiColumnOperands.size(), new Object[0]);
                }
                this.context.trim(3);
                EJBQLMultiColumnOperand lhs = this.multiColumnOperands.get(0);
                EJBQLMultiColumnOperand rhs = this.multiColumnOperands.get(1);
                Iterator it = lhs.getKeys().iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    lhs.appendValue(key);
                    this.context.append(" <>");
                    rhs.appendValue(key);
                    if (!it.hasNext()) continue;
                    this.context.append(" OR");
                }
                this.multiColumnOperands = null;
            }
        }
        return true;
    }

    @Override
    public boolean visitGreaterThan(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex == 0) {
            this.context.append(" >");
        }
        return true;
    }

    @Override
    public boolean visitGreaterOrEqual(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex == 0) {
            this.context.append(" >=");
        }
        return true;
    }

    @Override
    public boolean visitLessOrEqual(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex == 0) {
            this.context.append(" <=");
        }
        return true;
    }

    @Override
    public boolean visitLessThan(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex == 0) {
            this.context.append(" <");
        }
        return true;
    }

    @Override
    public boolean visitLike(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex == 0) {
            if (this.checkNullParameter(expression, " IS NULL")) {
                return false;
            }
            if (expression.isNegated()) {
                this.context.append(" NOT");
            }
            this.context.append(" LIKE");
        }
        return true;
    }

    @Override
    public boolean visitIn(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex == 0) {
            if (expression.isNegated()) {
                this.context.append(" NOT");
            }
            this.context.append(" IN");
            if (expression.getChildrenCount() == 2 && expression.getChild(1) instanceof EJBQLSubselect) {
                this.visitSubselect(expression.getChild(1));
                return false;
            }
            this.context.append(" (");
        } else if (finishedChildIndex == expression.getChildrenCount() - 1) {
            this.context.append(")");
        } else if (finishedChildIndex > 0) {
            this.context.append(',');
        }
        return true;
    }

    void visitConditional(AggregateConditionNode e, String afterText, int childIndex) {
        if (childIndex == -1 && this.needBracket(e)) {
            this.context.append(" (");
        }
        this.afterChild(e, afterText, childIndex);
        if (childIndex == e.getChildrenCount() - 1 && this.needBracket(e)) {
            this.context.append(")");
        }
    }

    boolean needBracket(AggregateConditionNode e) {
        return e.jjtGetParent() instanceof AggregateConditionNode && e.getPriority() > ((AggregateConditionNode)e.jjtGetParent()).getPriority();
    }

    protected void afterChild(EJBQLExpression e, String text, int childIndex) {
        if (childIndex >= 0 && childIndex + 1 < e.getChildrenCount()) {
            this.context.append(text);
        }
    }

    @Override
    public boolean visitIdentificationVariable(EJBQLExpression expression) {
        ClassDescriptor descriptor = this.context.getEntityDescriptor(expression.getText());
        if (descriptor == null) {
            throw new EJBQLException("Invalid identification variable: " + expression.getText(), new Object[0]);
        }
        DbEntity table = descriptor.getEntity().getDbEntity();
        String alias = this.context.getTableAlias(expression.getText(), this.context.getQuotingStrategy().quotedFullyQualifiedName(table));
        List<DbAttribute> pks = table.getPrimaryKeys();
        if (pks.size() != 1) {
            throw new EJBQLException("Multi-column PK to-many matches are not yet supported.", new Object[0]);
        }
        DbAttribute pk = (DbAttribute)pks.iterator().next();
        this.context.append(' ').append(alias).append('.').append(this.context.getQuotingStrategy().quotedName(pk));
        return false;
    }

    @Override
    public boolean visitDbPath(EJBQLExpression expression, int finishedChildIndex) {
        expression.visit(new EJBQLDbPathTranslator(this.context){

            @Override
            protected void appendMultiColumnPath(EJBQLMultiColumnOperand operand) {
                EJBQLConditionTranslator.this.addMultiColumnOperand(operand);
            }
        });
        return false;
    }

    @Override
    public boolean visitPath(EJBQLExpression expression, int finishedChildIndex) {
        expression.visit(new EJBQLPathTranslator(this.context){

            @Override
            protected void appendMultiColumnPath(EJBQLMultiColumnOperand operand) {
                EJBQLConditionTranslator.this.addMultiColumnOperand(operand);
            }
        });
        return false;
    }

    @Override
    public boolean visitIntegerLiteral(EJBQLIntegerLiteral expression) {
        if (expression.getText() == null) {
            this.context.append("null");
        } else {
            Long longValue;
            Object text = expression.getText();
            if (expression.isNegative() && text != null) {
                text = ((String)text).startsWith("-") ? ((String)text).substring(1) : "-" + (String)text;
            }
            try {
                longValue = Long.valueOf((String)text);
            }
            catch (NumberFormatException nfex) {
                throw new EJBQLException("Invalid integer: " + expression.getText(), new Object[0]);
            }
            if (longValue > Integer.MAX_VALUE) {
                String var = this.context.bindParameter(longValue);
                this.context.append(" #bind($").append(var).append(" 'BIGINT')");
            } else {
                String var = this.context.bindParameter(longValue.intValue());
                this.context.append(" #bind($").append(var).append(" 'INTEGER')");
            }
        }
        return true;
    }

    @Override
    public boolean visitDecimalLiteral(EJBQLDecimalLiteral expression) {
        if (expression.getText() == null) {
            this.context.append("null");
        } else {
            BigDecimal value;
            Object text = expression.getText();
            if (expression.isNegative() && text != null) {
                text = ((String)text).startsWith("-") ? ((String)text).substring(1) : "-" + (String)text;
            }
            try {
                value = new BigDecimal((String)text);
            }
            catch (NumberFormatException nfex) {
                throw new EJBQLException("Invalid decimal: " + expression.getText(), new Object[0]);
            }
            String var = this.context.bindParameter(value);
            this.context.append(" #bind($").append(var).append(" 'DECIMAL')");
        }
        return true;
    }

    @Override
    public boolean visitEscapeCharacter(EJBQLExpression expression) {
        this.context.append(" ESCAPE ").append(expression.getText());
        return false;
    }

    @Override
    public boolean visitIsNull(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex == 0) {
            this.context.append(expression.isNegated() ? " IS NOT NULL" : " IS NULL");
        }
        return true;
    }

    @Override
    public boolean visitPositionalInputParameterForIn(EJBQLPositionalInputParameter expression) {
        List<String> parameters = this.context.bindPositionalParameterFlatteningCollection(expression.getPosition());
        if (0 == parameters.size()) {
            throw new IllegalStateException("it is not possible for a positional parameter to not be bound");
        }
        for (int i = 0; i < parameters.size(); ++i) {
            if (0 != i) {
                this.context.append(',');
            }
            this.processParameter(parameters.get(i), expression);
        }
        return true;
    }

    @Override
    public boolean visitPositionalInputParameter(EJBQLPositionalInputParameter expression) {
        String parameter = this.context.bindPositionalParameter(expression.getPosition());
        this.processParameter(parameter, expression);
        return true;
    }

    @Override
    public boolean visitBooleanLiteral(EJBQLExpression expression) {
        if (expression.getText() == null) {
            this.context.append("null");
        } else {
            Boolean value = Boolean.valueOf(expression.getText());
            String var = this.context.bindParameter(value);
            this.context.append(" #bind($").append(var).append(" 'BOOLEAN')");
        }
        return true;
    }

    @Override
    public boolean visitStringLiteral(EJBQLExpression expression) {
        if (expression.getText() == null) {
            this.context.append("null");
        } else {
            this.context.append(" #bind(").append(expression.getText()).append(" 'VARCHAR')");
        }
        return true;
    }

    @Override
    public boolean visitSubselect(EJBQLExpression expression) {
        this.context.onSubselect();
        this.context.append(" (");
        expression.visit(new EJBQLSelectTranslator(this.context));
        this.context.append(')');
        return false;
    }

    private void processParameter(String boundName, EJBQLExpression expression) {
        Object object = this.context.getBoundParameter(boundName);
        Map map = null;
        if (object instanceof Persistent) {
            map = ((Persistent)object).getObjectId().getIdSnapshot();
        } else if (object instanceof ObjectId) {
            map = ((ObjectId)object).getIdSnapshot();
        } else if (object instanceof Map) {
            map = (Map)object;
        }
        if (map != null) {
            if (map.size() == 1) {
                this.context.rebindParameter(boundName, map.values().iterator().next());
            } else {
                this.addMultiColumnOperand(EJBQLMultiColumnOperand.getObjectOperand(this.context, map));
                return;
            }
        }
        if (object != null) {
            this.context.append(" #bind($").append(boundName).append(")");
        } else {
            String type = null;
            Node parent = ((SimpleNode)expression).jjtGetParent();
            this.context.pushMarker("@processParameter", true);
            EJBQLPathAnaliserTranslator translator = new EJBQLPathAnaliserTranslator(this.context);
            parent.visit(translator);
            translator.visitPath(parent, parent.getChildrenCount());
            String id = translator.idPath;
            if (id != null) {
                ClassDescriptor descriptor = this.context.getEntityDescriptor(id);
                if (descriptor == null) {
                    throw new EJBQLException("Unmapped id variable: " + id, new Object[0]);
                }
                String pathChunk = translator.lastPathComponent;
                PropertyDescriptor property = descriptor.getProperty(pathChunk);
                if (property instanceof AttributeProperty) {
                    String atrType = ((AttributeProperty)property).getAttribute().getType();
                    type = TypesMapping.getSqlNameByType(TypesMapping.getSqlTypeByJava(atrType));
                }
            }
            this.context.popMarker();
            if (type == null) {
                type = "VARCHAR";
            }
            this.context.append(" #bind($").append(boundName).append(" '" + type + "')");
        }
    }

    @Override
    public boolean visitAdd(EJBQLExpression expression, int finishedChildIndex) {
        switch (finishedChildIndex) {
            case -1: {
                this.context.append(" (");
                break;
            }
            case 0: {
                this.context.append(" +");
                break;
            }
            case 1: {
                this.context.append(")");
            }
        }
        return true;
    }

    @Override
    public boolean visitSubtract(EJBQLExpression expression, int finishedChildIndex) {
        switch (finishedChildIndex) {
            case -1: {
                this.context.append(" (");
                break;
            }
            case 0: {
                this.context.append(" -");
                break;
            }
            case 1: {
                this.context.append(")");
            }
        }
        return true;
    }

    @Override
    public boolean visitMultiply(EJBQLExpression expression, int finishedChildIndex) {
        switch (finishedChildIndex) {
            case -1: {
                this.context.append(" (");
                break;
            }
            case 0: {
                this.context.append(" *");
                break;
            }
            case 1: {
                this.context.append(")");
            }
        }
        return true;
    }

    @Override
    public boolean visitDivide(EJBQLExpression expression, int finishedChildIndex) {
        switch (finishedChildIndex) {
            case -1: {
                this.context.append(" (");
                break;
            }
            case 0: {
                this.context.append(" /");
                break;
            }
            case 1: {
                this.context.append(")");
            }
        }
        return true;
    }

    @Override
    public boolean visitCurrentDate(EJBQLExpression expression) {
        this.context.append(" {fn CURDATE()}");
        return false;
    }

    @Override
    public boolean visitCurrentTime(EJBQLExpression expression) {
        this.context.append(" {fn CURTIME()}");
        return false;
    }

    @Override
    public boolean visitCurrentTimestamp(EJBQLExpression expression) {
        this.context.append(" {fn NOW()}");
        return false;
    }

    @Override
    public boolean visitAbs(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex < 0) {
            this.context.append(" {fn ABS(");
        } else if (finishedChildIndex + 1 == expression.getChildrenCount()) {
            this.context.append(")}");
        }
        return true;
    }

    @Override
    public boolean visitSqrt(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex < 0) {
            this.context.append(" {fn SQRT(");
        } else if (finishedChildIndex + 1 == expression.getChildrenCount()) {
            this.context.append(")}");
        }
        return true;
    }

    @Override
    public boolean visitMod(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex < 0) {
            this.context.append(" {fn MOD(");
        } else if (finishedChildIndex + 1 == expression.getChildrenCount()) {
            this.context.append(")}");
        } else {
            this.context.append(',');
        }
        return true;
    }

    @Override
    public boolean visitConcat(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex < 0) {
            this.context.append(" {fn CONCAT(");
        } else if (finishedChildIndex + 1 == expression.getChildrenCount()) {
            this.context.append(")}");
        } else {
            this.context.append(',');
        }
        return true;
    }

    @Override
    public boolean visitSubstring(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex < 0) {
            this.context.append(" {fn SUBSTRING(");
        } else if (finishedChildIndex + 1 == expression.getChildrenCount()) {
            this.context.append(")}");
        } else {
            this.context.append(',');
        }
        return true;
    }

    @Override
    public boolean visitLower(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex < 0) {
            this.context.append(" {fn LCASE(");
        } else if (finishedChildIndex + 1 == expression.getChildrenCount()) {
            this.context.append(")}");
        }
        return true;
    }

    @Override
    public boolean visitUpper(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex < 0) {
            this.context.append(" {fn UCASE(");
        } else if (finishedChildIndex + 1 == expression.getChildrenCount()) {
            this.context.append(")}");
        }
        return true;
    }

    @Override
    public boolean visitLength(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex < 0) {
            this.context.append(" {fn LENGTH(");
        } else if (finishedChildIndex + 1 == expression.getChildrenCount()) {
            this.context.append(")}");
        }
        return true;
    }

    @Override
    public boolean visitLocate(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex < 0) {
            this.context.append(" {fn LOCATE(");
        } else if (finishedChildIndex + 1 == expression.getChildrenCount()) {
            this.context.append(")}");
        } else {
            this.context.append(',');
        }
        return true;
    }

    @Override
    public boolean visitTrim(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex < 0) {
            if (!(expression.getChild(0) instanceof EJBQLTrimSpecification)) {
                this.context.append(" {fn LTRIM({fn RTRIM(");
            }
        } else if (finishedChildIndex + 1 == expression.getChildrenCount()) {
            if (!(expression.getChild(0) instanceof EJBQLTrimSpecification) || expression.getChild(0) instanceof EJBQLTrimBoth) {
                this.context.append(")})}");
            } else {
                this.context.append(")}");
            }
        }
        return true;
    }

    @Override
    public boolean visitTrimCharacter(EJBQLExpression expression) {
        if (!"' '".equals(expression.getText())) {
            throw new UnsupportedOperationException("TRIM character other than space is not supported by a generic adapter: " + expression.getText());
        }
        return false;
    }

    @Override
    public boolean visitTrimLeading(EJBQLExpression expression) {
        this.context.append(" {fn LTRIM(");
        return false;
    }

    @Override
    public boolean visitTrimTrailing(EJBQLExpression expression) {
        this.context.append(" {fn RTRIM(");
        return false;
    }

    @Override
    public boolean visitTrimBoth(EJBQLExpression expression) {
        this.context.append(" {fn LTRIM({fn RTRIM(");
        return false;
    }
}

