/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.flush.ArcValuesCreationHandler;
import org.apache.cayenne.access.flush.DbRowOpFactory;
import org.apache.cayenne.access.flush.operation.DbRowOpType;
import org.apache.cayenne.access.flush.operation.DbRowOpWithValues;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;

class ValuesCreationHandler
extends ArcValuesCreationHandler {
    ValuesCreationHandler(DbRowOpFactory factory, DbRowOpType defaultType) {
        super(factory, defaultType);
    }

    @Override
    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        DbRowOpWithValues dbRow;
        ObjectId id = (ObjectId)nodeId;
        ObjEntity entity = this.factory.getDescriptor().getEntity();
        if (entity.isReadOnly()) {
            throw new CayenneRuntimeException("Attempt to modify object(s) mapped to a read-only entity: '%s'. Can't commit changes.", entity.getName());
        }
        ObjAttribute attribute = entity.getAttribute(property);
        DbEntity dbEntity = entity.getDbEntity();
        if (attribute.isFlattened()) {
            id = this.processFlattenedPath(id, null, dbEntity, attribute.getDbAttributePath(), newValue != null);
        }
        if (id == null) {
            throw new CayenneRuntimeException("Unable to resolve DB row PK for object's %s update of property '%s'", nodeId, property);
        }
        DbAttribute dbAttribute = attribute.getDbAttribute();
        if (dbAttribute.isPrimaryKey() && (!(newValue instanceof Number) || ((Number)newValue).longValue() != 0L)) {
            id.getReplacementIdMap().put(dbAttribute.getName(), newValue);
        }
        if ((dbRow = (DbRowOpWithValues)this.factory.get(id)) != null) {
            dbRow.getValues().addValue(dbAttribute, newValue, false);
        }
    }
}

