/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.PrefetchProcessorNode;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.util.XMLSerializable;

class PrefetchProcessorJointNode
extends PrefetchProcessorNode {
    ColumnDescriptor[] columns;
    int[] idIndices;
    int rowCapacity;
    Map<Map, Persistent> resolved;
    List<DataRow> resolvedRows;

    PrefetchProcessorJointNode(PrefetchProcessorNode parent, String segmentPath) {
        super(parent, segmentPath);
    }

    @Override
    void afterInit() {
        int capacity;
        super.afterInit();
        int n = capacity = this.dataRows != null ? this.dataRows.size() : 10;
        if (capacity > 100) {
            capacity /= 2;
        }
        this.objects = new ArrayList(capacity);
        this.resolved = new HashMap<Map, Persistent>(capacity);
        this.resolvedRows = new ArrayList<DataRow>(capacity);
        this.buildRowMapping();
        this.buildPKIndex();
    }

    List<DataRow> getResolvedRows() {
        return this.resolvedRows;
    }

    void addObject(Persistent object, DataRow row) {
        this.objects.add(object);
        this.resolvedRows.add(row);
    }

    Map<String, Object> idFromFlatRow(DataRow flatRow) {
        TreeMap<String, Object> id = new TreeMap<String, Object>();
        for (int idIndex : this.idIndices) {
            Object value = flatRow.get(this.columns[idIndex].getDataRowKey());
            id.put(this.columns[idIndex].getName(), value);
        }
        return id;
    }

    Persistent getResolved(Map id) {
        return this.resolved.get(id);
    }

    void putResolved(Map id, Persistent object) {
        this.resolved.put(id, object);
    }

    DataRow rowFromFlatRow(DataRow flatRow) {
        DataRow row = new DataRow(this.rowCapacity);
        for (ColumnDescriptor column : this.columns) {
            row.put(column.getName(), flatRow.get(column.getDataRowKey()));
        }
        ClassDescriptor descriptor = this.resolver.getDescriptor();
        ObjEntity entity = descriptor.getEntityInheritanceTree().entityMatchingRow(row);
        row.setEntityName(entity == null ? null : entity.getName());
        return row;
    }

    private void buildRowMapping() {
        Object prefix;
        final TreeMap<String, ColumnDescriptor> targetSource = new TreeMap<String, ColumnDescriptor>();
        PrefetchTreeNode jointRoot = this;
        while (jointRoot.getParent() != null && !jointRoot.isDisjointPrefetch() && !jointRoot.isDisjointByIdPrefetch()) {
            jointRoot = jointRoot.getParent();
        }
        if (jointRoot != this) {
            Expression objectPath = ExpressionFactory.exp(this.getPath(jointRoot), new Object[0]);
            Iterator<XMLSerializable> translated = (ASTPath)((PrefetchProcessorNode)jointRoot).getResolver().getEntity().translateToDbPath(objectPath);
            prefix = ((ASTPath)((Object)translated)).getOperand(0) + ".";
        } else {
            prefix = "";
        }
        if (this.getParent() != null && !this.getParent().isPhantom() && this.getIncoming() != null && !this.getIncoming().getRelationship().isFlattened()) {
            DbRelationship r = this.getIncoming().getRelationship().getDbRelationships().get(0);
            for (DbJoin join : r.getJoins()) {
                this.appendColumn(targetSource, join.getTargetName(), (String)prefix + join.getTargetName());
            }
        }
        ClassDescriptor descriptor = this.resolver.getDescriptor();
        descriptor.visitAllProperties(new PropertyVisitor((String)prefix){
            final /* synthetic */ String val$prefix;
            {
                this.val$prefix = string;
            }

            @Override
            public boolean visitAttribute(AttributeProperty property) {
                String target = property.getAttribute().getDbAttributePath();
                if (!property.getAttribute().isLazy()) {
                    PrefetchProcessorJointNode.this.appendColumn(targetSource, target, this.val$prefix + target);
                }
                return true;
            }

            @Override
            public boolean visitToMany(ToManyProperty property) {
                return this.visitRelationship(property);
            }

            @Override
            public boolean visitToOne(ToOneProperty property) {
                return this.visitRelationship(property);
            }

            private boolean visitRelationship(ArcProperty arc) {
                DbRelationship dbRel = arc.getRelationship().getDbRelationships().get(0);
                for (DbAttribute attribute : dbRel.getSourceAttributes()) {
                    String target = attribute.getName();
                    PrefetchProcessorJointNode.this.appendColumn(targetSource, target, this.val$prefix + target);
                }
                return true;
            }
        });
        for (String pkName : descriptor.getEntity().getPrimaryKeyNames()) {
            this.appendColumn(targetSource, pkName, (String)prefix + pkName);
        }
        for (ObjAttribute column : descriptor.getDiscriminatorColumns()) {
            String target = column.getDbAttributePath();
            this.appendColumn(targetSource, target, (String)prefix + target);
        }
        int size = targetSource.size();
        this.rowCapacity = (int)Math.ceil((double)size / 0.75);
        this.columns = new ColumnDescriptor[size];
        targetSource.values().toArray(this.columns);
    }

    private ColumnDescriptor appendColumn(Map<String, ColumnDescriptor> map, String name, String label) {
        ColumnDescriptor column = map.get(name);
        if (column == null) {
            column = new ColumnDescriptor();
            column.setName(name);
            column.setDataRowKey(label);
            map.put(name, column);
        }
        return column;
    }

    private void buildPKIndex() {
        List<DbAttribute> pks = this.getResolver().getEntity().getDbEntity().getPrimaryKeys();
        this.idIndices = new int[pks.size()];
        Arrays.fill(this.idIndices, -1);
        Iterator it = pks.iterator();
        for (int i = 0; i < this.idIndices.length; ++i) {
            DbAttribute pk = (DbAttribute)it.next();
            for (int j = 0; j < this.columns.length; ++j) {
                if (!pk.getName().equals(this.columns[j].getName())) continue;
                this.idIndices[i] = j;
                break;
            }
            if (this.idIndices[i] != -1) continue;
            throw new CayenneRuntimeException("PK column is not part of result row: %s", pk.getName());
        }
    }
}

