/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.Column;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class CqlRow
implements TBase<CqlRow, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("CqlRow");
    private static final TField KEY_FIELD_DESC = new TField("key", 11, 1);
    private static final TField COLUMNS_FIELD_DESC = new TField("columns", 15, 2);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public ByteBuffer key;
    public List<Column> columns;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public CqlRow() {
    }

    public CqlRow(ByteBuffer key, List<Column> columns) {
        this();
        this.key = key;
        this.columns = columns;
    }

    public CqlRow(CqlRow other) {
        if (other.isSetKey()) {
            this.key = TBaseHelper.copyBinary((ByteBuffer)other.key);
        }
        if (other.isSetColumns()) {
            ArrayList<Column> __this__columns = new ArrayList<Column>();
            for (Column other_element : other.columns) {
                __this__columns.add(new Column(other_element));
            }
            this.columns = __this__columns;
        }
    }

    public CqlRow deepCopy() {
        return new CqlRow(this);
    }

    public void clear() {
        this.key = null;
        this.columns = null;
    }

    public byte[] getKey() {
        this.setKey(TBaseHelper.rightSize((ByteBuffer)this.key));
        return this.key == null ? null : this.key.array();
    }

    public ByteBuffer bufferForKey() {
        return this.key;
    }

    public CqlRow setKey(byte[] key) {
        this.setKey(key == null ? (ByteBuffer)null : ByteBuffer.wrap(key));
        return this;
    }

    public CqlRow setKey(ByteBuffer key) {
        this.key = key;
        return this;
    }

    public void unsetKey() {
        this.key = null;
    }

    public boolean isSetKey() {
        return this.key != null;
    }

    public void setKeyIsSet(boolean value) {
        if (!value) {
            this.key = null;
        }
    }

    public int getColumnsSize() {
        return this.columns == null ? 0 : this.columns.size();
    }

    public Iterator<Column> getColumnsIterator() {
        return this.columns == null ? null : this.columns.iterator();
    }

    public void addToColumns(Column elem) {
        if (this.columns == null) {
            this.columns = new ArrayList<Column>();
        }
        this.columns.add(elem);
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public CqlRow setColumns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    public void unsetColumns() {
        this.columns = null;
    }

    public boolean isSetColumns() {
        return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
        if (!value) {
            this.columns = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case KEY: {
                if (value == null) {
                    this.unsetKey();
                    break;
                }
                this.setKey((ByteBuffer)value);
                break;
            }
            case COLUMNS: {
                if (value == null) {
                    this.unsetColumns();
                    break;
                }
                this.setColumns((List)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case KEY: {
                return this.getKey();
            }
            case COLUMNS: {
                return this.getColumns();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case KEY: {
                return this.isSetKey();
            }
            case COLUMNS: {
                return this.isSetColumns();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof CqlRow) {
            return this.equals((CqlRow)that);
        }
        return false;
    }

    public boolean equals(CqlRow that) {
        if (that == null) {
            return false;
        }
        boolean this_present_key = this.isSetKey();
        boolean that_present_key = that.isSetKey();
        if (this_present_key || that_present_key) {
            if (!this_present_key || !that_present_key) {
                return false;
            }
            if (!this.key.equals(that.key)) {
                return false;
            }
        }
        boolean this_present_columns = this.isSetColumns();
        boolean that_present_columns = that.isSetColumns();
        if (this_present_columns || that_present_columns) {
            if (!this_present_columns || !that_present_columns) {
                return false;
            }
            if (!this.columns.equals(that.columns)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_key = this.isSetKey();
        builder.append(present_key);
        if (present_key) {
            builder.append((Object)this.key);
        }
        boolean present_columns = this.isSetColumns();
        builder.append(present_columns);
        if (present_columns) {
            builder.append(this.columns);
        }
        return builder.toHashCode();
    }

    public int compareTo(CqlRow other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        CqlRow typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetKey()).compareTo(typedOther.isSetKey());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKey() && (lastComparison = TBaseHelper.compareTo((Comparable)this.key, (Comparable)typedOther.key)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumns()).compareTo(typedOther.isSetColumns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumns() && (lastComparison = TBaseHelper.compareTo(this.columns, typedOther.columns)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CqlRow(");
        boolean first = true;
        sb.append("key:");
        if (this.key == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.key, (StringBuilder)sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("columns:");
        if (this.columns == null) {
            sb.append("null");
        } else {
            sb.append(this.columns);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.key == null) {
            throw new TProtocolException("Required field 'key' was not present! Struct: " + this.toString());
        }
        if (this.columns == null) {
            throw new TProtocolException("Required field 'columns' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new CqlRowStandardSchemeFactory());
        schemes.put(TupleScheme.class, new CqlRowTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.KEY, new FieldMetaData("key", 1, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.COLUMNS, new FieldMetaData("columns", 1, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, Column.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(CqlRow.class, metaDataMap);
    }

    private static class CqlRowTupleScheme
    extends TupleScheme<CqlRow> {
        private CqlRowTupleScheme() {
        }

        public void write(TProtocol prot, CqlRow struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeBinary(struct.key);
            oprot.writeI32(struct.columns.size());
            for (Column _iter170 : struct.columns) {
                _iter170.write((TProtocol)oprot);
            }
        }

        public void read(TProtocol prot, CqlRow struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.key = iprot.readBinary();
            struct.setKeyIsSet(true);
            TList _list171 = new TList(12, iprot.readI32());
            struct.columns = new ArrayList<Column>(_list171.size);
            for (int _i172 = 0; _i172 < _list171.size; ++_i172) {
                Column _elem173 = new Column();
                _elem173.read((TProtocol)iprot);
                struct.columns.add(_elem173);
            }
            struct.setColumnsIsSet(true);
        }
    }

    private static class CqlRowTupleSchemeFactory
    implements SchemeFactory {
        private CqlRowTupleSchemeFactory() {
        }

        public CqlRowTupleScheme getScheme() {
            return new CqlRowTupleScheme();
        }
    }

    private static class CqlRowStandardScheme
    extends StandardScheme<CqlRow> {
        private CqlRowStandardScheme() {
        }

        public void read(TProtocol iprot, CqlRow struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.key = iprot.readBinary();
                            struct.setKeyIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 15) {
                            TList _list166 = iprot.readListBegin();
                            struct.columns = new ArrayList<Column>(_list166.size);
                            for (int _i167 = 0; _i167 < _list166.size; ++_i167) {
                                Column _elem168 = new Column();
                                _elem168.read(iprot);
                                struct.columns.add(_elem168);
                            }
                            iprot.readListEnd();
                            struct.setColumnsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, CqlRow struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.key != null) {
                oprot.writeFieldBegin(KEY_FIELD_DESC);
                oprot.writeBinary(struct.key);
                oprot.writeFieldEnd();
            }
            if (struct.columns != null) {
                oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.columns.size()));
                for (Column _iter169 : struct.columns) {
                    _iter169.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class CqlRowStandardSchemeFactory
    implements SchemeFactory {
        private CqlRowStandardSchemeFactory() {
        }

        public CqlRowStandardScheme getScheme() {
            return new CqlRowStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        KEY(1, "key"),
        COLUMNS(2, "columns");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return KEY;
                }
                case 2: {
                    return COLUMNS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

