/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.btree;

import java.util.Comparator;
import java.util.NoSuchElementException;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.BTreeSearchIterator;
import org.apache.cassandra.utils.btree.TreeCursor;

public class FullBTreeSearchIterator<K, V>
extends TreeCursor<K>
implements BTreeSearchIterator<K, V> {
    private final boolean forwards;
    private int index;
    private byte state;
    private final int lowerBound;
    private final int upperBound;
    private static final int MIDDLE = 0;
    private static final int ON_ITEM = 1;
    private static final int BEFORE_FIRST = 2;
    private static final int LAST = 4;
    private static final int END = 5;

    public FullBTreeSearchIterator(Object[] btree, Comparator<? super K> comparator, BTree.Dir dir) {
        this(btree, comparator, dir, 0, BTree.size(btree) - 1);
    }

    FullBTreeSearchIterator(Object[] btree, Comparator<? super K> comparator, BTree.Dir dir, int lowerBound, int upperBound) {
        super(comparator, btree);
        this.forwards = dir == BTree.Dir.ASC;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.rewind();
    }

    private int compareToLast(int idx) {
        return this.forwards ? idx - this.upperBound : this.lowerBound - idx;
    }

    private int compareToFirst(int idx) {
        return this.forwards ? idx - this.lowerBound : this.upperBound - idx;
    }

    @Override
    public boolean hasNext() {
        return this.state != 5;
    }

    @Override
    public V next() {
        switch (this.state) {
            case 1: {
                this.index = this.moveOne(this.forwards);
                if (this.compareToLast(this.index) < 0) break;
                this.state = (byte)5;
                break;
            }
            case 2: {
                this.index = this.forwards ? this.lowerBound : this.upperBound;
                this.seekTo(this.index);
                this.state = (byte)(this.upperBound == this.lowerBound ? 4 : 0);
            }
            case 0: 
            case 4: {
                this.state = (byte)(this.state | 1);
                break;
            }
            default: {
                throw new NoSuchElementException();
            }
        }
        return this.current();
    }

    @Override
    public V next(K target) {
        if (!this.hasNext()) {
            return null;
        }
        int state = this.state;
        boolean found = this.seekTo(target, this.forwards, (state & 3) != 0);
        int index = this.cur.globalIndex();
        V next = null;
        if (state == 2 && this.compareToFirst(index) < 0) {
            return null;
        }
        int compareToLast = this.compareToLast(index);
        if (compareToLast <= 0) {
            int n = state = compareToLast < 0 ? 0 : 4;
            if (found) {
                state |= 1;
                next = (V)this.currentValue();
            }
        } else {
            state = 5;
        }
        this.state = (byte)state;
        this.index = index;
        return next;
    }

    @Override
    public void rewind() {
        if (this.upperBound < this.lowerBound) {
            this.state = (byte)5;
        } else {
            this.reset(this.forwards);
            this.state = (byte)2;
        }
    }

    private void checkOnItem() {
        if ((this.state & 1) != 1) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public V current() {
        this.checkOnItem();
        return (V)this.currentValue();
    }

    @Override
    public int indexOfCurrent() {
        this.checkOnItem();
        return this.compareToFirst(this.index);
    }
}

