/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterators;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.exceptions.OverloadedException;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.locator.AbstractReplicaCollection;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.EndpointsForToken;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.locator.ReplicaPlans;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.reads.DataResolver;
import org.apache.cassandra.service.reads.ReadCallback;
import org.apache.cassandra.service.reads.repair.NoopReadRepair;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.btree.BTreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaFilteringProtection<E extends Endpoints<E>> {
    private static final Logger logger = LoggerFactory.getLogger(ReplicaFilteringProtection.class);
    private static final NoSpamLogger oneMinuteLogger = NoSpamLogger.getLogger(logger, 1L, TimeUnit.MINUTES);
    private static final Function<UnfilteredRowIterator, EncodingStats> NULL_TO_NO_STATS = rowIterator -> rowIterator == null ? EncodingStats.NO_STATS : rowIterator.stats();
    private final Keyspace keyspace;
    private final ReadCommand command;
    private final ConsistencyLevel consistency;
    private final Dispatcher.RequestTime requestTime;
    private final E sources;
    private final TableMetrics tableMetrics;
    private final int cachedRowsWarnThreshold;
    private final int cachedRowsFailThreshold;
    private boolean hitWarningThreshold = false;
    private int currentRowsCached = 0;
    private int maxRowsCached = 0;
    private final List<Queue<PartitionBuilder>> originalPartitions;

    ReplicaFilteringProtection(Keyspace keyspace, ReadCommand command, ConsistencyLevel consistency, Dispatcher.RequestTime requestTime, E sources, int cachedRowsWarnThreshold, int cachedRowsFailThreshold) {
        this.keyspace = keyspace;
        this.command = command;
        this.consistency = consistency;
        this.requestTime = requestTime;
        this.sources = sources;
        this.originalPartitions = new ArrayList<Queue<PartitionBuilder>>(((AbstractReplicaCollection)sources).size());
        for (int i = 0; i < ((AbstractReplicaCollection)sources).size(); ++i) {
            this.originalPartitions.add(new ArrayDeque());
        }
        this.tableMetrics = ColumnFamilyStore.metricsFor(command.metadata().id);
        this.cachedRowsWarnThreshold = cachedRowsWarnThreshold;
        this.cachedRowsFailThreshold = cachedRowsFailThreshold;
    }

    private UnfilteredPartitionIterator executeReadCommand(ReadCommand cmd, Replica source, ReplicaPlan.Shared<EndpointsForToken, ReplicaPlan.ForTokenRead> replicaPlan) {
        DataResolver resolver = new DataResolver(cmd, replicaPlan, NoopReadRepair.instance, this.requestTime);
        ReadCallback<EndpointsForToken, ReplicaPlan.ForTokenRead> handler = new ReadCallback<EndpointsForToken, ReplicaPlan.ForTokenRead>(resolver, cmd, replicaPlan, this.requestTime);
        if (source.isSelf()) {
            Stage.READ.maybeExecuteImmediately(new StorageProxy.LocalReadRunnable(cmd, handler, this.requestTime));
        } else {
            if (source.isTransient()) {
                cmd = cmd.copyAsTransientQuery(source);
            }
            MessagingService.instance().sendWithCallback(cmd.createMessage(false, this.requestTime), source.endpoint(), handler);
        }
        handler.awaitResults();
        assert (resolver.getMessages().size() == 1);
        return ((ReadResponse)resolver.getMessages().get((int)0).payload).makeIterator(this.command);
    }

    UnfilteredPartitionIterators.MergeListener mergeController() {
        return new UnfilteredPartitionIterators.MergeListener(){

            @Override
            public void close() {
                ReplicaFilteringProtection.this.tableMetrics.rfpRowsCachedPerQuery.update(Math.max(ReplicaFilteringProtection.this.currentRowsCached, ReplicaFilteringProtection.this.maxRowsCached));
            }

            @Override
            public UnfilteredRowIterators.MergeListener getRowMergeListener(DecoratedKey partitionKey, List<UnfilteredRowIterator> versions) {
                final ArrayList<PartitionBuilder> builders = new ArrayList<PartitionBuilder>(((AbstractReplicaCollection)ReplicaFilteringProtection.this.sources).size());
                final RegularAndStaticColumns columns = ReplicaFilteringProtection.columns(versions);
                EncodingStats stats = EncodingStats.merge(versions, NULL_TO_NO_STATS);
                for (int i = 0; i < ((AbstractReplicaCollection)ReplicaFilteringProtection.this.sources).size(); ++i) {
                    builders.add(i, new PartitionBuilder(partitionKey, ((AbstractReplicaCollection)ReplicaFilteringProtection.this.sources).get(i), columns, stats));
                }
                final boolean[] silentRowAt = new boolean[builders.size()];
                final boolean[] silentColumnAt = new boolean[builders.size()];
                return new UnfilteredRowIterators.MergeListener(){

                    @Override
                    public void onMergedPartitionLevelDeletion(DeletionTime mergedDeletion, DeletionTime[] versions) {
                        for (int i = 0; i < versions.length; ++i) {
                            ((PartitionBuilder)builders.get(i)).setDeletionTime(versions[i]);
                        }
                    }

                    @Override
                    public void onMergedRows(Row merged, Row[] versions) {
                        int i;
                        for (i = 0; i < versions.length; ++i) {
                            ((PartitionBuilder)builders.get(i)).addRow(versions[i]);
                        }
                        if (merged.isEmpty()) {
                            return;
                        }
                        Arrays.fill(silentRowAt, false);
                        for (i = 0; i < versions.length; ++i) {
                            if (versions[i] != null && (!merged.isStatic() || !versions[i].isEmpty())) continue;
                            silentRowAt[i] = true;
                        }
                        for (ColumnMetadata column : merged.isStatic() ? columns.statics : columns.regulars) {
                            int i2;
                            Arrays.fill(silentColumnAt, false);
                            boolean allSilent = true;
                            for (i2 = 0; i2 < versions.length; ++i2) {
                                if (versions[i2] != null && versions[i2].getColumnData(column) == null) {
                                    silentColumnAt[i2] = true;
                                    continue;
                                }
                                allSilent = false;
                            }
                            for (i2 = 0; i2 < versions.length; ++i2) {
                                int n = i2;
                                silentRowAt[n] = silentRowAt[n] | (silentColumnAt[i2] && !allSilent);
                            }
                        }
                        for (int i3 = 0; i3 < silentRowAt.length; ++i3) {
                            if (!silentRowAt[i3]) continue;
                            ((PartitionBuilder)builders.get(i3)).addToFetch(merged);
                        }
                    }

                    @Override
                    public void onMergedRangeTombstoneMarkers(RangeTombstoneMarker merged, RangeTombstoneMarker[] versions) {
                        for (int i = 0; i < versions.length; ++i) {
                            ((PartitionBuilder)builders.get(i)).addRangeTombstoneMarker(versions[i]);
                        }
                    }

                    @Override
                    public void close() {
                        for (int i = 0; i < ((AbstractReplicaCollection)ReplicaFilteringProtection.this.sources).size(); ++i) {
                            ReplicaFilteringProtection.this.originalPartitions.get(i).add((PartitionBuilder)builders.get(i));
                        }
                    }
                };
            }
        };
    }

    private void incrementCachedRows() {
        ++this.currentRowsCached;
        if (this.currentRowsCached == this.cachedRowsFailThreshold + 1) {
            String message = String.format("Replica filtering protection has cached over %d rows during query %s. (See 'cached_replica_rows_fail_threshold' in cassandra.yaml.)", this.cachedRowsFailThreshold, this.command.toCQLString());
            logger.error(message);
            Tracing.trace(message);
            throw new OverloadedException(message);
        }
        if (this.currentRowsCached == this.cachedRowsWarnThreshold + 1 && !this.hitWarningThreshold) {
            this.hitWarningThreshold = true;
            String message = String.format("Replica filtering protection has cached over %d rows during query %s. (See 'cached_replica_rows_warn_threshold' in cassandra.yaml.)", this.cachedRowsWarnThreshold, this.command.toCQLString());
            ClientWarn.instance.warn(message);
            oneMinuteLogger.warn(message, new Object[0]);
            Tracing.trace(message);
        }
    }

    private void releaseCachedRows(int count) {
        this.maxRowsCached = Math.max(this.maxRowsCached, this.currentRowsCached);
        this.currentRowsCached -= count;
    }

    private static RegularAndStaticColumns columns(List<UnfilteredRowIterator> versions) {
        Columns statics = Columns.NONE;
        Columns regulars = Columns.NONE;
        for (UnfilteredRowIterator iter : versions) {
            if (iter == null) continue;
            RegularAndStaticColumns cols = iter.columns();
            statics = statics.mergeTo(cols.statics);
            regulars = regulars.mergeTo(cols.regulars);
        }
        return new RegularAndStaticColumns(statics, regulars);
    }

    UnfilteredPartitionIterator queryProtectedPartitions(final PartitionIterator merged, final int source) {
        return new UnfilteredPartitionIterator(){
            final Queue<PartitionBuilder> partitions;
            {
                this.partitions = ReplicaFilteringProtection.this.originalPartitions.get(source);
            }

            @Override
            public TableMetadata metadata() {
                return ReplicaFilteringProtection.this.command.metadata();
            }

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                if (this.partitions.isEmpty()) {
                    PartitionIterators.consumeNext(merged);
                }
                return !this.partitions.isEmpty();
            }

            @Override
            public UnfilteredRowIterator next() {
                PartitionBuilder builder = this.partitions.poll();
                assert (builder != null);
                return builder.protectedPartition();
            }
        };
    }

    private class PartitionBuilder {
        private final DecoratedKey key;
        private final Replica source;
        private final RegularAndStaticColumns columns;
        private final EncodingStats stats;
        private DeletionTime deletionTime;
        private Row staticRow = Rows.EMPTY_STATIC_ROW;
        private final Queue<Unfiltered> contents = new ArrayDeque<Unfiltered>();
        private BTreeSet.Builder<Clustering<?>> toFetch;
        private int partitionRowsCached;
        private boolean unresolvedStatic = false;

        private PartitionBuilder(DecoratedKey key, Replica source, RegularAndStaticColumns columns, EncodingStats stats) {
            this.key = key;
            this.source = source;
            this.columns = columns;
            this.stats = stats;
        }

        private void setDeletionTime(DeletionTime deletionTime) {
            this.deletionTime = deletionTime;
        }

        private void addRow(Row row) {
            ++this.partitionRowsCached;
            ReplicaFilteringProtection.this.incrementCachedRows();
            if (row == null) {
                return;
            }
            if (row.isStatic()) {
                this.staticRow = row;
            } else {
                this.contents.add(row);
            }
        }

        private void addRangeTombstoneMarker(RangeTombstoneMarker marker) {
            if (marker != null) {
                this.contents.add(marker);
            }
        }

        private void addToFetch(Row row) {
            if (this.toFetch == null) {
                this.toFetch = BTreeSet.builder(ReplicaFilteringProtection.this.command.metadata().comparator);
            }
            if (row.isStatic()) {
                this.unresolvedStatic = ReplicaFilteringProtection.this.command.rowFilter().hasStaticExpression();
            } else {
                this.toFetch.add((Clustering<?>)row.clustering());
            }
        }

        private UnfilteredRowIterator originalPartition() {
            return new UnfilteredRowIterator(){

                @Override
                public DeletionTime partitionLevelDeletion() {
                    return PartitionBuilder.this.deletionTime;
                }

                @Override
                public EncodingStats stats() {
                    return PartitionBuilder.this.stats;
                }

                @Override
                public TableMetadata metadata() {
                    return ReplicaFilteringProtection.this.command.metadata();
                }

                @Override
                public boolean isReverseOrder() {
                    return ReplicaFilteringProtection.this.command.isReversed();
                }

                @Override
                public RegularAndStaticColumns columns() {
                    return PartitionBuilder.this.columns;
                }

                @Override
                public DecoratedKey partitionKey() {
                    return PartitionBuilder.this.key;
                }

                @Override
                public Row staticRow() {
                    return PartitionBuilder.this.staticRow;
                }

                @Override
                public void close() {
                    ReplicaFilteringProtection.this.releaseCachedRows(PartitionBuilder.this.partitionRowsCached);
                }

                @Override
                public boolean hasNext() {
                    return !PartitionBuilder.this.contents.isEmpty();
                }

                @Override
                public Unfiltered next() {
                    return PartitionBuilder.this.contents.poll();
                }
            };
        }

        private UnfilteredRowIterator protectedPartition() {
            UnfilteredRowIterator original;
            block13: {
                original = this.originalPartition();
                if (this.toFetch != null) {
                    try (UnfilteredPartitionIterator partitions = this.fetchFromSource();){
                        UnfilteredRowIterator unfilteredRowIterator;
                        block14: {
                            if (!partitions.hasNext()) break block13;
                            UnfilteredRowIterator fetchedRows = (UnfilteredRowIterator)partitions.next();
                            try {
                                unfilteredRowIterator = UnfilteredRowIterators.merge(Arrays.asList(original, fetchedRows));
                                if (fetchedRows == null) break block14;
                            }
                            catch (Throwable throwable) {
                                if (fetchedRows != null) {
                                    try {
                                        fetchedRows.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            fetchedRows.close();
                        }
                        return unfilteredRowIterator;
                    }
                }
            }
            return original;
        }

        private UnfilteredPartitionIterator fetchFromSource() {
            assert (this.toFetch != null);
            BTreeSet<Clustering<?>> clusterings = this.toFetch.build();
            ReplicaFilteringProtection.this.tableMetrics.replicaFilteringProtectionRequests.mark();
            if (logger.isTraceEnabled()) {
                logger.trace("Requesting rows {} in partition {} from {} for replica filtering protection", new Object[]{clusterings, this.key, this.source});
            }
            Tracing.trace("Requesting {} rows in partition {} from {} for replica filtering protection", clusterings.size(), this.key, this.source);
            ClusteringIndexFilter filter = this.unresolvedStatic ? ReplicaFilteringProtection.this.command.clusteringIndexFilter(this.key) : new ClusteringIndexNamesFilter(clusterings, ReplicaFilteringProtection.this.command.isReversed());
            SinglePartitionReadCommand cmd = SinglePartitionReadCommand.create(ReplicaFilteringProtection.this.command.metadata(), ReplicaFilteringProtection.this.command.nowInSec(), ReplicaFilteringProtection.this.command.columnFilter(), RowFilter.none(), DataLimits.NONE, this.key, filter);
            ReplicaPlan.ForTokenRead replicaPlan = ReplicaPlans.forSingleReplicaRead(ReplicaFilteringProtection.this.keyspace, this.key.getToken(), this.source);
            ReplicaPlan.SharedForTokenRead sharedReplicaPlan = ReplicaPlan.shared(replicaPlan);
            try {
                return ReplicaFilteringProtection.this.executeReadCommand(cmd, this.source, sharedReplicaPlan);
            }
            catch (ReadTimeoutException e) {
                int blockFor = ReplicaFilteringProtection.this.consistency.blockFor(replicaPlan.replicationStrategy());
                throw new ReadTimeoutException(ReplicaFilteringProtection.this.consistency, blockFor - 1, blockFor, true);
            }
            catch (UnavailableException e) {
                int blockFor = ReplicaFilteringProtection.this.consistency.blockFor(replicaPlan.replicationStrategy());
                throw UnavailableException.create(ReplicaFilteringProtection.this.consistency, blockFor, blockFor - 1);
            }
        }
    }
}

