/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.bti;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.format.bti.PartitionIndex;
import org.apache.cassandra.io.sstable.format.bti.ScrubPartitionIterator;
import org.apache.cassandra.io.sstable.format.bti.TrieIndexEntry;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ScrubIterator
extends PartitionIndex.IndexPosIterator
implements ScrubPartitionIterator {
    public static final int EXHAUSTED = -1;
    ByteBuffer key;
    long dataPosition;
    final FileHandle rowIndexFile;
    private final Version version;

    ScrubIterator(PartitionIndex partitionIndex, FileHandle rowIndexFile, Version version) throws IOException {
        super(partitionIndex);
        this.rowIndexFile = rowIndexFile.sharedCopy();
        this.version = version;
        this.advance();
    }

    @Override
    public void close() {
        super.close();
        this.rowIndexFile.close();
    }

    @Override
    public ByteBuffer key() {
        return this.key;
    }

    @Override
    public long dataPosition() {
        return this.dataPosition;
    }

    @Override
    public void advance() throws IOException {
        long pos = this.nextIndexPos();
        if (pos != Long.MIN_VALUE) {
            if (pos >= 0L) {
                try (FileDataInput in = this.rowIndexFile.createReader(pos);){
                    this.key = ByteBufferUtil.readWithShortLength(in);
                    this.dataPosition = TrieIndexEntry.deserialize((DataInputPlus)in, (long)in.getFilePointer(), (Version)this.version).position;
                }
            } else {
                this.key = null;
                this.dataPosition = pos ^ 0xFFFFFFFFFFFFFFFFL;
            }
        } else {
            this.key = null;
            this.dataPosition = -1L;
        }
    }

    @Override
    public boolean isExhausted() {
        return this.dataPosition == -1L;
    }
}

