/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.Sets;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.cassandra.utils.bytecomparable.ByteSourceInverse;

public abstract class CollectionType<T>
extends AbstractType<T> {
    public static CellPath.Serializer cellPathSerializer = new CollectionPathSerializer();
    public final Kind kind;

    protected CollectionType(AbstractType.ComparisonType comparisonType, Kind kind) {
        super(comparisonType);
        this.kind = kind;
    }

    public abstract AbstractType<?> nameComparator();

    public abstract AbstractType<?> valueComparator();

    protected abstract List<ByteBuffer> serializedValues(Iterator<Cell<?>> var1);

    @Override
    public abstract CollectionSerializer<T> getSerializer();

    public ColumnSpecification makeCollectionReceiver(ColumnSpecification collection, boolean isKey) {
        return this.kind.makeCollectionReceiver(collection, isKey);
    }

    @Override
    public <V> String getString(V value, ValueAccessor<V> accessor) {
        return BytesType.instance.getString(value, accessor);
    }

    @Override
    public ByteBuffer fromString(String source) {
        try {
            return ByteBufferUtil.hexToBytes(source);
        }
        catch (NumberFormatException e) {
            throw new MarshalException(String.format("cannot parse '%s' as hex bytes", source), e);
        }
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public <V> void validate(V value, ValueAccessor<V> accessor) throws MarshalException {
        if (accessor.isEmpty(value)) {
            throw new MarshalException("Not enough bytes to read a " + this.kind.name().toLowerCase());
        }
        super.validate(value, accessor);
    }

    @Override
    public <V> void validateCellValue(V cellValue, ValueAccessor<V> accessor) throws MarshalException {
        if (this.isMultiCell()) {
            this.valueComparator().validateCellValue(cellValue, accessor);
        } else {
            super.validateCellValue(cellValue, accessor);
        }
    }

    public boolean isMap() {
        return this.kind == Kind.MAP;
    }

    @Override
    public boolean isFreezable() {
        return true;
    }

    protected int collectionSize(List<ByteBuffer> values) {
        return values.size();
    }

    public ByteBuffer serializeForNativeProtocol(Iterator<Cell<?>> cells) {
        assert (this.isMultiCell());
        List<ByteBuffer> values = this.serializedValues(cells);
        int size = this.collectionSize(values);
        return CollectionSerializer.pack(values, ByteBufferAccessor.instance, size);
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        if (this == previous) {
            return true;
        }
        if (!this.getClass().equals(previous.getClass())) {
            return false;
        }
        CollectionType tprev = (CollectionType)previous;
        if (this.isMultiCell() != tprev.isMultiCell()) {
            return false;
        }
        if (!this.isMultiCell()) {
            return this.isCompatibleWithFrozen(tprev);
        }
        if (!this.nameComparator().isCompatibleWith(tprev.nameComparator())) {
            return false;
        }
        return this.valueComparator().isSerializationCompatibleWith(tprev.valueComparator());
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> previous) {
        if (this.isMultiCell()) {
            return this.isCompatibleWith(previous);
        }
        if (this == previous) {
            return true;
        }
        if (!this.getClass().equals(previous.getClass())) {
            return false;
        }
        CollectionType tprev = (CollectionType)previous;
        if (this.isMultiCell() != tprev.isMultiCell()) {
            return false;
        }
        return this.isValueCompatibleWithFrozen(tprev);
    }

    @Override
    public boolean isSerializationCompatibleWith(AbstractType<?> previous) {
        if (!this.isValueCompatibleWith(previous)) {
            return false;
        }
        return this.valueComparator().isSerializationCompatibleWith(((CollectionType)previous).valueComparator());
    }

    protected abstract boolean isCompatibleWithFrozen(CollectionType<?> var1);

    protected abstract boolean isValueCompatibleWithFrozen(CollectionType<?> var1);

    @Override
    public CQL3Type asCQL3Type() {
        return new CQL3Type.Collection(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CollectionType)) {
            return false;
        }
        CollectionType other = (CollectionType)o;
        if (this.kind != other.kind) {
            return false;
        }
        if (this.isMultiCell() != other.isMultiCell()) {
            return false;
        }
        return this.nameComparator().equals(other.nameComparator()) && this.valueComparator().equals(other.valueComparator());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.isMultiCell(), this.nameComparator(), this.valueComparator()});
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    static <VL, VR> int compareListOrSet(AbstractType<?> elementsComparator, VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        if (accessorL.isEmpty(left) || accessorR.isEmpty(right)) {
            return Boolean.compare(accessorR.isEmpty(right), accessorL.isEmpty(left));
        }
        int sizeL = CollectionSerializer.readCollectionSize(left, accessorL);
        int offsetL = CollectionSerializer.sizeOfCollectionSize();
        int sizeR = CollectionSerializer.readCollectionSize(right, accessorR);
        int offsetR = 4;
        for (int i = 0; i < Math.min(sizeL, sizeR); ++i) {
            VL v1 = CollectionSerializer.readValue(left, accessorL, offsetL);
            offsetL += CollectionSerializer.sizeOfValue(v1, accessorL);
            VR v2 = CollectionSerializer.readValue(right, accessorR, offsetR);
            offsetR += CollectionSerializer.sizeOfValue(v2, accessorR);
            int cmp = elementsComparator.compare(v1, accessorL, v2, accessorR);
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(sizeL, sizeR);
    }

    static <V> ByteSource asComparableBytesListOrSet(AbstractType<?> elementsComparator, ValueAccessor<V> accessor, V data, ByteComparable.Version version) {
        if (accessor.isEmpty(data)) {
            return null;
        }
        int offset = 0;
        int size = CollectionSerializer.readCollectionSize(data, accessor);
        offset += CollectionSerializer.sizeOfCollectionSize();
        ByteSource[] srcs = new ByteSource[size];
        for (int i = 0; i < size; ++i) {
            V v = CollectionSerializer.readValue(data, accessor, offset);
            offset += CollectionSerializer.sizeOfValue(v, accessor);
            srcs[i] = elementsComparator.asComparableBytes(accessor, v, version);
        }
        return ByteSource.withTerminatorMaybeLegacy(version, 0, srcs);
    }

    static <V> V fromComparableBytesListOrSet(ValueAccessor<V> accessor, ByteSource.Peekable comparableBytes, ByteComparable.Version version, AbstractType<?> elementType) {
        if (comparableBytes == null) {
            return accessor.empty();
        }
        assert (version != ByteComparable.Version.LEGACY);
        ArrayList<V> buffers = new ArrayList<V>();
        int separator = comparableBytes.next();
        while (separator != 56) {
            if (!ByteSourceInverse.nextComponentNull(separator)) {
                buffers.add(elementType.fromComparableBytes(accessor, comparableBytes, version));
            } else {
                buffers.add(null);
            }
            separator = comparableBytes.next();
        }
        return (V)CollectionSerializer.pack(buffers, accessor, buffers.size());
    }

    public static String setOrListToJsonString(ByteBuffer buffer, AbstractType<?> elementsType, ProtocolVersion protocolVersion) {
        ByteBuffer value = buffer.duplicate();
        StringBuilder sb = new StringBuilder("[");
        int size = CollectionSerializer.readCollectionSize(value, ByteBufferAccessor.instance);
        int offset = CollectionSerializer.sizeOfCollectionSize();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            ByteBuffer element = CollectionSerializer.readValue(value, ByteBufferAccessor.instance, offset);
            offset += CollectionSerializer.sizeOfValue(element, ByteBufferAccessor.instance);
            sb.append(elementsType.toJSONString(element, protocolVersion));
        }
        return sb.append("]").toString();
    }

    public int size(ByteBuffer buffer) {
        return CollectionSerializer.readCollectionSize(buffer.duplicate(), ByteBufferAccessor.instance);
    }

    public abstract void forEach(ByteBuffer var1, Consumer<ByteBuffer> var2);

    private static class CollectionPathSerializer
    implements CellPath.Serializer {
        private CollectionPathSerializer() {
        }

        @Override
        public void serialize(CellPath path, DataOutputPlus out) throws IOException {
            ByteBufferUtil.writeWithVIntLength(path.get(0), out);
        }

        @Override
        public CellPath deserialize(DataInputPlus in) throws IOException {
            return CellPath.create(ByteBufferUtil.readWithVIntLength(in));
        }

        @Override
        public long serializedSize(CellPath path) {
            return ByteBufferUtil.serializedSizeWithVIntLength(path.get(0));
        }

        @Override
        public void skip(DataInputPlus in) throws IOException {
            ByteBufferUtil.skipWithVIntLength(in);
        }
    }

    public static enum Kind {
        MAP{

            @Override
            public ColumnSpecification makeCollectionReceiver(ColumnSpecification collection, boolean isKey) {
                return isKey ? Maps.keySpecOf(collection) : Maps.valueSpecOf(collection);
            }
        }
        ,
        SET{

            @Override
            public ColumnSpecification makeCollectionReceiver(ColumnSpecification collection, boolean isKey) {
                return Sets.valueSpecOf(collection);
            }
        }
        ,
        LIST{

            @Override
            public ColumnSpecification makeCollectionReceiver(ColumnSpecification collection, boolean isKey) {
                return Lists.valueSpecOf(collection);
            }
        };


        public abstract ColumnSpecification makeCollectionReceiver(ColumnSpecification var1, boolean var2);

        public String toString() {
            return super.toString().toLowerCase(Locale.US);
        }
    }
}

