/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.IAuthorizer;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.RoleName;
import org.apache.cassandra.cql3.statements.PermissionsManagementStatement;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.transport.messages.ResultMessage;

public class GrantPermissionsStatement
extends PermissionsManagementStatement {
    public GrantPermissionsStatement(Set<Permission> permissions, IResource resource, RoleName grantee) {
        super(permissions, resource, grantee);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        DataResource data;
        super.validate(state);
        if (this.resource instanceof DataResource && !(data = (DataResource)this.resource).isRootLevel() && SchemaConstants.isNonVirtualSystemKeyspace(data.getKeyspace()) && !Collections.disjoint(this.permissions, Permission.INVALID_FOR_SYSTEM_KEYSPACES)) {
            throw new UnauthorizedException("Granting permissions on system keyspaces is strictly limited, this operation is not permitted");
        }
    }

    @Override
    public ResultMessage execute(ClientState state) throws RequestValidationException, RequestExecutionException {
        IAuthorizer authorizer = DatabaseDescriptor.getAuthorizer();
        Set<Permission> granted = authorizer.grant(state.getUser(), this.permissions, this.resource, this.grantee);
        if (!granted.equals(this.permissions) && !this.permissions.equals(Permission.ALL)) {
            String permissionsStr = this.permissions.stream().filter(permission -> !granted.contains(permission)).sorted(Enum::compareTo).map(Enum::name).collect(Collectors.joining(", "));
            ClientWarn.instance.warn(String.format("Role '%s' was already granted %s on %s", this.grantee.getRoleName(), permissionsStr, this.resource));
        }
        return null;
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        String keyspace = this.resource.hasParent() ? this.resource.getParent().getName() : this.resource.getName();
        return new AuditLogContext(AuditLogEntryType.GRANT, keyspace, this.resource.getName());
    }
}

