/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.util.concurrent.ExecutionException;
import org.apache.cassandra.exceptions.RepairException;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.SharedContext;
import org.apache.cassandra.repair.TreeResponse;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.repair.messages.ValidationRequest;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.utils.MerkleTrees;
import org.apache.cassandra.utils.concurrent.AsyncFuture;

public class ValidationTask
extends AsyncFuture<TreeResponse>
implements Runnable {
    private final RepairJobDesc desc;
    private final InetAddressAndPort endpoint;
    private final long nowInSec;
    private final PreviewKind previewKind;
    private final SharedContext ctx;

    public ValidationTask(SharedContext ctx, RepairJobDesc desc, InetAddressAndPort endpoint, long nowInSec, PreviewKind previewKind) {
        this.ctx = ctx;
        this.desc = desc;
        this.endpoint = endpoint;
        this.nowInSec = nowInSec;
        this.previewKind = previewKind;
    }

    @Override
    public void run() {
        RepairMessage.sendMessageWithFailureCB(this.ctx, RepairMessage.notDone(this), new ValidationRequest(this.desc, this.nowInSec), Verb.VALIDATION_REQ, this.endpoint, this::tryFailure);
    }

    public synchronized void treesReceived(MerkleTrees trees) {
        if (trees == null) {
            this.tryFailure(RepairException.warn(this.desc, this.previewKind, "Validation failed in " + this.endpoint));
        } else if (!this.trySuccess(new TreeResponse(this.endpoint, trees))) {
            trees.release();
        }
    }

    public synchronized void abort(Throwable reason) {
        if (!this.tryFailure(reason) && this.isSuccess()) {
            try {
                TreeResponse response = (TreeResponse)this.get();
                if (response.trees != null) {
                    response.trees.release();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    public synchronized boolean isActive() {
        return !this.isDone();
    }
}

