/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.tries;

import java.util.Iterator;
import org.apache.cassandra.db.tries.Trie;

class TrieValuesIterator<T>
implements Iterator<T> {
    private final Trie.Cursor<T> cursor;
    T next;
    boolean gotNext;

    protected TrieValuesIterator(Trie<T> trie) {
        this.cursor = trie.cursor();
        assert (this.cursor.depth() == 0);
        this.next = this.cursor.content();
        this.gotNext = this.next != null;
    }

    @Override
    public boolean hasNext() {
        if (!this.gotNext) {
            this.next = this.cursor.advanceToContent(null);
            this.gotNext = true;
        }
        return this.next != null;
    }

    @Override
    public T next() {
        this.gotNext = false;
        T v = this.next;
        this.next = null;
        return v;
    }
}

