/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.functions.ArgumentDeserializer;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;

public class PartitionerDefinedOrder
extends AbstractType<ByteBuffer> {
    private final IPartitioner partitioner;
    private final AbstractType<?> partitionKeyType;

    public PartitionerDefinedOrder(IPartitioner partitioner) {
        super(AbstractType.ComparisonType.CUSTOM);
        this.partitioner = partitioner;
        this.partitionKeyType = null;
    }

    public PartitionerDefinedOrder(IPartitioner partitioner, AbstractType<?> partitionKeyType) {
        super(AbstractType.ComparisonType.CUSTOM);
        this.partitioner = partitioner;
        this.partitionKeyType = partitionKeyType;
    }

    public static AbstractType<?> getInstance(TypeParser parser) {
        return parser.getPartitionerDefinedOrder();
    }

    public AbstractType<?> withPartitionKeyType(AbstractType<?> partitionKeyType) {
        return new PartitionerDefinedOrder(this.partitioner, partitionKeyType);
    }

    @Override
    public <V> ByteBuffer compose(V value, ValueAccessor<V> accessor) {
        throw new UnsupportedOperationException("You can't do this with a local partitioner.");
    }

    @Override
    public ByteBuffer decompose(ByteBuffer value) {
        throw new UnsupportedOperationException("You can't do this with a local partitioner.");
    }

    @Override
    public <V> String getString(V value, ValueAccessor<V> accessor) {
        return accessor.toHex(value);
    }

    @Override
    public ByteBuffer fromString(String source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Term fromJSONObject(Object parsed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        assert (this.partitionKeyType != null) : "PartitionerDefinedOrder's toJSONString method needs a partition key type but now is null.";
        return this.partitionKeyType.toJSONString(buffer, protocolVersion);
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        return PartitionPosition.ForKey.get(accessorL.toBuffer(left), this.partitioner).compareTo(PartitionPosition.ForKey.get(accessorR.toBuffer(right), this.partitioner));
    }

    @Override
    public <V> ByteSource asComparableBytes(ValueAccessor<V> accessor, V data, ByteComparable.Version version) {
        ByteBuffer buf = ByteBufferAccessor.instance.convert(data, accessor);
        if (version != ByteComparable.Version.LEGACY) {
            return buf.hasRemaining() ? this.partitioner.decorateKey(buf).asComparableBytes(version) : null;
        }
        return PartitionPosition.ForKey.get(buf, this.partitioner).asComparableBytes(version);
    }

    @Override
    public <V> V fromComparableBytes(ValueAccessor<V> accessor, ByteSource.Peekable comparableBytes, ByteComparable.Version version) {
        assert (version != ByteComparable.Version.LEGACY);
        if (comparableBytes == null) {
            return accessor.empty();
        }
        byte[] keyBytes = DecoratedKey.keyFromByteSource(comparableBytes, version, this.partitioner);
        return accessor.valueOf(keyBytes);
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        throw new IllegalStateException("You shouldn't be validating this.");
    }

    @Override
    public <V> boolean isNull(V buffer, ValueAccessor<V> accessor) {
        return buffer == null || accessor.isEmpty(buffer);
    }

    @Override
    public TypeSerializer<ByteBuffer> getSerializer() {
        throw new UnsupportedOperationException("You can't do this with a local partitioner.");
    }

    @Override
    public ArgumentDeserializer getArgumentDeserializer() {
        throw new UnsupportedOperationException("You can't do this with a local partitioner.");
    }

    @Override
    public String toString() {
        if (this.partitionKeyType != null && !DatabaseDescriptor.getStorageCompatibilityMode().isBefore(5)) {
            return String.format("%s(%s:%s)", this.getClass().getName(), this.partitioner.getClass().getName(), this.partitionKeyType);
        }
        return String.format("%s(%s)", this.getClass().getName(), this.partitioner.getClass().getName());
    }

    @Nullable
    public AbstractType<?> getPartitionKeyType() {
        return this.partitionKeyType;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PartitionerDefinedOrder) {
            PartitionerDefinedOrder other = (PartitionerDefinedOrder)obj;
            return this.partitioner.equals(other.partitioner) && Objects.equals(this.partitionKeyType, other.partitionKeyType);
        }
        return false;
    }
}

