/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.EOFException;
import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.Throwables;

public class TeeDataInputPlus
implements DataInputPlus {
    private final DataInputPlus source;
    private final DataOutputPlus teeBuffer;
    private final long limit;
    private boolean limitReached;

    public TeeDataInputPlus(DataInputPlus source, DataOutputPlus teeBuffer) {
        this(source, teeBuffer, 0L);
    }

    public TeeDataInputPlus(DataInputPlus source, DataOutputPlus teeBuffer, long limit) {
        assert (source != null && teeBuffer != null);
        this.source = source;
        this.teeBuffer = teeBuffer;
        this.limit = limit;
        this.limitReached = false;
    }

    private void maybeWrite(int length, Throwables.DiscreteAction<IOException> writeAction) throws IOException {
        if (this.limit <= 0L || !this.limitReached && this.teeBuffer.position() + (long)length < this.limit) {
            writeAction.perform();
        } else {
            this.limitReached = true;
        }
    }

    @Override
    public void readFully(byte[] bytes) throws IOException {
        this.source.readFully(bytes);
        this.maybeWrite(bytes.length, () -> this.teeBuffer.write(bytes));
    }

    @Override
    public void readFully(byte[] bytes, int offset, int length) throws IOException {
        this.source.readFully(bytes, offset, length);
        this.maybeWrite(length, () -> this.teeBuffer.write(bytes, offset, length));
    }

    @Override
    public int skipBytes(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            try {
                byte v = this.source.readByte();
                this.maybeWrite(1, () -> this.teeBuffer.writeByte(v));
                continue;
            }
            catch (EOFException eof) {
                return i;
            }
        }
        return n;
    }

    @Override
    public boolean readBoolean() throws IOException {
        boolean v = this.source.readBoolean();
        this.maybeWrite(1, () -> this.teeBuffer.writeBoolean(v));
        return v;
    }

    @Override
    public byte readByte() throws IOException {
        byte v = this.source.readByte();
        this.maybeWrite(1, () -> this.teeBuffer.writeByte(v));
        return v;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int v = this.source.readUnsignedByte();
        this.maybeWrite(1, () -> this.teeBuffer.writeByte(v));
        return v;
    }

    @Override
    public short readShort() throws IOException {
        short v = this.source.readShort();
        this.maybeWrite(2, () -> this.teeBuffer.writeShort(v));
        return v;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int v = this.source.readUnsignedShort();
        this.maybeWrite(2, () -> this.teeBuffer.writeShort(v));
        return v;
    }

    @Override
    public char readChar() throws IOException {
        char v = this.source.readChar();
        this.maybeWrite(1, () -> this.teeBuffer.writeChar(v));
        return v;
    }

    @Override
    public int readInt() throws IOException {
        int v = this.source.readInt();
        this.maybeWrite(4, () -> this.teeBuffer.writeInt(v));
        return v;
    }

    @Override
    public long readLong() throws IOException {
        long v = this.source.readLong();
        this.maybeWrite(8, () -> this.teeBuffer.writeLong(v));
        return v;
    }

    @Override
    public float readFloat() throws IOException {
        float v = this.source.readFloat();
        this.maybeWrite(4, () -> this.teeBuffer.writeFloat(v));
        return v;
    }

    @Override
    public double readDouble() throws IOException {
        double v = this.source.readDouble();
        this.maybeWrite(8, () -> this.teeBuffer.writeDouble(v));
        return v;
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        String v = this.source.readUTF();
        this.maybeWrite(TypeSizes.sizeof(v), () -> this.teeBuffer.writeUTF(v));
        return v;
    }

    @Override
    public long readVInt() throws IOException {
        long v = this.source.readVInt();
        this.maybeWrite(TypeSizes.sizeofVInt(v), () -> this.teeBuffer.writeVInt(v));
        return v;
    }

    @Override
    public long readUnsignedVInt() throws IOException {
        long v = this.source.readUnsignedVInt();
        this.maybeWrite(TypeSizes.sizeofUnsignedVInt(v), () -> this.teeBuffer.writeUnsignedVInt(v));
        return v;
    }

    @Override
    public void skipBytesFully(int n) throws IOException {
        this.source.skipBytesFully(n);
        this.maybeWrite(n, () -> {
            for (int i = 0; i < n; ++i) {
                this.teeBuffer.writeByte(0);
            }
        });
    }

    public boolean isLimitReached() {
        return this.limitReached;
    }
}

