/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.cassandra.config.DataRateSpec;
import org.apache.cassandra.config.DataStorageSpec;
import org.apache.cassandra.config.DurationSpec;
import org.apache.cassandra.schema.SchemaConstants;

public enum Converters {
    IDENTITY(null, null, o -> o, o -> o),
    INTEGER_PRIMITIVE_LONG(Integer.class, Long.TYPE, Integer::longValue, Long::intValue),
    MILLIS_DURATION_LONG(Long.class, DurationSpec.LongMillisecondsBound.class, DurationSpec.LongMillisecondsBound::new, o -> o == null ? null : Long.valueOf(o.toMilliseconds())),
    MILLIS_DURATION_INT(Integer.class, DurationSpec.IntMillisecondsBound.class, DurationSpec.IntMillisecondsBound::new, o -> o == null ? null : Integer.valueOf(o.toMilliseconds())),
    MILLIS_DURATION_DOUBLE(Double.class, DurationSpec.IntMillisecondsBound.class, o -> Double.isNaN(o) ? new DurationSpec.IntMillisecondsBound(0L) : new DurationSpec.IntMillisecondsBound((double)o, TimeUnit.MILLISECONDS), o -> o.toMilliseconds()),
    MILLIS_CUSTOM_DURATION(Integer.class, DurationSpec.IntMillisecondsBound.class, o -> o == -1 ? null : new DurationSpec.IntMillisecondsBound(o.intValue()), o -> o == null ? -1 : o.toMilliseconds()),
    SECONDS_DURATION(Integer.class, DurationSpec.IntSecondsBound.class, DurationSpec.IntSecondsBound::new, o -> o == null ? null : Integer.valueOf(o.toSeconds())),
    NEGATIVE_SECONDS_DURATION(Integer.class, DurationSpec.IntSecondsBound.class, o -> o < 0 ? new DurationSpec.IntSecondsBound(0L) : new DurationSpec.IntSecondsBound(o.intValue()), o -> o == null ? null : Integer.valueOf(o.toSeconds())),
    SECONDS_CUSTOM_DURATION(String.class, DurationSpec.IntSecondsBound.class, DurationSpec.IntSecondsBound::inSecondsString, o -> o == null ? null : Long.toString(o.toSeconds())),
    MINUTES_CUSTOM_DURATION(Integer.class, DurationSpec.IntMinutesBound.class, o -> o == -1 ? null : new DurationSpec.IntMinutesBound(o.intValue()), o -> o == null ? -1 : o.toMinutes()),
    MEBIBYTES_DATA_STORAGE_LONG(Long.class, DataStorageSpec.LongMebibytesBound.class, DataStorageSpec.LongMebibytesBound::new, o -> o == null ? null : Long.valueOf(o.toMebibytes())),
    MEBIBYTES_DATA_STORAGE_INT(Integer.class, DataStorageSpec.IntMebibytesBound.class, DataStorageSpec.IntMebibytesBound::new, o -> o == null ? null : Integer.valueOf(o.toMebibytes())),
    NEGATIVE_MEBIBYTES_DATA_STORAGE_INT(Integer.class, DataStorageSpec.IntMebibytesBound.class, o -> o < 0 ? null : new DataStorageSpec.IntMebibytesBound(o.intValue()), o -> o == null ? -1 : o.toMebibytes()),
    KIBIBYTES_DATASTORAGE(Integer.class, DataStorageSpec.IntKibibytesBound.class, DataStorageSpec.IntKibibytesBound::new, o -> o == null ? null : Integer.valueOf(o.toKibibytes())),
    BYTES_DATASTORAGE(Integer.class, DataStorageSpec.IntBytesBound.class, DataStorageSpec.IntBytesBound::new, o -> o == null ? null : Integer.valueOf(o.toBytes())),
    LONG_BYTES_DATASTORAGE_MEBIBYTES_INT(Integer.class, DataStorageSpec.LongBytesBound.class, o -> o == null ? null : new DataStorageSpec.LongBytesBound(o.intValue(), DataStorageSpec.DataStorageUnit.MEBIBYTES), o -> o == null ? null : Integer.valueOf(o.toMebibytesInt())),
    LONG_BYTES_DATASTORAGE_MEBIBYTES_DATASTORAGE(DataStorageSpec.IntMebibytesBound.class, DataStorageSpec.LongBytesBound.class, o -> o == null ? null : new DataStorageSpec.LongBytesBound(o.toBytesInLong()), o -> o == null ? null : new DataStorageSpec.IntMebibytesBound(o.toMebibytesInt())),
    BYTES_CUSTOM_DATASTORAGE(Long.class, DataStorageSpec.LongBytesBound.class, o -> o == -1L ? null : new DataStorageSpec.LongBytesBound((long)o), o -> o == null ? null : Long.valueOf(o.toBytes())),
    MEBIBYTES_PER_SECOND_DATA_RATE(Integer.class, DataRateSpec.LongBytesPerSecondBound.class, i -> new DataRateSpec.LongBytesPerSecondBound(i.intValue(), DataRateSpec.DataRateUnit.MEBIBYTES_PER_SECOND), o -> o == null ? null : Integer.valueOf(o.toMebibytesPerSecondAsInt())),
    MEGABITS_TO_BYTES_PER_SECOND_DATA_RATE(Integer.class, DataRateSpec.LongBytesPerSecondBound.class, i -> DataRateSpec.LongBytesPerSecondBound.megabitsPerSecondInBytesPerSecond(i.intValue()), o -> o == null ? null : Integer.valueOf(o.toMegabitsPerSecondAsInt())),
    KEYSPACE_COUNT_THRESHOLD_TO_GUARDRAIL(Integer.TYPE, Integer.TYPE, i -> i - SchemaConstants.getLocalAndReplicatedSystemKeyspaceNames().size(), o -> o == null ? null : Integer.valueOf(o + SchemaConstants.getLocalAndReplicatedSystemKeyspaceNames().size())),
    TABLE_COUNT_THRESHOLD_TO_GUARDRAIL(Integer.TYPE, Integer.TYPE, i -> i - SchemaConstants.getLocalAndReplicatedSystemTableNames().size(), o -> o == null ? null : Integer.valueOf(o + SchemaConstants.getLocalAndReplicatedSystemTableNames().size()));

    private final Class<?> oldType;
    private final Class<?> newType;
    private final Function<Object, Object> convert;
    private final Function<Object, Object> reverseConvert;

    private <Old, New> Converters(Class<Old> oldType, Class<New> newType, Function<Old, New> convert, Function<New, Old> reverseConvert) {
        this.oldType = oldType;
        this.newType = newType;
        this.convert = convert;
        this.reverseConvert = reverseConvert;
    }

    public Class<?> getOldType() {
        return this.oldType;
    }

    public Class<?> getNewType() {
        return this.newType;
    }

    public Object convert(Object value) {
        if (value == null) {
            return null;
        }
        return this.convert.apply(value);
    }

    public Object unconvert(Object value) {
        return this.reverseConvert.apply(value);
    }
}

