/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.Duration;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.io.util.DataInputBuffer;
import org.apache.cassandra.io.util.DataOutputBufferFixed;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.vint.VIntCoding;

public final class DurationSerializer
extends TypeSerializer<Duration> {
    public static final DurationSerializer instance = new DurationSerializer();

    @Override
    public ByteBuffer serialize(Duration duration) {
        ByteBuffer byteBuffer;
        if (duration == null) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        long months = duration.getMonths();
        long days = duration.getDays();
        long nanoseconds = duration.getNanoseconds();
        int size = VIntCoding.computeVIntSize(months) + VIntCoding.computeVIntSize(days) + VIntCoding.computeVIntSize(nanoseconds);
        DataOutputBufferFixed output = new DataOutputBufferFixed(size);
        try {
            output.writeVInt(months);
            output.writeVInt(days);
            output.writeVInt(nanoseconds);
            byteBuffer = output.buffer();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new AssertionError("Unexpected error", e);
            }
        }
        output.close();
        return byteBuffer;
    }

    @Override
    public <V> Duration deserialize(V value, ValueAccessor<V> accessor) {
        if (accessor.isEmpty(value)) {
            return null;
        }
        DataInputBuffer in = new DataInputBuffer(accessor.toBuffer(value), true);
        try {
            int months = in.readVInt32();
            int days = in.readVInt32();
            long nanoseconds = in.readVInt();
            Duration duration = Duration.newInstance(months, days, nanoseconds);
            in.close();
            return duration;
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new AssertionError("Unexpected error", e);
            }
        }
    }

    @Override
    public <V> void validate(V value, ValueAccessor<V> accessor) throws MarshalException {
        if (accessor.size(value) < 3) {
            throw new MarshalException(String.format("Expected at least 3 bytes for a duration (%d)", accessor.size(value)));
        }
        try (DataInputBuffer in = new DataInputBuffer(accessor.toBuffer(value), true);){
            long monthsAsLong = in.readVInt();
            long daysAsLong = in.readVInt();
            long nanoseconds = in.readVInt();
            if (!this.canBeCastToInt(monthsAsLong)) {
                throw new MarshalException(String.format("The duration months must be a 32 bits integer but was: %d", monthsAsLong));
            }
            if (!this.canBeCastToInt(daysAsLong)) {
                throw new MarshalException(String.format("The duration days must be a 32 bits integer but was: %d", daysAsLong));
            }
            int months = (int)monthsAsLong;
            int days = (int)daysAsLong;
            if (!(months >= 0 && days >= 0 && nanoseconds >= 0L || months <= 0 && days <= 0 && nanoseconds <= 0L)) {
                throw new MarshalException(String.format("The duration months, days and nanoseconds must be all of the same sign (%d, %d, %d)", months, days, nanoseconds));
            }
        }
        catch (IOException e) {
            throw new AssertionError("Unexpected error", e);
        }
    }

    private boolean canBeCastToInt(long l) {
        return (long)((int)l) == l;
    }

    @Override
    public String toString(Duration duration) {
        return duration == null ? "" : duration.toString();
    }

    @Override
    public Class<Duration> getType() {
        return Duration.class;
    }
}

