/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;

public class AbstractTypeSerializer {
    public void serialize(AbstractType<?> type, DataOutputPlus out) throws IOException {
        ByteBufferUtil.writeWithVIntLength(UTF8Type.instance.decompose(type.toString()), out);
    }

    public void serializeList(List<AbstractType<?>> types, DataOutputPlus out) throws IOException {
        out.writeUnsignedVInt32(types.size());
        for (AbstractType<?> type : types) {
            this.serialize(type, out);
        }
    }

    public AbstractType<?> deserialize(DataInputPlus in) throws IOException {
        ByteBuffer raw = ByteBufferUtil.readWithVIntLength(in);
        return TypeParser.parse((String)UTF8Type.instance.compose(raw));
    }

    public List<AbstractType<?>> deserializeList(DataInputPlus in) throws IOException {
        int size = (int)in.readUnsignedVInt();
        ArrayList types = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            types.add(this.deserialize(in));
        }
        return types;
    }

    public long serializedSize(AbstractType<?> type) {
        return ByteBufferUtil.serializedSizeWithVIntLength(UTF8Type.instance.decompose(type.toString()));
    }

    public long serializedListSize(List<AbstractType<?>> types) {
        long size = TypeSizes.sizeofUnsignedVInt(types.size());
        for (AbstractType<?> type : types) {
            size += this.serializedSize(type);
        }
        return size;
    }
}

