/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.state;

import java.util.Objects;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.state.AbstractCompletable;
import org.apache.cassandra.repair.state.AbstractState;
import org.apache.cassandra.utils.Clock;

public class SyncState
extends AbstractState<State, Id> {
    public final Phase phase = new Phase();

    public SyncState(Clock clock, RepairJobDesc desc, InetAddressAndPort initiator, InetAddressAndPort src, InetAddressAndPort dst) {
        super(clock, new Id(desc, initiator, src, dst), State.class);
    }

    public static class Id {
        public final RepairJobDesc desc;
        public final InetAddressAndPort initiator;
        public final InetAddressAndPort src;
        public final InetAddressAndPort dst;

        public Id(RepairJobDesc desc, InetAddressAndPort initiator, InetAddressAndPort src, InetAddressAndPort dst) {
            this.desc = desc;
            this.initiator = initiator;
            this.src = src;
            this.dst = dst;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Id id = (Id)o;
            return this.desc.equals(id.desc) && this.initiator.equals(id.initiator) && this.src.equals(id.src) && this.dst.equals(id.dst);
        }

        public int hashCode() {
            return Objects.hash(this.desc, this.initiator, this.src, this.dst);
        }
    }

    public final class Phase
    extends AbstractCompletable.BaseSkipPhase {
        public void accept() {
            SyncState.this.updateState(State.ACCEPT);
        }

        public void planning() {
            SyncState.this.updateState(State.PLANNING);
        }

        public void start() {
            SyncState.this.updateState(State.START);
        }
    }

    public static enum State {
        ACCEPT,
        PLANNING,
        START;

    }
}

