/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.index.SecondaryIndexManager;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.GaugeProvider;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.FrequencySampler;
import org.apache.cassandra.metrics.LatencyMetrics;
import org.apache.cassandra.metrics.MaxSampler;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.metrics.Sampler;
import org.apache.cassandra.metrics.SnapshottingTimer;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.ExpMovingAverage;
import org.apache.cassandra.utils.MovingAverage;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang3.ArrayUtils;

public class TableMetrics {
    private static final ConcurrentMap<String, Set<Metric>> ALL_TABLE_METRICS = Maps.newConcurrentMap();
    public static final long[] EMPTY = new long[0];
    private static final MetricNameFactory GLOBAL_FACTORY = new AllTableMetricNameFactory("Table");
    private static final MetricNameFactory GLOBAL_ALIAS_FACTORY = new AllTableMetricNameFactory("ColumnFamily");
    public static final LatencyMetrics GLOBAL_READ_LATENCY = new LatencyMetrics(GLOBAL_FACTORY, GLOBAL_ALIAS_FACTORY, "Read");
    public static final LatencyMetrics GLOBAL_WRITE_LATENCY = new LatencyMetrics(GLOBAL_FACTORY, GLOBAL_ALIAS_FACTORY, "Write");
    public static final LatencyMetrics GLOBAL_RANGE_LATENCY = new LatencyMetrics(GLOBAL_FACTORY, GLOBAL_ALIAS_FACTORY, "Range");
    public final Gauge<Long> memtableOnHeapDataSize;
    public final Gauge<Long> memtableOffHeapDataSize;
    public final Gauge<Long> memtableLiveDataSize;
    public final Gauge<Long> allMemtablesOnHeapDataSize;
    public final Gauge<Long> allMemtablesOffHeapDataSize;
    public final Gauge<Long> allMemtablesLiveDataSize;
    public final Gauge<Long> memtableColumnsCount;
    public final Counter memtableSwitchCount;
    public final Gauge<Double> compressionRatio;
    public final Gauge<long[]> estimatedPartitionSizeHistogram;
    public final Gauge<Long> estimatedPartitionCount;
    public final Gauge<long[]> estimatedColumnCountHistogram;
    public final TableHistogram sstablesPerReadHistogram;
    public final TableHistogram sstablesPerRangeReadHistogram;
    public final LatencyMetrics readLatency;
    public final LatencyMetrics rangeLatency;
    public final LatencyMetrics writeLatency;
    public final Counter pendingFlushes;
    public final Counter bytesFlushed;
    public final MovingAverage flushSizeOnDisk;
    public final Counter compactionBytesWritten;
    public final Gauge<Integer> pendingCompactions;
    public final Gauge<Integer> liveSSTableCount;
    public final Gauge<Integer> oldVersionSSTableCount;
    public final Gauge<Long> maxSSTableDuration;
    public final Gauge<Long> maxSSTableSize;
    public final Counter liveDiskSpaceUsed;
    public final Counter uncompressedLiveDiskSpaceUsed;
    public final Counter totalDiskSpaceUsed;
    public final Gauge<Long> minPartitionSize;
    public final Gauge<Long> maxPartitionSize;
    public final Gauge<Long> meanPartitionSize;
    public final Gauge<Long> compressionMetadataOffHeapMemoryUsed;
    public final TableHistogram tombstoneScannedHistogram;
    public final TableHistogram liveScannedHistogram;
    public final TableHistogram colUpdateTimeDeltaHistogram;
    public final TableTimer viewLockAcquireTime;
    public final TableTimer viewReadTime;
    public final Gauge<Long> trueSnapshotsSize;
    public final Counter rowCacheHitOutOfRange;
    public final Counter rowCacheHit;
    public final Counter rowCacheMiss;
    public final Counter tombstoneFailures;
    public final Counter tombstoneWarnings;
    public final LatencyMetrics casPrepare;
    public final LatencyMetrics casPropose;
    public final LatencyMetrics casCommit;
    public final Gauge<Double> percentRepaired;
    public final Gauge<Long> bytesRepaired;
    public final Gauge<Long> bytesUnrepaired;
    public final Gauge<Long> bytesPendingRepair;
    public final Counter repairsStarted;
    public final Counter repairsCompleted;
    public final TableTimer anticompactionTime;
    public final TableTimer validationTime;
    public final TableTimer repairSyncTime;
    public final TableHistogram bytesValidated;
    public final TableHistogram partitionsValidated;
    public final Counter bytesAnticompacted;
    public final Counter bytesMutatedAnticompaction;
    public final Gauge<Double> mutatedAnticompactionGauge;
    public final SnapshottingTimer coordinatorReadLatency;
    public final Timer coordinatorScanLatency;
    public final SnapshottingTimer coordinatorWriteLatency;
    private final MetricNameFactory factory;
    private final MetricNameFactory aliasFactory;
    public final Counter speculativeRetries;
    public final Counter speculativeFailedRetries;
    public final Counter speculativeInsufficientReplicas;
    public final Gauge<Long> speculativeSampleLatencyNanos;
    public final Counter additionalWrites;
    public final Gauge<Long> additionalWriteLatencyNanos;
    public final Gauge<Integer> unleveledSSTables;
    public final TableMeter confirmedRepairedInconsistencies;
    public final TableMeter unconfirmedRepairedInconsistencies;
    public final TableHistogram repairedDataTrackingOverreadRows;
    public final TableTimer repairedDataTrackingOverreadTime;
    public final Sampler<ByteBuffer> topReadPartitionFrequency;
    public final Sampler<ByteBuffer> topWritePartitionFrequency;
    public final Sampler<ByteBuffer> topWritePartitionSize;
    public final Sampler<ByteBuffer> topCasPartitionContention;
    public final Sampler<String> topLocalReadQueryTime;
    public final Sampler<ByteBuffer> topReadPartitionRowCount;
    public final Sampler<ByteBuffer> topReadPartitionTombstoneCount;
    public final Sampler<ByteBuffer> topReadPartitionSSTableCount;
    public final TableMeter clientTombstoneWarnings;
    public final TableMeter clientTombstoneAborts;
    public final TableMeter coordinatorReadSizeWarnings;
    public final TableMeter coordinatorReadSizeAborts;
    public final TableHistogram coordinatorReadSize;
    public final TableMeter localReadSizeWarnings;
    public final TableMeter localReadSizeAborts;
    public final TableHistogram localReadSize;
    public final TableMeter rowIndexSizeWarnings;
    public final TableMeter rowIndexSizeAborts;
    public final TableHistogram rowIndexSize;
    public final TableMeter tooManySSTableIndexesReadWarnings;
    public final TableMeter tooManySSTableIndexesReadAborts;
    public final ImmutableMap<SSTableFormat<?, ?>, ImmutableMap<String, Gauge<? extends Number>>> formatSpecificGauges;
    public static final Gauge<Double> globalPercentRepaired = CassandraMetricsRegistry.Metrics.register(GLOBAL_FACTORY.createMetricName("PercentRepaired"), new Gauge<Double>(){

        public Double getValue() {
            Pair<Long, Long> result = TableMetrics.totalNonSystemTablesSize(SSTableReader::isRepaired);
            double repaired = ((Long)result.left).longValue();
            double total = ((Long)result.right).longValue();
            return total > 0.0 ? repaired / total * 100.0 : 100.0;
        }
    });
    public static final Gauge<Long> globalBytesRepaired = CassandraMetricsRegistry.Metrics.register(GLOBAL_FACTORY.createMetricName("BytesRepaired"), () -> (Long)TableMetrics.totalNonSystemTablesSize((Predicate<SSTableReader>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isRepaired(), (Lorg/apache/cassandra/io/sstable/format/SSTableReader;)Z)()).left);
    public static final Gauge<Long> globalBytesUnrepaired = CassandraMetricsRegistry.Metrics.register(GLOBAL_FACTORY.createMetricName("BytesUnrepaired"), () -> (Long)TableMetrics.totalNonSystemTablesSize((Predicate<SSTableReader>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$static$1(org.apache.cassandra.io.sstable.format.SSTableReader ), (Lorg/apache/cassandra/io/sstable/format/SSTableReader;)Z)()).left);
    public static final Gauge<Long> globalBytesPendingRepair = CassandraMetricsRegistry.Metrics.register(GLOBAL_FACTORY.createMetricName("BytesPendingRepair"), () -> (Long)TableMetrics.totalNonSystemTablesSize((Predicate<SSTableReader>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isPendingRepair(), (Lorg/apache/cassandra/io/sstable/format/SSTableReader;)Z)()).left);
    public final Meter readRepairRequests;
    public final Meter shortReadProtectionRequests;
    public final Meter replicaFilteringProtectionRequests;
    public final Histogram rfpRowsCachedPerQuery;
    public final EnumMap<Sampler.SamplerType, Sampler<?>> samplers;
    private final Set<ReleasableMetric> all = Sets.newHashSet();

    private static Pair<Long, Long> totalNonSystemTablesSize(Predicate<SSTableReader> predicate) {
        long total = 0L;
        long filtered = 0L;
        for (String keyspace : Schema.instance.distributedKeyspaces().names()) {
            Keyspace k = Schema.instance.getKeyspaceInstance(keyspace);
            if ("system_distributed".equals(k.getName()) || k.getReplicationStrategy().getReplicationFactor().allReplicas < 2) continue;
            for (ColumnFamilyStore cf : k.getColumnFamilyStores()) {
                if (SecondaryIndexManager.isIndexColumnFamily(cf.name)) continue;
                for (SSTableReader sstable : cf.getSSTables(SSTableSet.CANONICAL)) {
                    if (predicate.test(sstable)) {
                        filtered += sstable.uncompressedLength();
                    }
                    total += sstable.uncompressedLength();
                }
            }
        }
        return Pair.create(filtered, total);
    }

    private static long[] combineHistograms(Iterable<SSTableReader> sstables, GetHistogram getHistogram) {
        Iterator<SSTableReader> iterator = sstables.iterator();
        if (!iterator.hasNext()) {
            return ArrayUtils.EMPTY_LONG_ARRAY;
        }
        long[] firstBucket = getHistogram.getHistogram(iterator.next()).getBuckets(false);
        long[] values = Arrays.copyOf(firstBucket, firstBucket.length);
        while (iterator.hasNext()) {
            long[] nextBucket = getHistogram.getHistogram(iterator.next()).getBuckets(false);
            values = TableMetrics.addHistogram(values, nextBucket);
        }
        return values;
    }

    @VisibleForTesting
    public static long[] addHistogram(long[] sums, long[] buckets) {
        if (buckets.length > sums.length) {
            sums = Arrays.copyOf(sums, buckets.length);
        }
        for (int i = 0; i < buckets.length; ++i) {
            int n = i;
            sums[n] = sums[n] + buckets[i];
        }
        return sums;
    }

    public TableMetrics(final ColumnFamilyStore cfs, ReleasableMetric memtableMetrics) {
        this.factory = new TableMetricNameFactory(cfs, "Table");
        this.aliasFactory = new TableMetricNameFactory(cfs, "ColumnFamily");
        if (memtableMetrics != null) {
            this.all.add(memtableMetrics);
        }
        this.samplers = new EnumMap(Sampler.SamplerType.class);
        this.topReadPartitionFrequency = new FrequencySampler<ByteBuffer>(){

            @Override
            public String toString(ByteBuffer value) {
                return cfs.metadata().partitionKeyType.getString(value);
            }
        };
        this.topWritePartitionFrequency = new FrequencySampler<ByteBuffer>(){

            @Override
            public String toString(ByteBuffer value) {
                return cfs.metadata().partitionKeyType.getString(value);
            }
        };
        this.topWritePartitionSize = new MaxSampler<ByteBuffer>(){

            @Override
            public String toString(ByteBuffer value) {
                return cfs.metadata().partitionKeyType.getString(value);
            }
        };
        this.topCasPartitionContention = new FrequencySampler<ByteBuffer>(){

            @Override
            public String toString(ByteBuffer value) {
                return cfs.metadata().partitionKeyType.getString(value);
            }
        };
        this.topLocalReadQueryTime = new MaxSampler<String>(){

            @Override
            public String toString(String value) {
                return value;
            }
        };
        this.topReadPartitionRowCount = new MaxSampler<ByteBuffer>(){

            @Override
            public String toString(ByteBuffer value) {
                return cfs.metadata().partitionKeyType.getString(value);
            }
        };
        this.topReadPartitionTombstoneCount = new MaxSampler<ByteBuffer>(){

            @Override
            public String toString(ByteBuffer value) {
                return cfs.metadata().partitionKeyType.getString(value);
            }
        };
        this.topReadPartitionSSTableCount = new MaxSampler<ByteBuffer>(){

            @Override
            public String toString(ByteBuffer value) {
                return cfs.metadata().partitionKeyType.getString(value);
            }
        };
        this.samplers.put(Sampler.SamplerType.READS, this.topReadPartitionFrequency);
        this.samplers.put(Sampler.SamplerType.WRITES, this.topWritePartitionFrequency);
        this.samplers.put(Sampler.SamplerType.WRITE_SIZE, this.topWritePartitionSize);
        this.samplers.put(Sampler.SamplerType.CAS_CONTENTIONS, this.topCasPartitionContention);
        this.samplers.put(Sampler.SamplerType.LOCAL_READ_TIME, this.topLocalReadQueryTime);
        this.samplers.put(Sampler.SamplerType.READ_ROW_COUNT, this.topReadPartitionRowCount);
        this.samplers.put(Sampler.SamplerType.READ_TOMBSTONE_COUNT, this.topReadPartitionTombstoneCount);
        this.samplers.put(Sampler.SamplerType.READ_SSTABLE_COUNT, this.topReadPartitionSSTableCount);
        this.memtableColumnsCount = this.createTableGauge("MemtableColumnsCount", () -> cfs.getTracker().getView().getCurrentMemtable().operationCount());
        this.memtableOnHeapDataSize = this.createTableGaugeWithDeprecation("MemtableOnHeapDataSize", "MemtableOnHeapSize", () -> Memtable.getMemoryUsage((Memtable)cfs.getTracker().getView().getCurrentMemtable()).ownsOnHeap, new GlobalTableGauge("MemtableOnHeapDataSize"));
        this.memtableOffHeapDataSize = this.createTableGaugeWithDeprecation("MemtableOffHeapDataSize", "MemtableOffHeapSize", () -> Memtable.getMemoryUsage((Memtable)cfs.getTracker().getView().getCurrentMemtable()).ownsOffHeap, new GlobalTableGauge("MemtableOnHeapDataSize"));
        this.memtableLiveDataSize = this.createTableGauge("MemtableLiveDataSize", () -> cfs.getTracker().getView().getCurrentMemtable().getLiveDataSize());
        this.allMemtablesOnHeapDataSize = this.createTableGaugeWithDeprecation("AllMemtablesOnHeapDataSize", "AllMemtablesHeapSize", new Gauge<Long>(){

            public Long getValue() {
                return TableMetrics.this.getMemoryUsageWithIndexes((ColumnFamilyStore)cfs).ownsOnHeap;
            }
        }, new GlobalTableGauge("AllMemtablesOnHeapDataSize"));
        this.allMemtablesOffHeapDataSize = this.createTableGaugeWithDeprecation("AllMemtablesOffHeapDataSize", "AllMemtablesOffHeapSize", new Gauge<Long>(){

            public Long getValue() {
                return TableMetrics.this.getMemoryUsageWithIndexes((ColumnFamilyStore)cfs).ownsOffHeap;
            }
        }, new GlobalTableGauge("AllMemtablesOffHeapDataSize"));
        this.allMemtablesLiveDataSize = this.createTableGauge("AllMemtablesLiveDataSize", new Gauge<Long>(){

            public Long getValue() {
                long size = 0L;
                for (ColumnFamilyStore cfs2 : cfs.concatWithIndexes()) {
                    size += cfs2.getTracker().getView().getCurrentMemtable().getLiveDataSize();
                }
                return size;
            }
        });
        this.memtableSwitchCount = this.createTableCounter("MemtableSwitchCount");
        this.estimatedPartitionSizeHistogram = this.createTableGauge("EstimatedPartitionSizeHistogram", "EstimatedRowSizeHistogram", () -> TableMetrics.combineHistograms(cfs.getSSTables(SSTableSet.CANONICAL), SSTableReader::getEstimatedPartitionSize), null);
        this.estimatedPartitionCount = this.createTableGauge("EstimatedPartitionCount", "EstimatedRowCount", new Gauge<Long>(){

            public Long getValue() {
                long memtablePartitions = 0L;
                for (Memtable memtable : cfs.getTracker().getView().getAllMemtables()) {
                    memtablePartitions += memtable.partitionCount();
                }
                try (ColumnFamilyStore.RefViewFragment refViewFragment = cfs.selectAndReference(View.selectFunction(SSTableSet.CANONICAL));){
                    Long l = SSTableReader.getApproximateKeyCount(refViewFragment.sstables) + memtablePartitions;
                    return l;
                }
            }
        }, null);
        this.estimatedColumnCountHistogram = this.createTableGauge("EstimatedColumnCountHistogram", "EstimatedColumnCountHistogram", () -> TableMetrics.combineHistograms(cfs.getSSTables(SSTableSet.CANONICAL), SSTableReader::getEstimatedCellPerPartitionCount), null);
        this.sstablesPerReadHistogram = this.createTableHistogram("SSTablesPerReadHistogram", cfs.keyspace.metric.sstablesPerReadHistogram, true);
        this.sstablesPerRangeReadHistogram = this.createTableHistogram("SSTablesPerRangeReadHistogram", cfs.keyspace.metric.sstablesPerRangeReadHistogram, true);
        this.compressionRatio = this.createTableGauge("CompressionRatio", new Gauge<Double>(){

            public Double getValue() {
                return TableMetrics.computeCompressionRatio(cfs.getSSTables(SSTableSet.CANONICAL));
            }
        }, new Gauge<Double>(){

            public Double getValue() {
                ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>();
                Keyspace.all().forEach(ks -> sstables.addAll(ks.getAllSSTables(SSTableSet.CANONICAL)));
                return TableMetrics.computeCompressionRatio(sstables);
            }
        });
        this.percentRepaired = this.createTableGauge("PercentRepaired", new Gauge<Double>(){

            public Double getValue() {
                double repaired = 0.0;
                double total = 0.0;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.CANONICAL)) {
                    if (sstable.isRepaired()) {
                        repaired += (double)sstable.uncompressedLength();
                    }
                    total += (double)sstable.uncompressedLength();
                }
                return total > 0.0 ? repaired / total * 100.0 : 100.0;
            }
        });
        this.bytesRepaired = this.createTableGauge("BytesRepaired", new Gauge<Long>(){

            public Long getValue() {
                long size = 0L;
                for (SSTableReader sstable : Iterables.filter(cfs.getSSTables(SSTableSet.CANONICAL), SSTableReader::isRepaired)) {
                    size += sstable.uncompressedLength();
                }
                return size;
            }
        });
        this.bytesUnrepaired = this.createTableGauge("BytesUnrepaired", new Gauge<Long>(){

            public Long getValue() {
                long size = 0L;
                for (SSTableReader sstable : Iterables.filter(cfs.getSSTables(SSTableSet.CANONICAL), s -> !s.isRepaired() && !s.isPendingRepair())) {
                    size += sstable.uncompressedLength();
                }
                return size;
            }
        });
        this.bytesPendingRepair = this.createTableGauge("BytesPendingRepair", new Gauge<Long>(){

            public Long getValue() {
                long size = 0L;
                for (SSTableReader sstable : Iterables.filter(cfs.getSSTables(SSTableSet.CANONICAL), SSTableReader::isPendingRepair)) {
                    size += sstable.uncompressedLength();
                }
                return size;
            }
        });
        this.readLatency = this.createLatencyMetrics("Read", cfs.keyspace.metric.readLatency, GLOBAL_READ_LATENCY);
        this.writeLatency = this.createLatencyMetrics("Write", cfs.keyspace.metric.writeLatency, GLOBAL_WRITE_LATENCY);
        this.rangeLatency = this.createLatencyMetrics("Range", cfs.keyspace.metric.rangeLatency, GLOBAL_RANGE_LATENCY);
        this.pendingFlushes = this.createTableCounter("PendingFlushes");
        this.bytesFlushed = this.createTableCounter("BytesFlushed");
        this.flushSizeOnDisk = ExpMovingAverage.decayBy1000();
        this.compactionBytesWritten = this.createTableCounter("CompactionBytesWritten");
        this.pendingCompactions = this.createTableGauge("PendingCompactions", () -> cfs.getCompactionStrategyManager().getEstimatedRemainingTasks());
        this.liveSSTableCount = this.createTableGauge("LiveSSTableCount", () -> cfs.getTracker().getView().liveSSTables().size());
        this.oldVersionSSTableCount = this.createTableGauge("OldVersionSSTableCount", new Gauge<Integer>(){

            public Integer getValue() {
                int count = 0;
                for (SSTableReader sstable : cfs.getLiveSSTables()) {
                    if (sstable.descriptor.version.isLatestVersion()) continue;
                    ++count;
                }
                return count;
            }
        });
        this.maxSSTableDuration = this.createTableGauge("MaxSSTableDuration", new Gauge<Long>(){

            public Long getValue() {
                return cfs.getTracker().getView().liveSSTables().stream().filter(sstable -> sstable.getMinTimestamp() != Long.MAX_VALUE && sstable.getMaxTimestamp() != Long.MAX_VALUE).map(ssTableReader -> ssTableReader.getMaxTimestamp() - ssTableReader.getMinTimestamp()).max(Long::compare).orElse(0L) / 1000L;
            }
        });
        this.maxSSTableSize = this.createTableGauge("MaxSSTableSize", new Gauge<Long>(){

            public Long getValue() {
                return cfs.getTracker().getView().liveSSTables().stream().map(SSTableReader::bytesOnDisk).max(Long::compare).orElse(0L);
            }
        });
        this.liveDiskSpaceUsed = this.createTableCounter("LiveDiskSpaceUsed");
        this.uncompressedLiveDiskSpaceUsed = this.createTableCounter("UncompressedLiveDiskSpaceUsed");
        this.totalDiskSpaceUsed = this.createTableCounter("TotalDiskSpaceUsed");
        this.minPartitionSize = this.createTableGauge("MinPartitionSize", "MinRowSize", new Gauge<Long>(){

            public Long getValue() {
                long min = 0L;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.CANONICAL)) {
                    if (min != 0L && sstable.getEstimatedPartitionSize().min() >= min) continue;
                    min = sstable.getEstimatedPartitionSize().min();
                }
                return min;
            }
        }, new Gauge<Long>(){

            public Long getValue() {
                long min = Long.MAX_VALUE;
                for (Metric cfGauge : (Set)ALL_TABLE_METRICS.get("MinPartitionSize")) {
                    min = Math.min(min, ((Number)((Gauge)cfGauge).getValue()).longValue());
                }
                return min;
            }
        });
        this.maxPartitionSize = this.createTableGauge("MaxPartitionSize", "MaxRowSize", new Gauge<Long>(){

            public Long getValue() {
                long max = 0L;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.CANONICAL)) {
                    if (sstable.getEstimatedPartitionSize().max() <= max) continue;
                    max = sstable.getEstimatedPartitionSize().max();
                }
                return max;
            }
        }, new Gauge<Long>(){

            public Long getValue() {
                long max = 0L;
                for (Metric cfGauge : (Set)ALL_TABLE_METRICS.get("MaxPartitionSize")) {
                    max = Math.max(max, ((Number)((Gauge)cfGauge).getValue()).longValue());
                }
                return max;
            }
        });
        this.meanPartitionSize = this.createTableGauge("MeanPartitionSize", "MeanRowSize", new Gauge<Long>(){

            public Long getValue() {
                long sum = 0L;
                long count = 0L;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.CANONICAL)) {
                    long n = sstable.getEstimatedPartitionSize().count();
                    sum += sstable.getEstimatedPartitionSize().mean() * n;
                    count += n;
                }
                return count > 0L ? sum / count : 0L;
            }
        }, new Gauge<Long>(){

            public Long getValue() {
                long sum = 0L;
                long count = 0L;
                for (Keyspace keyspace : Keyspace.all()) {
                    for (SSTableReader sstable : keyspace.getAllSSTables(SSTableSet.CANONICAL)) {
                        long n = sstable.getEstimatedPartitionSize().count();
                        sum += sstable.getEstimatedPartitionSize().mean() * n;
                        count += n;
                    }
                }
                return count > 0L ? sum / count : 0L;
            }
        });
        this.compressionMetadataOffHeapMemoryUsed = this.createTableGauge("CompressionMetadataOffHeapMemoryUsed", new Gauge<Long>(){

            public Long getValue() {
                long total = 0L;
                for (SSTableReader sst : cfs.getSSTables(SSTableSet.LIVE)) {
                    total += sst.getCompressionMetadataOffHeapSize();
                }
                return total;
            }
        });
        this.speculativeRetries = this.createTableCounter("SpeculativeRetries");
        this.speculativeFailedRetries = this.createTableCounter("SpeculativeFailedRetries");
        this.speculativeInsufficientReplicas = this.createTableCounter("SpeculativeInsufficientReplicas");
        this.speculativeSampleLatencyNanos = this.createTableGauge("SpeculativeSampleLatencyNanos", () -> TimeUnit.MICROSECONDS.toNanos(cfs.sampleReadLatencyMicros));
        this.additionalWrites = this.createTableCounter("AdditionalWrites");
        this.additionalWriteLatencyNanos = this.createTableGauge("AdditionalWriteLatencyNanos", () -> TimeUnit.MICROSECONDS.toNanos(cfs.additionalWriteLatencyMicros));
        this.tombstoneScannedHistogram = this.createTableHistogram("TombstoneScannedHistogram", cfs.keyspace.metric.tombstoneScannedHistogram, false);
        this.liveScannedHistogram = this.createTableHistogram("LiveScannedHistogram", cfs.keyspace.metric.liveScannedHistogram, false);
        this.colUpdateTimeDeltaHistogram = this.createTableHistogram("ColUpdateTimeDeltaHistogram", cfs.keyspace.metric.colUpdateTimeDeltaHistogram, false);
        this.coordinatorReadLatency = this.createTableTimer("CoordinatorReadLatency");
        this.coordinatorScanLatency = this.createTableTimer("CoordinatorScanLatency");
        this.coordinatorWriteLatency = this.createTableTimer("CoordinatorWriteLatency");
        if (cfs.metadata().isView()) {
            this.viewLockAcquireTime = null;
            this.viewReadTime = null;
        } else {
            this.viewLockAcquireTime = this.createTableTimer("ViewLockAcquireTime", cfs.keyspace.metric.viewLockAcquireTime);
            this.viewReadTime = this.createTableTimer("ViewReadTime", cfs.keyspace.metric.viewReadTime);
        }
        this.trueSnapshotsSize = this.createTableGauge("SnapshotsSize", cfs::trueSnapshotsSize);
        this.rowCacheHitOutOfRange = this.createTableCounter("RowCacheHitOutOfRange");
        this.rowCacheHit = this.createTableCounter("RowCacheHit");
        this.rowCacheMiss = this.createTableCounter("RowCacheMiss");
        this.tombstoneFailures = this.createTableCounter("TombstoneFailures");
        this.tombstoneWarnings = this.createTableCounter("TombstoneWarnings");
        this.casPrepare = this.createLatencyMetrics("CasPrepare", cfs.keyspace.metric.casPrepare);
        this.casPropose = this.createLatencyMetrics("CasPropose", cfs.keyspace.metric.casPropose);
        this.casCommit = this.createLatencyMetrics("CasCommit", cfs.keyspace.metric.casCommit);
        this.repairsStarted = this.createTableCounter("RepairJobsStarted");
        this.repairsCompleted = this.createTableCounter("RepairJobsCompleted");
        this.anticompactionTime = this.createTableTimer("AnticompactionTime", cfs.keyspace.metric.anticompactionTime);
        this.validationTime = this.createTableTimer("ValidationTime", cfs.keyspace.metric.validationTime);
        this.repairSyncTime = this.createTableTimer("RepairSyncTime", cfs.keyspace.metric.repairSyncTime);
        this.bytesValidated = this.createTableHistogram("BytesValidated", cfs.keyspace.metric.bytesValidated, false);
        this.partitionsValidated = this.createTableHistogram("PartitionsValidated", cfs.keyspace.metric.partitionsValidated, false);
        this.bytesAnticompacted = this.createTableCounter("BytesAnticompacted");
        this.bytesMutatedAnticompaction = this.createTableCounter("BytesMutatedAnticompaction");
        this.mutatedAnticompactionGauge = this.createTableGauge("MutatedAnticompactionGauge", () -> {
            double bytesMutated = this.bytesMutatedAnticompaction.getCount();
            double bytesAnticomp = this.bytesAnticompacted.getCount();
            if (bytesAnticomp + bytesMutated > 0.0) {
                return bytesMutated / (bytesAnticomp + bytesMutated);
            }
            return 0.0;
        });
        this.readRepairRequests = this.createTableMeter("ReadRepairRequests");
        this.shortReadProtectionRequests = this.createTableMeter("ShortReadProtectionRequests");
        this.replicaFilteringProtectionRequests = this.createTableMeter("ReplicaFilteringProtectionRequests");
        this.rfpRowsCachedPerQuery = this.createHistogram("ReplicaFilteringProtectionRowsCachedPerQuery", true);
        this.confirmedRepairedInconsistencies = this.createTableMeter("RepairedDataInconsistenciesConfirmed", cfs.keyspace.metric.confirmedRepairedInconsistencies);
        this.unconfirmedRepairedInconsistencies = this.createTableMeter("RepairedDataInconsistenciesUnconfirmed", cfs.keyspace.metric.unconfirmedRepairedInconsistencies);
        this.repairedDataTrackingOverreadRows = this.createTableHistogram("RepairedDataTrackingOverreadRows", cfs.keyspace.metric.repairedDataTrackingOverreadRows, false);
        this.repairedDataTrackingOverreadTime = this.createTableTimer("RepairedDataTrackingOverreadTime", cfs.keyspace.metric.repairedDataTrackingOverreadTime);
        this.unleveledSSTables = this.createTableGauge("UnleveledSSTables", cfs::getUnleveledSSTables, () -> {
            int cnt = 0;
            for (Metric cfGauge : (Set)ALL_TABLE_METRICS.get("UnleveledSSTables")) {
                cnt += ((Number)((Gauge)cfGauge).getValue()).intValue();
            }
            return cnt;
        });
        this.clientTombstoneWarnings = this.createTableMeter("ClientTombstoneWarnings", cfs.keyspace.metric.clientTombstoneWarnings);
        this.clientTombstoneAborts = this.createTableMeter("ClientTombstoneAborts", cfs.keyspace.metric.clientTombstoneAborts);
        this.coordinatorReadSizeWarnings = this.createTableMeter("CoordinatorReadSizeWarnings", cfs.keyspace.metric.coordinatorReadSizeWarnings);
        this.coordinatorReadSizeAborts = this.createTableMeter("CoordinatorReadSizeAborts", cfs.keyspace.metric.coordinatorReadSizeAborts);
        this.coordinatorReadSize = this.createTableHistogram("CoordinatorReadSize", cfs.keyspace.metric.coordinatorReadSize, false);
        this.localReadSizeWarnings = this.createTableMeter("LocalReadSizeWarnings", cfs.keyspace.metric.localReadSizeWarnings);
        this.localReadSizeAborts = this.createTableMeter("LocalReadSizeAborts", cfs.keyspace.metric.localReadSizeAborts);
        this.localReadSize = this.createTableHistogram("LocalReadSize", cfs.keyspace.metric.localReadSize, false);
        this.rowIndexSizeWarnings = this.createTableMeter("RowIndexSizeWarnings", cfs.keyspace.metric.rowIndexSizeWarnings);
        this.rowIndexSizeAborts = this.createTableMeter("RowIndexSizeAborts", cfs.keyspace.metric.rowIndexSizeAborts);
        this.rowIndexSize = this.createTableHistogram("RowIndexSize", cfs.keyspace.metric.rowIndexSize, false);
        this.tooManySSTableIndexesReadWarnings = this.createTableMeter("TooManySSTableIndexesReadWarnings", cfs.keyspace.metric.tooManySSTableIndexesReadWarnings);
        this.tooManySSTableIndexesReadAborts = this.createTableMeter("TooManySSTableIndexesReadAborts", cfs.keyspace.metric.tooManySSTableIndexesReadAborts);
        this.formatSpecificGauges = this.createFormatSpecificGauges(cfs);
    }

    private Memtable.MemoryUsage getMemoryUsageWithIndexes(ColumnFamilyStore cfs) {
        Memtable.MemoryUsage usage = Memtable.newMemoryUsage();
        cfs.getTracker().getView().getCurrentMemtable().addMemoryUsageTo(usage);
        for (ColumnFamilyStore indexCfs : cfs.indexManager.getAllIndexColumnFamilyStores()) {
            indexCfs.getTracker().getView().getCurrentMemtable().addMemoryUsageTo(usage);
        }
        return usage;
    }

    public void updateSSTableIterated(int count) {
        this.sstablesPerReadHistogram.update(count);
    }

    public void updateSSTableIteratedInRangeRead(int count) {
        this.sstablesPerRangeReadHistogram.update(count);
    }

    public void release() {
        for (ReleasableMetric entry : this.all) {
            entry.release();
        }
    }

    private ImmutableMap<SSTableFormat<?, ?>, ImmutableMap<String, Gauge<? extends Number>>> createFormatSpecificGauges(ColumnFamilyStore cfs) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SSTableFormat format : DatabaseDescriptor.getSSTableFormats().values()) {
            ImmutableMap.Builder gauges = ImmutableMap.builder();
            for (GaugeProvider<?> gaugeProvider : format.getFormatSpecificMetricsProviders().getGaugeProviders()) {
                Gauge<?> gauge = this.createTableGauge(gaugeProvider.name, gaugeProvider.getTableGauge(cfs), gaugeProvider.getGlobalGauge());
                gauges.put((Object)gaugeProvider.name, gauge);
            }
            builder.put((Object)format, (Object)gauges.build());
        }
        return builder.build();
    }

    protected <T extends Number> Gauge<T> createTableGauge(String name, Gauge<T> gauge) {
        return this.createTableGauge(name, gauge, new GlobalTableGauge(name));
    }

    protected <G, T> Gauge<T> createTableGauge(String name, Gauge<T> gauge, Gauge<G> globalGauge) {
        return this.createTableGauge(name, name, gauge, globalGauge);
    }

    protected <G, T> Gauge<T> createTableGauge(String name, String alias, Gauge<T> gauge, Gauge<G> globalGauge) {
        Gauge<T> cfGauge = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName(name), this.aliasFactory.createMetricName(alias), gauge);
        if (this.register(name, alias, (Metric)cfGauge) && globalGauge != null) {
            CassandraMetricsRegistry.Metrics.register(GLOBAL_FACTORY.createMetricName(name), GLOBAL_ALIAS_FACTORY.createMetricName(alias), globalGauge);
        }
        return cfGauge;
    }

    protected <G, T> Gauge<T> createTableGaugeWithDeprecation(String name, String deprecated, Gauge<T> gauge, Gauge<G> globalGauge) {
        assert (deprecated != null) : "no deprecated metric name provided";
        assert (globalGauge != null) : "no global Gauge metric provided";
        Gauge<T> cfGauge = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName(name), gauge, new CassandraMetricsRegistry.MetricName[]{this.aliasFactory.createMetricName(name), this.factory.createMetricName(deprecated), this.aliasFactory.createMetricName(deprecated)});
        if (this.register(name, name, deprecated, (Metric)cfGauge)) {
            CassandraMetricsRegistry.Metrics.register(GLOBAL_FACTORY.createMetricName(name), globalGauge, new CassandraMetricsRegistry.MetricName[]{GLOBAL_ALIAS_FACTORY.createMetricName(name), GLOBAL_FACTORY.createMetricName(deprecated), GLOBAL_ALIAS_FACTORY.createMetricName(deprecated)});
        }
        return cfGauge;
    }

    protected Counter createTableCounter(String name) {
        return this.createTableCounter(name, name);
    }

    protected Counter createTableCounter(final String name, String alias) {
        Counter cfCounter = CassandraMetricsRegistry.Metrics.counter(this.factory.createMetricName(name), this.aliasFactory.createMetricName(alias));
        if (this.register(name, alias, (Metric)cfCounter)) {
            CassandraMetricsRegistry.Metrics.register(GLOBAL_FACTORY.createMetricName(name), GLOBAL_ALIAS_FACTORY.createMetricName(alias), new Gauge<Long>(){

                public Long getValue() {
                    long total = 0L;
                    for (Metric cfGauge : (Set)ALL_TABLE_METRICS.get(name)) {
                        total += ((Counter)cfGauge).getCount();
                    }
                    return total;
                }
            });
        }
        return cfCounter;
    }

    private Meter createTableMeter(String name) {
        return this.createTableMeter(name, name);
    }

    private Meter createTableMeter(String name, String alias) {
        Meter tableMeter = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName(name), this.aliasFactory.createMetricName(alias));
        this.register(name, alias, (Metric)tableMeter);
        return tableMeter;
    }

    private Histogram createHistogram(String name, boolean considerZeroes) {
        Histogram histogram = CassandraMetricsRegistry.Metrics.histogram(this.factory.createMetricName(name), this.aliasFactory.createMetricName(name), considerZeroes);
        this.register(name, name, (Metric)histogram);
        return histogram;
    }

    private static Double computeCompressionRatio(Iterable<SSTableReader> sstables) {
        double compressedLengthSum = 0.0;
        double dataLengthSum = 0.0;
        for (SSTableReader sstable : sstables) {
            if (!sstable.compression) continue;
            assert (sstable.openReason != SSTableReader.OpenReason.EARLY);
            CompressionMetadata compressionMetadata = sstable.getCompressionMetadata();
            compressedLengthSum += (double)compressionMetadata.compressedFileLength;
            dataLengthSum += (double)compressionMetadata.dataLength;
        }
        return dataLengthSum != 0.0 ? compressedLengthSum / dataLengthSum : -1.0;
    }

    protected TableHistogram createTableHistogram(String name, Histogram keyspaceHistogram, boolean considerZeroes) {
        return this.createTableHistogram(name, name, keyspaceHistogram, considerZeroes);
    }

    protected TableHistogram createTableHistogram(String name, String alias, Histogram keyspaceHistogram, boolean considerZeroes) {
        Histogram cfHistogram = CassandraMetricsRegistry.Metrics.histogram(this.factory.createMetricName(name), this.aliasFactory.createMetricName(alias), considerZeroes);
        this.register(name, alias, (Metric)cfHistogram);
        return new TableHistogram(cfHistogram, keyspaceHistogram, CassandraMetricsRegistry.Metrics.histogram(GLOBAL_FACTORY.createMetricName(name), GLOBAL_ALIAS_FACTORY.createMetricName(alias), considerZeroes));
    }

    protected Histogram createTableHistogram(String name, boolean considerZeroes) {
        return this.createTableHistogram(name, name, considerZeroes);
    }

    protected Histogram createTableHistogram(String name, String alias, boolean considerZeroes) {
        Histogram tableHistogram = CassandraMetricsRegistry.Metrics.histogram(this.factory.createMetricName(name), this.aliasFactory.createMetricName(alias), considerZeroes);
        this.register(name, alias, (Metric)tableHistogram);
        return tableHistogram;
    }

    protected TableTimer createTableTimer(String name, Timer keyspaceTimer) {
        SnapshottingTimer cfTimer = CassandraMetricsRegistry.Metrics.timer(this.factory.createMetricName(name), this.aliasFactory.createMetricName(name));
        this.register(name, name, (Metric)keyspaceTimer);
        SnapshottingTimer global = CassandraMetricsRegistry.Metrics.timer(GLOBAL_FACTORY.createMetricName(name), GLOBAL_ALIAS_FACTORY.createMetricName(name));
        return new TableTimer(cfTimer, keyspaceTimer, global);
    }

    protected SnapshottingTimer createTableTimer(String name) {
        SnapshottingTimer tableTimer = CassandraMetricsRegistry.Metrics.timer(this.factory.createMetricName(name), this.aliasFactory.createMetricName(name));
        this.register(name, name, (Metric)tableTimer);
        return tableTimer;
    }

    protected TableMeter createTableMeter(String name, Meter keyspaceMeter) {
        return this.createTableMeter(name, name, keyspaceMeter);
    }

    protected TableMeter createTableMeter(String name, String alias, Meter keyspaceMeter) {
        Meter meter = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName(name), this.aliasFactory.createMetricName(alias));
        this.register(name, alias, (Metric)meter);
        return new TableMeter(meter, keyspaceMeter, CassandraMetricsRegistry.Metrics.meter(GLOBAL_FACTORY.createMetricName(name), GLOBAL_ALIAS_FACTORY.createMetricName(alias)));
    }

    private LatencyMetrics createLatencyMetrics(String namePrefix, LatencyMetrics ... parents) {
        LatencyMetrics metric = new LatencyMetrics(this.factory, namePrefix, parents);
        this.all.add(metric::release);
        return metric;
    }

    private boolean register(String name, String alias, Metric metric) {
        return this.register(name, alias, null, metric);
    }

    private boolean register(String name, String alias, String deprecated, Metric metric) {
        boolean ret = ALL_TABLE_METRICS.putIfAbsent(name, ConcurrentHashMap.newKeySet()) == null;
        ((Set)ALL_TABLE_METRICS.get(name)).add(metric);
        this.all.add(() -> this.releaseMetric(name, alias, deprecated));
        return ret;
    }

    private void releaseMetric(String tableMetricName, String cfMetricName, String tableMetricAlias) {
        CassandraMetricsRegistry.MetricName name = this.factory.createMetricName(tableMetricName);
        Metric metric = (Metric)CassandraMetricsRegistry.Metrics.getMetrics().get(name.getMetricName());
        if (metric != null) {
            ((Set)ALL_TABLE_METRICS.get(tableMetricName)).remove(metric);
            CassandraMetricsRegistry.MetricName cfAlias = this.aliasFactory.createMetricName(cfMetricName);
            if (tableMetricAlias != null) {
                CassandraMetricsRegistry.Metrics.remove(name, cfAlias, this.factory.createMetricName(tableMetricAlias), this.aliasFactory.createMetricName(tableMetricAlias));
            } else {
                CassandraMetricsRegistry.Metrics.remove(name, cfAlias);
            }
        }
    }

    private static /* synthetic */ boolean lambda$static$1(SSTableReader s) {
        return !s.isRepaired() && !s.isPendingRepair();
    }

    private static class GlobalTableGauge
    implements Gauge<Long> {
        private final String name;

        public GlobalTableGauge(String name) {
            this.name = name;
        }

        public Long getValue() {
            long total = 0L;
            for (Metric cfGauge : (Set)ALL_TABLE_METRICS.get(this.name)) {
                total += ((Number)((Gauge)cfGauge).getValue()).longValue();
            }
            return total;
        }
    }

    @FunctionalInterface
    public static interface ReleasableMetric {
        public void release();
    }

    static class AllTableMetricNameFactory
    implements MetricNameFactory {
        private final String type;

        public AllTableMetricNameFactory(String type) {
            this.type = type;
        }

        @Override
        public CassandraMetricsRegistry.MetricName createMetricName(String metricName) {
            String groupName = TableMetrics.class.getPackage().getName();
            StringBuilder mbeanName = new StringBuilder();
            mbeanName.append(groupName).append(":");
            mbeanName.append("type=").append(this.type);
            mbeanName.append(",name=").append(metricName);
            return new CassandraMetricsRegistry.MetricName(groupName, this.type, metricName, "all", mbeanName.toString());
        }
    }

    static class TableMetricNameFactory
    implements MetricNameFactory {
        private final String keyspaceName;
        private final String tableName;
        private final boolean isIndex;
        private final String type;

        TableMetricNameFactory(ColumnFamilyStore cfs, String type) {
            this.keyspaceName = cfs.getKeyspaceName();
            this.tableName = cfs.name;
            this.isIndex = cfs.isIndex();
            this.type = type;
        }

        @Override
        public CassandraMetricsRegistry.MetricName createMetricName(String metricName) {
            String groupName = TableMetrics.class.getPackage().getName();
            Object type = this.isIndex ? "Index" + this.type : this.type;
            StringBuilder mbeanName = new StringBuilder();
            mbeanName.append(groupName).append(":");
            mbeanName.append("type=").append((String)type);
            mbeanName.append(",keyspace=").append(this.keyspaceName);
            mbeanName.append(",scope=").append(this.tableName);
            mbeanName.append(",name=").append(metricName);
            return new CassandraMetricsRegistry.MetricName(groupName, (String)type, metricName, this.keyspaceName + "." + this.tableName, mbeanName.toString());
        }
    }

    public static class TableTimer {
        public final Timer[] all;
        public final Timer cf;
        public final Timer global;

        private TableTimer(Timer cf, Timer keyspace, Timer global) {
            this.cf = cf;
            this.global = global;
            this.all = new Timer[]{cf, keyspace, global};
        }

        public void update(long i, TimeUnit unit) {
            for (Timer timer : this.all) {
                timer.update(i, unit);
            }
        }

        public Context time() {
            return new Context(this.all);
        }

        public static class Context
        implements AutoCloseable {
            private final long start;
            private final Timer[] all;

            private Context(Timer[] all) {
                this.all = all;
                this.start = Clock.Global.nanoTime();
            }

            @Override
            public void close() {
                long duration = Clock.Global.nanoTime() - this.start;
                for (Timer t : this.all) {
                    t.update(duration, TimeUnit.NANOSECONDS);
                }
            }
        }
    }

    public static class TableHistogram {
        public final Histogram[] all;
        public final Histogram cf;
        public final Histogram global;

        private TableHistogram(Histogram cf, Histogram keyspace, Histogram global) {
            this.cf = cf;
            this.global = global;
            this.all = new Histogram[]{cf, keyspace, global};
        }

        public void update(long i) {
            for (Histogram histo : this.all) {
                histo.update(i);
            }
        }
    }

    public static class TableMeter {
        public final Meter[] all;
        public final Meter table;
        public final Meter global;

        private TableMeter(Meter table, Meter keyspace, Meter global) {
            this.table = table;
            this.global = global;
            this.all = new Meter[]{table, keyspace, global};
        }

        public void mark() {
            for (Meter meter : this.all) {
                meter.mark();
            }
        }
    }

    private static interface GetHistogram {
        public EstimatedHistogram getHistogram(SSTableReader var1);
    }
}

