/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.util.Map;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.AbstractCloudMetadataServiceConnector;
import org.apache.cassandra.locator.AbstractNetworkTopologySnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractCloudMetadataServiceSnitch
extends AbstractNetworkTopologySnitch {
    static final Logger logger = LoggerFactory.getLogger(AbstractCloudMetadataServiceSnitch.class);
    static final String DEFAULT_DC = "UNKNOWN-DC";
    static final String DEFAULT_RACK = "UNKNOWN-RACK";
    protected final AbstractCloudMetadataServiceConnector connector;
    private final String localRack;
    private final String localDc;
    private Map<InetAddressAndPort, Map<String, String>> savedEndpoints;

    public AbstractCloudMetadataServiceSnitch(AbstractCloudMetadataServiceConnector connector, Pair<String, String> dcAndRack) {
        this.connector = connector;
        this.localDc = (String)dcAndRack.left;
        this.localRack = (String)dcAndRack.right;
        logger.info(String.format("%s using datacenter: %s, rack: %s, connector: %s, properties: %s", this.getClass().getName(), this.getLocalDatacenter(), this.getLocalRack(), connector, connector.getProperties()));
    }

    @Override
    public final String getLocalRack() {
        return this.localRack;
    }

    @Override
    public final String getLocalDatacenter() {
        return this.localDc;
    }

    @Override
    public final String getRack(InetAddressAndPort endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddressAndPort())) {
            return this.getLocalRack();
        }
        EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (state == null || state.getApplicationState(ApplicationState.RACK) == null) {
            if (this.savedEndpoints == null) {
                this.savedEndpoints = SystemKeyspace.loadDcRackInfo();
            }
            if (this.savedEndpoints.containsKey(endpoint)) {
                return this.savedEndpoints.get(endpoint).get("rack");
            }
            return DEFAULT_RACK;
        }
        return state.getApplicationState((ApplicationState)ApplicationState.RACK).value;
    }

    @Override
    public final String getDatacenter(InetAddressAndPort endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddressAndPort())) {
            return this.getLocalDatacenter();
        }
        EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (state == null || state.getApplicationState(ApplicationState.DC) == null) {
            if (this.savedEndpoints == null) {
                this.savedEndpoints = SystemKeyspace.loadDcRackInfo();
            }
            if (this.savedEndpoints.containsKey(endpoint)) {
                return this.savedEndpoints.get(endpoint).get("data_center");
            }
            return DEFAULT_DC;
        }
        return state.getApplicationState((ApplicationState)ApplicationState.DC).value;
    }
}

