/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.bti;

import java.io.IOException;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.format.bti.RowIndexReader;
import org.apache.cassandra.io.tries.IncrementalTrieWriter;
import org.apache.cassandra.io.tries.Walker;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;

class RowIndexWriter
implements AutoCloseable {
    private final ClusteringComparator comparator;
    private final IncrementalTrieWriter<RowIndexReader.IndexInfo> trie;
    private ByteComparable prevMax = null;
    private ByteComparable prevSep = null;

    RowIndexWriter(ClusteringComparator comparator, DataOutputPlus out, Version version) {
        this.comparator = comparator;
        this.trie = IncrementalTrieWriter.open(RowIndexReader.getSerializer(version), out);
    }

    void reset() {
        this.prevMax = null;
        this.prevSep = null;
        this.trie.reset();
    }

    @Override
    public void close() {
        this.trie.close();
    }

    void add(ClusteringPrefix<?> firstName, ClusteringPrefix<?> lastName, RowIndexReader.IndexInfo info) throws IOException {
        assert (info.openDeletion != null);
        ByteComparable sep = this.prevMax == null ? ByteComparable.EMPTY : ByteComparable.separatorGt(this.prevMax, this.comparator.asByteComparable(firstName));
        this.trie.add(sep, info);
        this.prevSep = sep;
        this.prevMax = this.comparator.asByteComparable(lastName);
    }

    public long complete(long endPos) throws IOException {
        int c;
        int i = 0;
        ByteSource max = this.prevMax.asComparableBytes(Walker.BYTE_COMPARABLE_VERSION);
        ByteSource sep = this.prevSep.asComparableBytes(Walker.BYTE_COMPARABLE_VERSION);
        while ((c = max.next()) == sep.next() && c != -1) {
            ++i;
        }
        assert (c != -1) : "Corrupted row order, max=" + this.prevMax;
        this.trie.add(this.nudge(this.prevMax, i), new RowIndexReader.IndexInfo(endPos, DeletionTime.LIVE));
        return this.trie.complete();
    }

    private ByteComparable nudge(final ByteComparable value, final int nudgeAt) {
        return version -> new ByteSource(){
            private final ByteSource v;
            private int cur;
            {
                this.v = value.asComparableBytes(version);
                this.cur = 0;
            }

            @Override
            public int next() {
                int b = -1;
                if (this.cur <= nudgeAt) {
                    b = this.v.next();
                    if (this.cur == nudgeAt) {
                        if (b < 255) {
                            ++b;
                        } else {
                            return b;
                        }
                    }
                }
                ++this.cur;
                return b;
            }
        };
    }
}

