/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import java.io.IOException;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.indexsummary.IndexSummary;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileInputStreamPlus;
import org.apache.cassandra.io.util.FileOutputStreamPlus;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.concurrent.SharedCloseableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSummaryComponent {
    private static final Logger logger = LoggerFactory.getLogger(IndexSummaryComponent.class);
    public final IndexSummary indexSummary;
    public final DecoratedKey first;
    public final DecoratedKey last;

    public IndexSummaryComponent(IndexSummary indexSummary, DecoratedKey first, DecoratedKey last) {
        this.indexSummary = indexSummary;
        this.first = first;
        this.last = last;
    }

    public static Pair<DecoratedKey, DecoratedKey> loadFirstAndLastKey(File summaryFile, IPartitioner partitioner) throws IOException {
        if (!summaryFile.exists()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Index summary {} does not exist", (Object)summaryFile.absolutePath());
            }
            return null;
        }
        try (FileInputStreamPlus iStream = summaryFile.newInputStream();){
            Pair<DecoratedKey, DecoratedKey> pair = new IndexSummary.IndexSummarySerializer().deserializeFirstLastKey(iStream, partitioner);
            return pair;
        }
    }

    public static IndexSummaryComponent load(File summaryFile, TableMetadata metadata) throws IOException {
        IndexSummaryComponent indexSummaryComponent;
        block11: {
            if (!summaryFile.exists()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Index summary {} does not exist", (Object)summaryFile.absolutePath());
                }
                return null;
            }
            SharedCloseableImpl summary = null;
            FileInputStreamPlus iStream = summaryFile.newInputStream();
            try {
                summary = IndexSummary.serializer.deserialize(iStream, metadata.partitioner, metadata.params.minIndexInterval, metadata.params.maxIndexInterval);
                DecoratedKey first = metadata.partitioner.decorateKey(ByteBufferUtil.readWithLength(iStream));
                DecoratedKey last = metadata.partitioner.decorateKey(ByteBufferUtil.readWithLength(iStream));
                indexSummaryComponent = new IndexSummaryComponent((IndexSummary)summary, first, last);
                if (iStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (iStream != null) {
                        try {
                            iStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    if (summary != null) {
                        summary.close();
                    }
                    throw new IOException(String.format("Cannot deserialize index summary from %s", summaryFile), ex);
                }
            }
            iStream.close();
        }
        return indexSummaryComponent;
    }

    public static IndexSummaryComponent loadOrDeleteCorrupted(File summaryFile, TableMetadata metadata) throws IOException {
        try {
            return IndexSummaryComponent.load(summaryFile, metadata);
        }
        catch (IOException ex) {
            summaryFile.deleteIfExists();
            throw ex;
        }
    }

    public void save(File summaryFile, boolean deleteOnFailure) throws IOException {
        if (summaryFile.exists()) {
            summaryFile.delete();
        }
        try (FileOutputStreamPlus oStream = summaryFile.newOutputStream(File.WriteMode.OVERWRITE);){
            IndexSummary.serializer.serialize(this.indexSummary, oStream);
            ByteBufferUtil.writeWithLength(this.first.getKey(), oStream);
            ByteBufferUtil.writeWithLength(this.last.getKey(), oStream);
        }
        catch (IOException ex) {
            if (deleteOnFailure) {
                summaryFile.deleteIfExists();
            }
            throw new IOException("Failed to save index summary to " + summaryFile, ex);
        }
    }
}

