/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.WriteContext;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.SingletonIndexGroup;
import org.apache.cassandra.index.transactions.IndexTransaction;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableFlushObserver;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientState;

public interface IndexRegistry {
    public static final IndexRegistry EMPTY = new IndexRegistry(){

        @Override
        public void registerIndex(Index index, Index.Group.Key groupKey, Supplier<Index.Group> groupSupplier) {
        }

        @Override
        public void unregisterIndex(Index index, Index.Group.Key groupKey) {
        }

        @Override
        public Collection<Index> listIndexes() {
            return Collections.emptyList();
        }

        @Override
        public Collection<Index.Group> listIndexGroups() {
            return Collections.emptySet();
        }

        @Override
        public Index getIndex(IndexMetadata indexMetadata) {
            return null;
        }

        @Override
        public Optional<Index> getBestIndexFor(RowFilter.Expression expression) {
            return Optional.empty();
        }

        @Override
        public void validate(PartitionUpdate update, ClientState state) {
        }
    };
    public static final IndexRegistry NON_DAEMON = new IndexRegistry(){
        final Index index = new Index(){

            @Override
            public Callable<?> getInitializationTask() {
                return null;
            }

            @Override
            public IndexMetadata getIndexMetadata() {
                return null;
            }

            @Override
            public Callable<?> getMetadataReloadTask(IndexMetadata indexMetadata) {
                return null;
            }

            @Override
            public void register(IndexRegistry registry) {
            }

            @Override
            public void unregister(IndexRegistry registry) {
            }

            @Override
            public Optional<ColumnFamilyStore> getBackingTable() {
                return Optional.empty();
            }

            @Override
            public Callable<?> getBlockingFlushTask() {
                return null;
            }

            @Override
            public Callable<?> getInvalidateTask() {
                return null;
            }

            @Override
            public Callable<?> getTruncateTask(long truncatedAt) {
                return null;
            }

            @Override
            public boolean shouldBuildBlocking() {
                return false;
            }

            @Override
            public boolean dependsOn(ColumnMetadata column) {
                return false;
            }

            @Override
            public boolean supportsExpression(ColumnMetadata column, Operator operator) {
                return true;
            }

            @Override
            public AbstractType<?> customExpressionValueType() {
                return BytesType.instance;
            }

            @Override
            public RowFilter getPostIndexQueryFilter(RowFilter filter) {
                return null;
            }

            @Override
            public long getEstimatedResultRows() {
                return 0L;
            }

            @Override
            public void validate(PartitionUpdate update, ClientState state) throws InvalidRequestException {
            }

            @Override
            public Index.Indexer indexerFor(DecoratedKey key, RegularAndStaticColumns columns, long nowInSec, WriteContext ctx, IndexTransaction.Type transactionType, Memtable memtable) {
                return null;
            }

            @Override
            public Index.Searcher searcherFor(ReadCommand command) {
                return null;
            }
        };
        final Index.Group group = new Index.Group(){

            @Override
            public Set<Index> getIndexes() {
                return Collections.singleton(index);
            }

            @Override
            public boolean containsIndex(Index i) {
                return index == i;
            }

            @Override
            @Nullable
            public Index.Indexer indexerFor(Predicate<Index> indexSelector, DecoratedKey key, RegularAndStaticColumns columns, long nowInSec, WriteContext ctx, IndexTransaction.Type transactionType, Memtable memtable) {
                return null;
            }

            @Override
            @Nullable
            public Index.QueryPlan queryPlanFor(RowFilter rowFilter) {
                return null;
            }

            @Override
            @Nullable
            public SSTableFlushObserver getFlushObserver(Descriptor descriptor, LifecycleNewTracker tracker, TableMetadata tableMetadata) {
                return null;
            }

            @Override
            public Set<Component> getComponents() {
                return null;
            }
        };

        @Override
        public void registerIndex(Index index, Index.Group.Key groupKey, Supplier<Index.Group> groupSupplier) {
        }

        @Override
        public void unregisterIndex(Index index, Index.Group.Key groupKey) {
        }

        @Override
        public Index getIndex(IndexMetadata indexMetadata) {
            return this.index;
        }

        @Override
        public Collection<Index> listIndexes() {
            return Collections.singletonList(this.index);
        }

        @Override
        public Collection<Index.Group> listIndexGroups() {
            return Collections.singletonList(this.group);
        }

        @Override
        public Optional<Index> getBestIndexFor(RowFilter.Expression expression) {
            return Optional.empty();
        }

        @Override
        public void validate(PartitionUpdate update, ClientState state) {
        }
    };

    default public void registerIndex(Index index) {
        this.registerIndex(index, new Index.Group.Key(index), () -> new SingletonIndexGroup(index));
    }

    public void registerIndex(Index var1, Index.Group.Key var2, Supplier<Index.Group> var3);

    public void unregisterIndex(Index var1, Index.Group.Key var2);

    public Collection<Index.Group> listIndexGroups();

    public Index getIndex(IndexMetadata var1);

    public Collection<Index> listIndexes();

    public Optional<Index> getBestIndexFor(RowFilter.Expression var1);

    public void validate(PartitionUpdate var1, ClientState var2);

    public static IndexRegistry obtain(TableMetadata table) {
        if (!DatabaseDescriptor.isDaemonInitialized()) {
            return NON_DAEMON;
        }
        return table.isVirtual() ? EMPTY : Keyspace.openAndGetStore((TableMetadata)table).indexManager;
    }
}

