/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.tries;

import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.apache.cassandra.db.tries.Trie;

class TrieDumper<T>
implements Trie.Walker<T, String> {
    private final StringBuilder b;
    private final Function<T, String> contentToString;
    int needsIndent = -1;
    int currentLength = 0;

    public TrieDumper(Function<T, String> contentToString) {
        this.contentToString = contentToString;
        this.b = new StringBuilder();
    }

    private void endLineAndSetIndent(int newIndent) {
        this.needsIndent = newIndent;
    }

    @Override
    public void resetPathLength(int newLength) {
        this.currentLength = newLength;
        this.endLineAndSetIndent(newLength);
    }

    private void maybeIndent() {
        if (this.needsIndent >= 0) {
            this.b.append('\n');
            for (int i = 0; i < this.needsIndent; ++i) {
                this.b.append("  ");
            }
            this.needsIndent = -1;
        }
    }

    @Override
    public void addPathByte(int nextByte) {
        this.maybeIndent();
        ++this.currentLength;
        this.b.append(String.format("%02x", nextByte));
    }

    @Override
    public void addPathBytes(DirectBuffer buffer, int pos, int count) {
        this.maybeIndent();
        for (int i = 0; i < count; ++i) {
            this.b.append(String.format("%02x", buffer.getByte(pos + i) & 0xFF));
        }
        this.currentLength += count;
    }

    @Override
    public void content(T content) {
        this.b.append(" -> ");
        this.b.append(this.contentToString.apply(content));
        this.endLineAndSetIndent(this.currentLength);
    }

    @Override
    public String complete() {
        return this.b.toString();
    }
}

