/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.tries;

import org.apache.cassandra.db.tries.Trie;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;

class SingletonTrie<T>
extends Trie<T> {
    private final ByteComparable key;
    private final T value;

    SingletonTrie(ByteComparable key, T value) {
        this.key = key;
        this.value = value;
    }

    public Cursor cursor() {
        return new Cursor();
    }

    class Cursor
    implements Trie.Cursor<T> {
        private final ByteSource src;
        private int currentDepth;
        private int currentTransition;
        private int nextTransition;

        Cursor() {
            this.src = SingletonTrie.this.key.asComparableBytes(Trie.BYTE_COMPARABLE_VERSION);
            this.currentDepth = 0;
            this.currentTransition = -1;
            this.nextTransition = this.src.next();
        }

        @Override
        public int advance() {
            this.currentTransition = this.nextTransition;
            if (this.currentTransition != -1) {
                this.nextTransition = this.src.next();
                return ++this.currentDepth;
            }
            this.currentDepth = -1;
            return -1;
        }

        @Override
        public int advanceMultiple(Trie.TransitionsReceiver receiver) {
            if (this.nextTransition == -1) {
                this.currentDepth = -1;
                return -1;
            }
            int current = this.nextTransition;
            int depth = this.currentDepth;
            int next = this.src.next();
            while (next != -1) {
                if (receiver != null) {
                    receiver.addPathByte(current);
                }
                current = next;
                next = this.src.next();
                ++depth;
            }
            this.currentTransition = current;
            this.nextTransition = next;
            this.currentDepth = ++depth;
            return this.currentDepth;
        }

        @Override
        public int skipChildren() {
            this.currentDepth = -1;
            return -1;
        }

        @Override
        public int depth() {
            return this.currentDepth;
        }

        @Override
        public T content() {
            return this.nextTransition == -1 ? (Object)SingletonTrie.this.value : null;
        }

        @Override
        public int incomingTransition() {
            return this.currentTransition;
        }
    }
}

