/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.partitions.AtomicBTreePartition;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.btree.BTree;

public final class BTreePartitionData {
    public static final BTreePartitionData EMPTY = new BTreePartitionData(RegularAndStaticColumns.NONE, BTree.empty(), DeletionInfo.LIVE, Rows.EMPTY_STATIC_ROW, EncodingStats.NO_STATS);
    public static final long UNSHARED_HEAP_SIZE = ObjectSizes.measure(EMPTY);
    final RegularAndStaticColumns columns;
    final DeletionInfo deletionInfo;
    final Object[] tree;
    final Row staticRow;
    public final EncodingStats stats;

    BTreePartitionData(RegularAndStaticColumns columns, Object[] tree, DeletionInfo deletionInfo, Row staticRow, EncodingStats stats) {
        this.columns = columns;
        this.tree = tree;
        this.deletionInfo = deletionInfo;
        this.staticRow = staticRow == null ? Rows.EMPTY_STATIC_ROW : staticRow;
        this.stats = stats;
    }

    BTreePartitionData withColumns(RegularAndStaticColumns columns) {
        return new BTreePartitionData(columns, this.tree, this.deletionInfo, this.staticRow, this.stats);
    }

    @VisibleForTesting
    public static BTreePartitionData unsafeGetEmpty() {
        return EMPTY;
    }

    @VisibleForTesting
    public static BTreePartitionData unsafeConstruct(RegularAndStaticColumns columns, Object[] tree, DeletionInfo deletionInfo, Row staticRow, EncodingStats stats) {
        return new BTreePartitionData(columns, tree, deletionInfo, staticRow, stats);
    }

    @VisibleForTesting
    public static void unsafeInvalidate(AtomicBTreePartition partition) {
        BTreePartitionData holder = partition.unsafeGetHolder();
        if (!BTree.isEmpty(holder.tree)) {
            partition.unsafeSetHolder(BTreePartitionData.unsafeConstruct(holder.columns, Arrays.copyOf(holder.tree, holder.tree.length), holder.deletionInfo, holder.staticRow, holder.stats));
        }
    }
}

