/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Duration;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.TemporalType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.SimpleDateSerializer;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.cassandra.utils.bytecomparable.ByteSourceInverse;

public class SimpleDateType
extends TemporalType<Integer> {
    public static final SimpleDateType instance = new SimpleDateType();
    private static final ByteBuffer MASKED_VALUE = instance.decompose(SimpleDateSerializer.timeInMillisToDay(0L));

    SimpleDateType() {
        super(AbstractType.ComparisonType.BYTE_ORDER);
    }

    @Override
    public <V> ByteSource asComparableBytes(ValueAccessor<V> accessor, V data, ByteComparable.Version version) {
        return ByteSource.optionalFixedLength(accessor, data);
    }

    @Override
    public <V> V fromComparableBytes(ValueAccessor<V> accessor, ByteSource.Peekable comparableBytes, ByteComparable.Version version) {
        return ByteSourceInverse.getOptionalFixedLength(accessor, comparableBytes, 4);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        return ByteBufferUtil.bytes(SimpleDateSerializer.dateStringToDays(source));
    }

    @Override
    public ByteBuffer fromTimeInMillis(long millis) throws MarshalException {
        return ByteBufferUtil.bytes(SimpleDateSerializer.timeInMillisToDay(millis));
    }

    @Override
    public long toTimeInMillis(ByteBuffer buffer) throws MarshalException {
        return SimpleDateSerializer.dayToTimeInMillis(ByteBufferUtil.toInt(buffer));
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        return this == otherType || otherType == Int32Type.instance;
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            return new Constants.Value(this.fromString((String)parsed));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected a string representation of a date value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        return "\"" + SimpleDateSerializer.instance.toString((Integer)SimpleDateSerializer.instance.deserialize(buffer)) + "\"";
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.DATE;
    }

    @Override
    public TypeSerializer<Integer> getSerializer() {
        return SimpleDateSerializer.instance;
    }

    @Override
    protected void validateDuration(Duration duration) {
        if (!duration.hasDayPrecision()) {
            throw RequestValidations.invalidRequest("The duration must have a day precision. Was: %s", duration);
        }
    }

    @Override
    public ByteBuffer getMaskedValue() {
        return MASKED_VALUE;
    }
}

