/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions.masking;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.functions.Arguments;
import org.apache.cassandra.cql3.functions.FunctionArguments;
import org.apache.cassandra.cql3.functions.FunctionFactory;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.FunctionParameter;
import org.apache.cassandra.cql3.functions.NativeFunction;
import org.apache.cassandra.cql3.functions.masking.MaskingFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.transport.ProtocolVersion;

public class ReplaceMaskingFunction
extends MaskingFunction {
    public static final String NAME = "replace";

    private ReplaceMaskingFunction(FunctionName name, AbstractType<?> replacedType, AbstractType<?> replacementType) {
        super(name, replacementType, replacedType, replacementType);
    }

    @Override
    public Arguments newArguments(ProtocolVersion version) {
        return FunctionArguments.newNoopInstance(version, 2);
    }

    @Override
    public ByteBuffer execute(Arguments arguments) throws InvalidRequestException {
        return (ByteBuffer)arguments.get(1);
    }

    public static FunctionFactory factory() {
        return new MaskingFunction.Factory(NAME, new FunctionParameter[]{FunctionParameter.anyType(true), FunctionParameter.sameAs(0, true, FunctionParameter.anyType(true))}){

            @Override
            protected NativeFunction doGetOrCreateFunction(List<AbstractType<?>> argTypes, AbstractType<?> receiverType) {
                AbstractType<?> replacedType = argTypes.get(0);
                AbstractType<?> replacementType = argTypes.get(1);
                assert (replacedType == replacementType) : String.format("Both arguments should have the same type, but found %s(%s, %s)", this.name, replacedType.asCQL3Type(), replacementType.asCQL3Type());
                return new ReplaceMaskingFunction(this.name, replacedType, replacementType);
            }
        };
    }
}

