/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Set;
import org.apache.cassandra.auth.CIDRGroupsMappingManager;
import org.apache.cassandra.auth.CIDRGroupsMappingTable;
import org.apache.cassandra.cql3.CIDR;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CIDRGroupsMappingLoader {
    private static final Logger logger = LoggerFactory.getLogger(CIDRGroupsMappingLoader.class);
    CIDRGroupsMappingTable.Builder<String> ipv4CidrGroupsTableBuilder = CIDRGroupsMappingTable.builder(false);
    CIDRGroupsMappingTable.Builder<String> ipv6CidrGroupsTableBuilder = CIDRGroupsMappingTable.builder(true);
    private CIDRGroupsMappingTable<String> ipv4CidrGroupsTable = null;
    private CIDRGroupsMappingTable<String> ipv6CidrGroupsTable = null;
    protected CIDRGroupsMappingManager cidrGroupsMappingManager;

    public CIDRGroupsMappingLoader(CIDRGroupsMappingManager cidrGroupsMappingManager) {
        this.cidrGroupsMappingManager = cidrGroupsMappingManager;
        this.populateCidrGroupsMapping();
    }

    private void populateCidrGroupsMapping() {
        UntypedResultSet rows = this.cidrGroupsMappingManager.getCidrGroupsTableEntries();
        for (UntypedResultSet.Row row : rows) {
            String cidrGroupName = row.getString("cidr_group");
            Set<Pair<InetAddress, Short>> cidrs = this.cidrGroupsMappingManager.retrieveCidrsFromRow(row);
            for (Pair<InetAddress, Short> cidr : cidrs) {
                try {
                    CIDR validCidr = new CIDR(cidr.left(), (Short)cidr.right);
                    if (validCidr.isIPv6()) {
                        this.ipv6CidrGroupsTableBuilder.add(validCidr, cidrGroupName);
                        continue;
                    }
                    this.ipv4CidrGroupsTableBuilder.add(validCidr, cidrGroupName);
                }
                catch (RuntimeException e) {
                    logger.error("Invalid CIDR {} found in the table, ignoring this entry", cidr);
                }
            }
        }
        this.ipv4CidrGroupsTable = this.ipv4CidrGroupsTableBuilder.build();
        this.ipv6CidrGroupsTable = this.ipv6CidrGroupsTableBuilder.build();
    }

    public Set<String> lookupCidrGroupsCacheForIp(InetAddress ipAddr) {
        if (ipAddr instanceof Inet6Address) {
            return this.ipv6CidrGroupsTable.lookupLongestMatchForIP(ipAddr);
        }
        return this.ipv4CidrGroupsTable.lookupLongestMatchForIP(ipAddr);
    }
}

