/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.asymmetric;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;

public class RangeMap<T>
implements Map<Range<Token>, T> {
    private static final Comparator<Range<Token>> comparator = Comparator.comparing(o -> (Token)o.left);
    private final NavigableMap<Range<Token>, T> byStart = new TreeMap<Range<Token>, T>(comparator);

    @Override
    public int size() {
        return this.byStart.size();
    }

    @Override
    public boolean isEmpty() {
        return this.byStart.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.byStart.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.byStart.containsValue(value);
    }

    @Override
    public T get(Object key) {
        return (T)this.byStart.get(key);
    }

    @Override
    public T put(Range<Token> key, T value) {
        this.assertNonIntersecting(key);
        return this.byStart.put(key, value);
    }

    private void assertNonIntersecting(Range<Token> range) {
        Range<Token> before = this.byStart.floorKey(range);
        Range<Token> after = this.byStart.ceilingKey(range);
        assert (before == null || !before.intersects(range));
        assert (after == null || !after.intersects(range));
    }

    @Override
    public T remove(Object key) {
        return (T)this.byStart.remove(key);
    }

    @Override
    public void putAll(Map<? extends Range<Token>, ? extends T> m) {
        this.byStart.putAll(m);
    }

    @Override
    public void clear() {
        this.byStart.clear();
    }

    @Override
    public Set<Range<Token>> keySet() {
        return this.byStart.keySet();
    }

    @Override
    public Collection<T> values() {
        return this.byStart.values();
    }

    @Override
    public Set<Map.Entry<Range<Token>, T>> entrySet() {
        return this.byStart.entrySet();
    }

    @VisibleForTesting
    Iterator<Map.Entry<Range<Token>, T>> intersectingEntryIterator(Range<Token> range) {
        return range.isWrapAround() ? new WrappingIntersectingIterator(range) : new IntersectingIterator(range);
    }

    public Set<Map.Entry<Range<Token>, T>> removeIntersecting(Range<Token> range) {
        Iterator<Map.Entry<Range<Token>, T>> iter = this.intersectingEntryIterator(range);
        HashSet<Map.Entry<Range<Token>, T>> intersecting = new HashSet<Map.Entry<Range<Token>, T>>();
        while (iter.hasNext()) {
            Map.Entry<Range<Token>, T> entry = iter.next();
            intersecting.add(entry);
        }
        for (Map.Entry entry : intersecting) {
            this.byStart.remove(entry.getKey());
        }
        return intersecting;
    }

    public String toString() {
        return this.byStart.toString();
    }

    static class Entry<K, V>
    implements Map.Entry<K, V> {
        private final V v;
        private final K k;

        Entry(K key, V val) {
            this.k = key;
            this.v = val;
        }

        Entry(Map.Entry<K, V> toClone) {
            this(toClone.getKey(), toClone.getValue());
        }

        @Override
        public K getKey() {
            return this.k;
        }

        @Override
        public V getValue() {
            return this.v;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return this.v.equals(entry.getValue()) && this.k.equals(entry.getKey());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.v, this.k);
        }

        public String toString() {
            return "Entry{v=" + this.v + ", k=" + this.k + "}";
        }
    }

    private class IntersectingIterator
    extends AbstractIterator<Map.Entry<Range<Token>, T>> {
        private final Iterator<Map.Entry<Range<Token>, T>> tailIterator;
        private final Range<Token> range;
        private boolean shouldReturnLast = false;

        public IntersectingIterator(Range<Token> range) {
            Range last;
            Range<Token> startKey = RangeMap.this.byStart.floorKey(range);
            this.tailIterator = startKey == null ? RangeMap.this.byStart.entrySet().iterator() : RangeMap.this.byStart.tailMap(startKey, true).entrySet().iterator();
            Range range2 = last = RangeMap.this.byStart.isEmpty() ? null : (Range)RangeMap.this.byStart.lastKey();
            if (last != null && last.isWrapAround() && last.intersects(range)) {
                this.shouldReturnLast = true;
            }
            this.range = range;
        }

        protected Map.Entry<Range<Token>, T> computeNext() {
            if (this.shouldReturnLast) {
                this.shouldReturnLast = false;
                return new Entry(RangeMap.this.byStart.lastEntry());
            }
            while (this.tailIterator.hasNext()) {
                Entry candidateNext = new Entry(this.tailIterator.next());
                Range<Token> candidateRange = candidateNext.getKey();
                if (candidateRange.isWrapAround()) continue;
                if (((Token)candidateRange.left).compareTo((Token)this.range.right) >= 0 && !this.range.isWrapAround()) {
                    return (Map.Entry)this.endOfData();
                }
                if (((Token)this.range.left).compareTo((Token)candidateRange.right) >= 0) continue;
                return candidateNext;
            }
            return (Map.Entry)this.endOfData();
        }
    }

    private class WrappingIntersectingIterator
    extends AbstractIterator<Map.Entry<Range<Token>, T>> {
        private final Iterator<Iterator<Map.Entry<Range<Token>, T>>> iterators;
        private Iterator<Map.Entry<Range<Token>, T>> currentIter;

        public WrappingIntersectingIterator(Range<Token> range) {
            ArrayList<IntersectingIterator> iters = new ArrayList<IntersectingIterator>(2);
            for (Range<Token> unwrapped : range.unwrap()) {
                iters.add(new IntersectingIterator(unwrapped));
            }
            this.iterators = iters.iterator();
        }

        protected Map.Entry<Range<Token>, T> computeNext() {
            while (this.currentIter == null || !this.currentIter.hasNext()) {
                if (!this.iterators.hasNext()) {
                    return (Map.Entry)this.endOfData();
                }
                this.currentIter = this.iterators.next();
            }
            return this.currentIter.next();
        }
    }
}

