/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReadsListener;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableScanner;
import org.apache.cassandra.io.sstable.format.big.BigTableReader;
import org.apache.cassandra.io.sstable.format.big.RowIndexEntry;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ByteBufferUtil;

public class BigTableScanner
extends SSTableScanner<BigTableReader, RowIndexEntry, BigScanningIterator> {
    protected final RandomAccessReader ifile;
    private AbstractBounds<PartitionPosition> currentRange;
    private final RowIndexEntry.IndexSerializer rowIndexEntrySerializer;

    public static ISSTableScanner getScanner(BigTableReader sstable) {
        return BigTableScanner.getScanner(sstable, (Iterator<AbstractBounds<PartitionPosition>>)Iterators.singletonIterator(BigTableScanner.fullRange(sstable)));
    }

    public static ISSTableScanner getScanner(BigTableReader sstable, ColumnFilter columns, DataRange dataRange, SSTableReadsListener listener) {
        return new BigTableScanner(sstable, columns, dataRange, BigTableScanner.makeBounds((SSTableReader)sstable, dataRange).iterator(), listener);
    }

    public static ISSTableScanner getScanner(BigTableReader sstable, Collection<Range<Token>> tokenRanges) {
        return BigTableScanner.getScanner(sstable, BigTableScanner.makeBounds((SSTableReader)sstable, tokenRanges).iterator());
    }

    public static ISSTableScanner getScanner(BigTableReader sstable, Iterator<AbstractBounds<PartitionPosition>> rangeIterator) {
        return new BigTableScanner(sstable, ColumnFilter.all(sstable.metadata()), null, rangeIterator, SSTableReadsListener.NOOP_LISTENER);
    }

    private BigTableScanner(BigTableReader sstable, ColumnFilter columns, DataRange dataRange, Iterator<AbstractBounds<PartitionPosition>> rangeIterator, SSTableReadsListener listener) {
        super(sstable, columns, dataRange, rangeIterator, listener);
        this.ifile = sstable.openIndexReader();
        this.rowIndexEntrySerializer = new RowIndexEntry.Serializer(sstable.descriptor.version, sstable.header, sstable.owner().map(SSTable.Owner::getMetrics).orElse(null));
    }

    private void seekToCurrentRangeStart() {
        long indexPosition = ((BigTableReader)this.sstable).getIndexScanPosition((PartitionPosition)this.currentRange.left);
        this.ifile.seek(indexPosition);
        try {
            while (!this.ifile.isEOF()) {
                indexPosition = this.ifile.getFilePointer();
                DecoratedKey indexDecoratedKey = ((BigTableReader)this.sstable).decorateKey(ByteBufferUtil.readWithShortLength(this.ifile));
                if (indexDecoratedKey.compareTo((PartitionPosition)this.currentRange.left) > 0 || this.currentRange.contains(indexDecoratedKey)) {
                    long dataPosition = RowIndexEntry.Serializer.readPosition(this.ifile);
                    this.ifile.seek(indexPosition);
                    this.dfile.seek(dataPosition);
                    break;
                }
                RowIndexEntry.Serializer.skip(this.ifile, ((BigTableReader)this.sstable).descriptor.version);
            }
        }
        catch (IOException e) {
            ((BigTableReader)this.sstable).markSuspect();
            throw new CorruptSSTableException((Throwable)e, ((BigTableReader)this.sstable).getFilename());
        }
    }

    @Override
    protected void doClose() throws IOException {
        FileUtils.close(this.dfile, this.ifile);
    }

    @Override
    protected BigScanningIterator doCreateIterator() {
        return new BigScanningIterator();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(dfile=" + this.dfile + " ifile=" + this.ifile + " sstable=" + this.sstable + ")";
    }

    protected class BigScanningIterator
    extends SSTableScanner.BaseKeyScanningIterator {
        private DecoratedKey nextKey;
        private RowIndexEntry nextEntry;

        protected BigScanningIterator() {
        }

        @Override
        protected boolean prepareToIterateRow() throws IOException {
            if (this.nextEntry == null) {
                do {
                    if (BigTableScanner.this.startScan != -1L) {
                        BigTableScanner.this.bytesScanned += BigTableScanner.this.dfile.getFilePointer() - BigTableScanner.this.startScan;
                    }
                    if (!BigTableScanner.this.rangeIterator.hasNext()) {
                        return false;
                    }
                    BigTableScanner.this.currentRange = (AbstractBounds)BigTableScanner.this.rangeIterator.next();
                    BigTableScanner.this.seekToCurrentRangeStart();
                    BigTableScanner.this.startScan = BigTableScanner.this.dfile.getFilePointer();
                    if (BigTableScanner.this.ifile.isEOF()) {
                        return false;
                    }
                    this.currentKey = ((BigTableReader)BigTableScanner.this.sstable).decorateKey(ByteBufferUtil.readWithShortLength(BigTableScanner.this.ifile));
                    this.currentEntry = BigTableScanner.this.rowIndexEntrySerializer.deserialize(BigTableScanner.this.ifile);
                } while (!BigTableScanner.this.currentRange.contains(this.currentKey));
            } else {
                this.currentKey = this.nextKey;
                this.currentEntry = this.nextEntry;
            }
            if (BigTableScanner.this.ifile.isEOF()) {
                this.nextEntry = null;
                this.nextKey = null;
            } else {
                this.nextKey = ((BigTableReader)BigTableScanner.this.sstable).decorateKey(ByteBufferUtil.readWithShortLength(BigTableScanner.this.ifile));
                this.nextEntry = BigTableScanner.this.rowIndexEntrySerializer.deserialize(BigTableScanner.this.ifile);
                if (!BigTableScanner.this.currentRange.contains(this.nextKey)) {
                    this.nextKey = null;
                    this.nextEntry = null;
                }
            }
            return true;
        }

        protected UnfilteredRowIterator getRowIterator(RowIndexEntry rowIndexEntry, DecoratedKey key) throws IOException {
            if (BigTableScanner.this.dataRange == null) {
                BigTableScanner.this.dfile.seek(rowIndexEntry.position);
                BigTableScanner.this.startScan = BigTableScanner.this.dfile.getFilePointer();
                ByteBufferUtil.skipShortLength(BigTableScanner.this.dfile);
                return SSTableIdentityIterator.create(BigTableScanner.this.sstable, BigTableScanner.this.dfile, key);
            }
            BigTableScanner.this.startScan = BigTableScanner.this.dfile.getFilePointer();
            ClusteringIndexFilter filter = BigTableScanner.this.dataRange.clusteringIndexFilter(key);
            return ((BigTableReader)BigTableScanner.this.sstable).rowIterator(BigTableScanner.this.dfile, key, rowIndexEntry, filter.getSlices(BigTableScanner.this.metadata()), BigTableScanner.this.columns, filter.isReversed());
        }
    }
}

