/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.Closeable;
import java.util.Collection;
import java.util.function.Function;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.service.StorageService;

public interface IVerifier
extends Closeable {
    public static Options.Builder options() {
        return new Options.Builder();
    }

    public void verify();

    @Override
    public void close();

    public CompactionInfo.Holder getVerifyInfo();

    public static class Options {
        public final boolean invokeDiskFailurePolicy;
        public final boolean extendedVerification;
        public final boolean checkVersion;
        public final boolean mutateRepairStatus;
        public final boolean checkOwnsTokens;
        public final boolean quick;
        public final Function<String, ? extends Collection<Range<Token>>> tokenLookup;

        private Options(boolean invokeDiskFailurePolicy, boolean extendedVerification, boolean checkVersion, boolean mutateRepairStatus, boolean checkOwnsTokens, boolean quick, Function<String, ? extends Collection<Range<Token>>> tokenLookup) {
            this.invokeDiskFailurePolicy = invokeDiskFailurePolicy;
            this.extendedVerification = extendedVerification;
            this.checkVersion = checkVersion;
            this.mutateRepairStatus = mutateRepairStatus;
            this.checkOwnsTokens = checkOwnsTokens;
            this.quick = quick;
            this.tokenLookup = tokenLookup;
        }

        public String toString() {
            return "Options{invokeDiskFailurePolicy=" + this.invokeDiskFailurePolicy + ", extendedVerification=" + this.extendedVerification + ", checkVersion=" + this.checkVersion + ", mutateRepairStatus=" + this.mutateRepairStatus + ", checkOwnsTokens=" + this.checkOwnsTokens + ", quick=" + this.quick + "}";
        }

        public static class Builder {
            private boolean invokeDiskFailurePolicy = false;
            private boolean extendedVerification = false;
            private boolean checkVersion = false;
            private boolean mutateRepairStatus = false;
            private boolean checkOwnsTokens = false;
            private boolean quick = false;
            private Function<String, ? extends Collection<Range<Token>>> tokenLookup = StorageService.instance::getLocalAndPendingRanges;

            public Builder invokeDiskFailurePolicy(boolean param) {
                this.invokeDiskFailurePolicy = param;
                return this;
            }

            public Builder extendedVerification(boolean param) {
                this.extendedVerification = param;
                return this;
            }

            public Builder checkVersion(boolean param) {
                this.checkVersion = param;
                return this;
            }

            public Builder mutateRepairStatus(boolean param) {
                this.mutateRepairStatus = param;
                return this;
            }

            public Builder checkOwnsTokens(boolean param) {
                this.checkOwnsTokens = param;
                return this;
            }

            public Builder quick(boolean param) {
                this.quick = param;
                return this;
            }

            public Builder tokenLookup(Function<String, ? extends Collection<Range<Token>>> tokenLookup) {
                this.tokenLookup = tokenLookup;
                return this;
            }

            public Options build() {
                return new Options(this.invokeDiskFailurePolicy, this.extendedVerification, this.checkVersion, this.mutateRepairStatus, this.checkOwnsTokens, this.quick, this.tokenLookup);
            }
        }
    }
}

