/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.util.DiskOptimizationStrategy;
import org.apache.cassandra.io.util.SequentialWriterOption;

public class IOOptions {
    public final DiskOptimizationStrategy diskOptimizationStrategy;
    public final Config.DiskAccessMode defaultDiskAccessMode;
    public final Config.DiskAccessMode indexDiskAccessMode;
    public final double diskOptimizationEstimatePercentile;
    public final SequentialWriterOption writerOptions;
    public final Config.FlushCompression flushCompression;

    public static IOOptions fromDatabaseDescriptor() {
        return new IOOptions(DatabaseDescriptor.getDiskOptimizationStrategy(), DatabaseDescriptor.getDiskAccessMode(), DatabaseDescriptor.getIndexAccessMode(), DatabaseDescriptor.getDiskOptimizationEstimatePercentile(), SequentialWriterOption.newBuilder().trickleFsync(DatabaseDescriptor.getTrickleFsync()).trickleFsyncByteInterval(DatabaseDescriptor.getTrickleFsyncIntervalInKiB() * 1024).build(), DatabaseDescriptor.getFlushCompression());
    }

    public IOOptions(DiskOptimizationStrategy diskOptimizationStrategy, Config.DiskAccessMode defaultDiskAccessMode, Config.DiskAccessMode indexDiskAccessMode, double diskOptimizationEstimatePercentile, SequentialWriterOption writerOptions, Config.FlushCompression flushCompression) {
        this.diskOptimizationStrategy = diskOptimizationStrategy;
        this.defaultDiskAccessMode = defaultDiskAccessMode;
        this.indexDiskAccessMode = indexDiskAccessMode;
        this.diskOptimizationEstimatePercentile = diskOptimizationEstimatePercentile;
        this.writerOptions = writerOptions;
        this.flushCompression = flushCompression;
    }
}

