/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos.cleanup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.RequestCallback;
import org.apache.cassandra.net.RequestCallbackWithFailure;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.service.PendingRangeCalculatorService;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.Paxos;
import org.apache.cassandra.service.paxos.PaxosRepairHistory;
import org.apache.cassandra.service.paxos.PaxosState;
import org.apache.cassandra.service.paxos.cleanup.PaxosCleanupException;
import org.apache.cassandra.service.paxos.cleanup.PaxosCleanupHistory;
import org.apache.cassandra.utils.concurrent.AsyncFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxosStartPrepareCleanup
extends AsyncFuture<PaxosCleanupHistory>
implements RequestCallbackWithFailure<PaxosCleanupHistory> {
    private static final Logger logger = LoggerFactory.getLogger(PaxosStartPrepareCleanup.class);
    public static final RequestSerializer serializer = new RequestSerializer();
    private final TableId table;
    private final Set<InetAddressAndPort> waitingResponse;
    private Ballot maxBallot = null;
    private PaxosRepairHistory history = null;
    public static final IVerbHandler<Request> verbHandler = in -> {
        ColumnFamilyStore table = Schema.instance.getColumnFamilyStoreInstance(((Request)in.payload).tableId);
        PaxosStartPrepareCleanup.maybeUpdateTopology(in.from(), ((Request)in.payload).epState);
        Ballot highBound = Paxos.newBallot(PaxosState.ballotTracker().getHighBound(), ConsistencyLevel.SERIAL);
        PaxosRepairHistory history = table.getPaxosRepairHistoryForRanges(((Request)in.payload).ranges);
        Message<PaxosCleanupHistory> out = in.responseWith(new PaxosCleanupHistory(table.metadata.id, highBound, history));
        MessagingService.instance().send(out, in.respondTo());
    };

    PaxosStartPrepareCleanup(TableId table, Collection<InetAddressAndPort> endpoints) {
        this.table = table;
        this.waitingResponse = new HashSet<InetAddressAndPort>(endpoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PaxosStartPrepareCleanup prepare(TableId tableId, Collection<InetAddressAndPort> endpoints, EndpointState localEpState, Collection<Range<Token>> ranges) {
        PaxosStartPrepareCleanup callback;
        PaxosStartPrepareCleanup paxosStartPrepareCleanup = callback = new PaxosStartPrepareCleanup(tableId, endpoints);
        synchronized (paxosStartPrepareCleanup) {
            Message<Request> message = Message.out(Verb.PAXOS2_CLEANUP_START_PREPARE_REQ, new Request(tableId, localEpState, ranges));
            for (InetAddressAndPort endpoint : endpoints) {
                MessagingService.instance().sendWithCallback(message, endpoint, (RequestCallback)callback);
            }
        }
        return callback;
    }

    @Override
    public void onFailure(InetAddressAndPort from, RequestFailureReason reason) {
        this.tryFailure(new PaxosCleanupException("Received " + reason + " failure response from " + from));
    }

    @Override
    public synchronized void onResponse(Message<PaxosCleanupHistory> msg) {
        if (this.isDone()) {
            return;
        }
        if (!this.waitingResponse.remove(msg.from())) {
            throw new IllegalArgumentException("Received unexpected response from " + msg.from());
        }
        if (Commit.isAfter(((PaxosCleanupHistory)msg.payload).highBound, this.maxBallot)) {
            this.maxBallot = ((PaxosCleanupHistory)msg.payload).highBound;
        }
        this.history = PaxosRepairHistory.merge(this.history, ((PaxosCleanupHistory)msg.payload).history);
        if (this.waitingResponse.isEmpty()) {
            this.trySuccess(new PaxosCleanupHistory(this.table, this.maxBallot, this.history));
        }
    }

    private static void maybeUpdateTopology(InetAddressAndPort endpoint, EndpointState remote) {
        EndpointState local = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (local == null || local.isSupersededBy(remote)) {
            logger.trace("updating endpoint info for {} with {}", (Object)endpoint, (Object)remote);
            Map<InetAddressAndPort, EndpointState> states = Collections.singletonMap(endpoint, remote);
            Gossiper.runInGossipStageBlocking(() -> {
                Gossiper.instance.notifyFailureDetector(states);
                Gossiper.instance.applyStateLocally(states);
            });
        }
        PendingRangeCalculatorService.instance.blockUntilFinished();
    }

    public static class RequestSerializer
    implements IVersionedSerializer<Request> {
        @Override
        public void serialize(Request request, DataOutputPlus out, int version) throws IOException {
            request.tableId.serialize(out);
            EndpointState.serializer.serialize(request.epState, out, version);
            out.writeInt(request.ranges.size());
            for (Range<Token> rt : request.ranges) {
                AbstractBounds.tokenSerializer.serialize(rt, out, version);
            }
        }

        @Override
        public Request deserialize(DataInputPlus in, int version) throws IOException {
            TableId tableId = TableId.deserialize(in);
            EndpointState epState = (EndpointState)EndpointState.serializer.deserialize(in, version);
            int numRanges = in.readInt();
            ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>();
            for (int i = 0; i < numRanges; ++i) {
                Range range = (Range)AbstractBounds.tokenSerializer.deserialize(in, DatabaseDescriptor.getPartitioner(), version);
                ranges.add(range);
            }
            return new Request(tableId, epState, ranges);
        }

        @Override
        public long serializedSize(Request request, int version) {
            long size = request.tableId.serializedSize();
            size += EndpointState.serializer.serializedSize(request.epState, version);
            size += (long)TypeSizes.sizeof(request.ranges.size());
            for (Range<Token> range : request.ranges) {
                size += AbstractBounds.tokenSerializer.serializedSize(range, version);
            }
            return size;
        }
    }

    public static class Request {
        final TableId tableId;
        final EndpointState epState;
        final Collection<Range<Token>> ranges;

        public Request(TableId tableId, EndpointState epState, Collection<Range<Token>> ranges) {
            this.tableId = tableId;
            this.epState = epState;
            this.ranges = ranges;
        }
    }
}

