/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos.cleanup;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.NoPayload;
import org.apache.cassandra.net.RequestCallback;
import org.apache.cassandra.net.RequestCallbackWithFailure;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.service.paxos.PaxosState;
import org.apache.cassandra.service.paxos.cleanup.PaxosCleanupException;
import org.apache.cassandra.service.paxos.cleanup.PaxosCleanupHistory;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.concurrent.AsyncFuture;
import org.apache.cassandra.utils.concurrent.IntrusiveStack;

public class PaxosFinishPrepareCleanup
extends AsyncFuture<Void>
implements RequestCallbackWithFailure<Void> {
    private final Set<InetAddressAndPort> waitingResponse;
    public static final IVerbHandler<PaxosCleanupHistory> verbHandler = PendingCleanup::add;

    PaxosFinishPrepareCleanup(Collection<InetAddressAndPort> endpoints) {
        this.waitingResponse = new HashSet<InetAddressAndPort>(endpoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PaxosFinishPrepareCleanup finish(Collection<InetAddressAndPort> endpoints, PaxosCleanupHistory result) {
        PaxosFinishPrepareCleanup callback;
        PaxosFinishPrepareCleanup paxosFinishPrepareCleanup = callback = new PaxosFinishPrepareCleanup(endpoints);
        synchronized (paxosFinishPrepareCleanup) {
            Message<PaxosCleanupHistory> message = Message.out(Verb.PAXOS2_CLEANUP_FINISH_PREPARE_REQ, result);
            for (InetAddressAndPort endpoint : endpoints) {
                MessagingService.instance().sendWithCallback(message, endpoint, (RequestCallback)callback);
            }
        }
        return callback;
    }

    @Override
    public void onFailure(InetAddressAndPort from, RequestFailureReason reason) {
        this.tryFailure(new PaxosCleanupException(reason + " failure response from " + from));
    }

    @Override
    public synchronized void onResponse(Message<Void> msg) {
        if (this.isDone()) {
            return;
        }
        if (!this.waitingResponse.remove(msg.from())) {
            throw new IllegalArgumentException("Received unexpected response from " + msg.from());
        }
        if (this.waitingResponse.isEmpty()) {
            this.trySuccess(null);
        }
    }

    static class PendingCleanup
    extends IntrusiveStack<PendingCleanup> {
        private static final AtomicReference<PendingCleanup> pendingCleanup = new AtomicReference();
        private static final Runnable CLEANUP = () -> {
            void var3_11;
            void var3_8;
            PendingCleanup list = pendingCleanup.getAndSet(null);
            if (list == null) {
                return;
            }
            Ballot highBound = Ballot.none();
            for (PendingCleanup pendingCleanup : IntrusiveStack.iterable(list)) {
                PaxosCleanupHistory paxosCleanupHistory = (PaxosCleanupHistory)pendingCleanup.message.payload;
                if (paxosCleanupHistory.highBound.compareTo(highBound) <= 0) continue;
                highBound = paxosCleanupHistory.highBound;
            }
            try {
                try {
                    PaxosState.ballotTracker().updateLowBound(highBound);
                }
                catch (IOException e) {
                    throw new FSWriteError(e);
                }
            }
            catch (Throwable t) {
                for (PendingCleanup pendingCleanup : IntrusiveStack.iterable(list)) {
                    MessagingService.instance().respondWithFailure(RequestFailureReason.UNKNOWN, pendingCleanup.message);
                }
                throw t;
            }
            Set failed = null;
            Object var3_7 = null;
            for (PendingCleanup pending : IntrusiveStack.iterable(list)) {
                try {
                    Schema.instance.getColumnFamilyStoreInstance(((PaxosCleanupHistory)pending.message.payload).tableId).syncPaxosRepairHistory(((PaxosCleanupHistory)pending.message.payload).history, false);
                }
                catch (Throwable t) {
                    Throwable throwable = Throwables.merge(var3_8, t);
                    if (failed == null) {
                        failed = Collections.newSetFromMap(new IdentityHashMap());
                    }
                    failed.add(pending);
                    MessagingService.instance().respondWithFailure(RequestFailureReason.UNKNOWN, pending.message);
                }
            }
            try {
                SystemKeyspace.flushPaxosRepairHistory();
                for (PendingCleanup pending : IntrusiveStack.iterable(list)) {
                    if (failed != null && failed.contains(pending)) continue;
                    MessagingService.instance().respond(NoPayload.noPayload, pending.message);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = Throwables.merge(var3_8, throwable);
                for (PendingCleanup pending : IntrusiveStack.iterable(list)) {
                    if (failed != null && failed.contains(pending)) continue;
                    MessagingService.instance().respondWithFailure(RequestFailureReason.UNKNOWN, pending.message);
                }
            }
            Throwables.maybeFail((Throwable)var3_11);
        };
        final Message<PaxosCleanupHistory> message;

        PendingCleanup(Message<PaxosCleanupHistory> message) {
            this.message = message;
        }

        public static void add(Message<PaxosCleanupHistory> message) {
            PendingCleanup next = new PendingCleanup(message);
            PendingCleanup prev = IntrusiveStack.push(AtomicReference::get, AtomicReference::compareAndSet, pendingCleanup, next);
            if (prev == null) {
                Stage.MISC.execute(CLEANUP);
            }
        }
    }
}

