/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import com.codahale.metrics.Meter;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.db.partitions.FilteredPartition;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.CasWriteTimeoutException;
import org.apache.cassandra.exceptions.ExceptionCode;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.IsBootstrappingException;
import org.apache.cassandra.exceptions.ReadFailureException;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestFailureException;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.exceptions.RequestTimeoutException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.exceptions.WriteFailureException;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.EndpointsForToken;
import org.apache.cassandra.locator.InOurDc;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaLayout;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.metrics.ClientRequestMetrics;
import org.apache.cassandra.metrics.ClientRequestsMetricsHolder;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.CASRequest;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.FailureRecordingCallback;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.service.paxos.BallotGenerator;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.ContentionStrategy;
import org.apache.cassandra.service.paxos.PaxosCommitAndPrepare;
import org.apache.cassandra.service.paxos.PaxosPrepare;
import org.apache.cassandra.service.paxos.PaxosPropose;
import org.apache.cassandra.service.paxos.cleanup.PaxosTableRepairs;
import org.apache.cassandra.service.reads.DataResolver;
import org.apache.cassandra.service.reads.repair.NoopReadRepair;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.CassandraVersion;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.CollectionSerializer;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Paxos {
    private static final Logger logger = LoggerFactory.getLogger(Paxos.class);
    private static volatile Config.PaxosVariant PAXOS_VARIANT = DatabaseDescriptor.getPaxosVariant();
    private static final CassandraVersion MODERN_PAXOS_RELEASE = new CassandraVersion(CassandraRelevantProperties.PAXOS_MODERN_RELEASE.getString());
    static final boolean LOG_TTL_LINEARIZABILITY_VIOLATIONS = CassandraRelevantProperties.PAXOS_LOG_TTL_LINEARIZABILITY_VIOLATIONS.getBoolean();

    public static RowIterator cas(DecoratedKey key, CASRequest request, ConsistencyLevel consistencyForConsensus, ConsistencyLevel consistencyForCommit, ClientState clientState) throws UnavailableException, IsBootstrappingException, RequestFailureException, RequestTimeoutException, InvalidRequestException {
        long start = Clock.Global.nanoTime();
        long proposeDeadline = start + DatabaseDescriptor.getCasContentionTimeout(TimeUnit.NANOSECONDS);
        long commitDeadline = Math.max(proposeDeadline, start + DatabaseDescriptor.getWriteRpcTimeout(TimeUnit.NANOSECONDS));
        return Paxos.cas(key, request, consistencyForConsensus, consistencyForCommit, clientState, start, proposeDeadline, commitDeadline);
    }

    public static RowIterator cas(DecoratedKey key, CASRequest request, ConsistencyLevel consistencyForConsensus, ConsistencyLevel consistencyForCommit, ClientState clientState, long proposeDeadline, long commitDeadline) throws UnavailableException, IsBootstrappingException, RequestFailureException, RequestTimeoutException, InvalidRequestException {
        return Paxos.cas(key, request, consistencyForConsensus, consistencyForCommit, clientState, Clock.Global.nanoTime(), proposeDeadline, commitDeadline);
    }

    /*
     * Exception decompiling
     */
    private static RowIterator cas(DecoratedKey partitionKey, CASRequest request, ConsistencyLevel consistencyForConsensus, ConsistencyLevel consistencyForCommit, ClientState clientState, long start, long proposeDeadline, long commitDeadline) throws UnavailableException, IsBootstrappingException, RequestFailureException, RequestTimeoutException, InvalidRequestException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[TRYBLOCK]], but top level block is 15[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static RowIterator conditionNotMet(FilteredPartition read) {
        Tracing.trace("CAS precondition rejected", (Object)read);
        ClientRequestsMetricsHolder.casWriteMetrics.conditionNotMet.inc();
        return read.rowIterator();
    }

    public static PartitionIterator read(SinglePartitionReadCommand.Group group, ConsistencyLevel consistencyForConsensus) throws InvalidRequestException, UnavailableException, ReadFailureException, ReadTimeoutException {
        long start = Clock.Global.nanoTime();
        long deadline = start + DatabaseDescriptor.getReadRpcTimeout(TimeUnit.NANOSECONDS);
        return Paxos.read(group, consistencyForConsensus, start, deadline);
    }

    public static PartitionIterator read(SinglePartitionReadCommand.Group group, ConsistencyLevel consistencyForConsensus, long deadline) throws InvalidRequestException, UnavailableException, ReadFailureException, ReadTimeoutException {
        return Paxos.read(group, consistencyForConsensus, Clock.Global.nanoTime(), deadline);
    }

    /*
     * Exception decompiling
     */
    private static PartitionIterator read(SinglePartitionReadCommand.Group group, ConsistencyLevel consistencyForConsensus, long start, long deadline) throws InvalidRequestException, UnavailableException, ReadFailureException, ReadTimeoutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 11[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static BeginResult begin(long deadline, SinglePartitionReadCommand query, ConsistencyLevel consistencyForConsensus, boolean isWrite, Ballot minimumBallot, int failedAttemptsDueToContention) throws WriteTimeoutException, WriteFailureException, ReadTimeoutException, ReadFailureException {
        boolean acceptEarlyReadPermission = !isWrite;
        Participants initialParticipants = Participants.get(query.metadata(), query.partitionKey(), consistencyForConsensus);
        initialParticipants.assureSufficientLiveNodes(isWrite);
        PaxosPrepare preparing = PaxosPrepare.prepare(minimumBallot, initialParticipants, query, isWrite, acceptEarlyReadPermission);
        while (true) {
            PaxosPrepare retry = null;
            PaxosPrepare.Status prepare = preparing.awaitUntil(deadline);
            boolean isPromised = false;
            block0 : switch (prepare.outcome) {
                default: {
                    throw new IllegalStateException();
                }
                case FOUND_INCOMPLETE_COMMITTED: {
                    PaxosPrepare.FoundIncompleteCommitted incomplete = prepare.incompleteCommitted();
                    Tracing.trace("Repairing replicas that missed the most recent commit");
                    retry = PaxosCommitAndPrepare.commitAndPrepare(incomplete.committed, incomplete.participants, query, isWrite, acceptEarlyReadPermission);
                    break;
                }
                case FOUND_INCOMPLETE_ACCEPTED: {
                    PaxosPrepare.FoundIncompleteAccepted inProgress = prepare.incompleteAccepted();
                    Tracing.trace("Finishing incomplete paxos round {}", (Object)inProgress.accepted);
                    if (isWrite) {
                        ClientRequestsMetricsHolder.casWriteMetrics.unfinishedCommit.inc();
                    } else {
                        ClientRequestsMetricsHolder.casReadMetrics.unfinishedCommit.inc();
                    }
                    Commit.Proposal repropose = new Commit.Proposal(inProgress.ballot, inProgress.accepted.update);
                    PaxosPropose.Status proposeResult = PaxosPropose.propose(repropose, inProgress.participants, false).awaitUntil(deadline);
                    switch (proposeResult.outcome) {
                        default: {
                            throw new IllegalStateException();
                        }
                        case MAYBE_FAILURE: {
                            throw proposeResult.maybeFailure().markAndThrowAsTimeoutOrFailure(isWrite, consistencyForConsensus, failedAttemptsDueToContention);
                        }
                        case SUCCESS: {
                            retry = PaxosCommitAndPrepare.commitAndPrepare(repropose.agreed(), inProgress.participants, query, isWrite, acceptEarlyReadPermission);
                            break block0;
                        }
                        case SUPERSEDED: 
                    }
                    prepare = new PaxosPrepare.Superseded(proposeResult.superseded().by, inProgress.participants);
                }
                case SUPERSEDED: {
                    Tracing.trace("Some replicas have already promised a higher ballot than ours; aborting");
                    if (!ContentionStrategy.waitForContention(deadline, ++failedAttemptsDueToContention, query.metadata(), query.partitionKey(), consistencyForConsensus, isWrite ? ContentionStrategy.Type.WRITE : ContentionStrategy.Type.READ)) {
                        throw MaybeFailure.noResponses(prepare.participants).markAndThrowAsTimeoutOrFailure(true, consistencyForConsensus, failedAttemptsDueToContention);
                    }
                    retry = PaxosPrepare.prepare(prepare.retryWithAtLeast(), prepare.participants, query, isWrite, acceptEarlyReadPermission);
                    break;
                }
                case PROMISED: {
                    isPromised = true;
                }
                case READ_PERMITTED: {
                    PaxosPrepare.Success success = prepare.success();
                    DataResolver resolver = new DataResolver(query, success.participants, NoopReadRepair.instance, query.creationTimeNanos());
                    for (int i = 0; i < success.responses.size(); ++i) {
                        resolver.preprocess(success.responses.get(i));
                    }
                    class WasRun
                    implements Runnable {
                        boolean v;

                        WasRun() {
                        }

                        @Override
                        public void run() {
                            this.v = true;
                        }
                    }
                    WasRun hadShortRead = new WasRun();
                    PartitionIterator result = resolver.resolve(hadShortRead);
                    if (!isPromised && hadShortRead.v) {
                        acceptEarlyReadPermission = false;
                        break;
                    }
                    return new BeginResult(success.ballot, success.participants, failedAttemptsDueToContention, result, !hadShortRead.v && success.isReadSafe, isPromised, success.supersededBy);
                }
                case MAYBE_FAILURE: {
                    throw prepare.maybeFailure().markAndThrowAsTimeoutOrFailure(isWrite, consistencyForConsensus, failedAttemptsDueToContention);
                }
                case ELECTORATE_MISMATCH: {
                    Participants participants = Participants.get(query.metadata(), query.partitionKey(), consistencyForConsensus);
                    participants.assureSufficientLiveNodes(isWrite);
                    retry = PaxosPrepare.prepare(participants, query, isWrite, acceptEarlyReadPermission);
                }
            }
            if (retry == null) {
                Tracing.trace("Some replicas have already promised a higher ballot than ours; retrying");
                if (!ContentionStrategy.waitForContention(deadline, ++failedAttemptsDueToContention, query.metadata(), query.partitionKey(), consistencyForConsensus, isWrite ? ContentionStrategy.Type.WRITE : ContentionStrategy.Type.READ)) {
                    throw MaybeFailure.noResponses(prepare.participants).markAndThrowAsTimeoutOrFailure(true, consistencyForConsensus, failedAttemptsDueToContention);
                }
                retry = PaxosPrepare.prepare(prepare.retryWithAtLeast(), prepare.participants, query, isWrite, acceptEarlyReadPermission);
            }
            preparing = retry;
        }
    }

    public static boolean isInRangeAndShouldProcess(InetAddressAndPort from, DecoratedKey key, TableMetadata table, boolean includesRead) {
        Keyspace keyspace = Keyspace.open(table.keyspace);
        return (includesRead ? EndpointsForToken.natural(keyspace, key.getToken()) : (EndpointsForToken)ReplicaLayout.forTokenWriteLiveAndDown(keyspace, key.getToken()).all()).contains(FBUtilities.getBroadcastAddressAndPort());
    }

    static ConsistencyLevel nonSerial(ConsistencyLevel serial) {
        switch (serial) {
            default: {
                throw new IllegalStateException();
            }
            case SERIAL: {
                return ConsistencyLevel.QUORUM;
            }
            case LOCAL_SERIAL: 
        }
        return ConsistencyLevel.LOCAL_QUORUM;
    }

    private static void mark(boolean isWrite, Function<ClientRequestMetrics, Meter> toMark, ConsistencyLevel consistency) {
        if (isWrite) {
            toMark.apply(ClientRequestsMetricsHolder.casWriteMetrics).mark();
            toMark.apply(ClientRequestsMetricsHolder.writeMetricsMap.get((Object)consistency)).mark();
        } else {
            toMark.apply(ClientRequestsMetricsHolder.casReadMetrics).mark();
            toMark.apply(ClientRequestsMetricsHolder.readMetricsMap.get((Object)consistency)).mark();
        }
    }

    public static Ballot newBallot(@Nullable Ballot minimumBallot, ConsistencyLevel consistency) {
        long minTimestampMicros = minimumBallot == null ? Long.MIN_VALUE : 1L + minimumBallot.unixMicros();
        return BallotGenerator.Global.nextBallot(minTimestampMicros, Paxos.flag(consistency));
    }

    static Ballot staleBallotNewerThan(Ballot than, ConsistencyLevel consistency) {
        long minTimestampMicros = 1L + than.unixMicros();
        long maxTimestampMicros = BallotGenerator.Global.prevUnixMicros();
        if ((maxTimestampMicros -= Math.min((maxTimestampMicros - minTimestampMicros) / 2L, TimeUnit.SECONDS.toMicros(5L))) <= minTimestampMicros) {
            return BallotGenerator.Global.nextBallot(minTimestampMicros, Paxos.flag(consistency));
        }
        return BallotGenerator.Global.staleBallot(minTimestampMicros, maxTimestampMicros, Paxos.flag(consistency));
    }

    public static Ballot ballotForConsistency(long whenInMicros, ConsistencyLevel consistency) {
        Preconditions.checkArgument((boolean)consistency.isSerialConsistency());
        return BallotGenerator.Global.nextBallot(whenInMicros, Paxos.flag(consistency));
    }

    private static Ballot.Flag flag(ConsistencyLevel consistency) {
        return consistency == ConsistencyLevel.SERIAL ? Ballot.Flag.GLOBAL : Ballot.Flag.LOCAL;
    }

    public static ConsistencyLevel consistency(Ballot ballot) {
        switch (ballot.flag()) {
            default: {
                return null;
            }
            case LOCAL: {
                return ConsistencyLevel.LOCAL_SERIAL;
            }
            case GLOBAL: 
        }
        return ConsistencyLevel.SERIAL;
    }

    static Map<InetAddressAndPort, EndpointState> verifyElectorate(Electorate remoteElectorate, Electorate localElectorate) {
        EndpointState endpoint;
        if (remoteElectorate.equals(localElectorate)) {
            return Collections.emptyMap();
        }
        HashMap endpoints = Maps.newHashMapWithExpectedSize((int)(remoteElectorate.size() + localElectorate.size()));
        for (InetAddressAndPort host : remoteElectorate) {
            endpoint = Gossiper.instance.copyEndpointStateForEndpoint(host);
            if (endpoint == null) {
                NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 1L, TimeUnit.MINUTES, "Remote electorate {} could not be found in Gossip", host);
                continue;
            }
            endpoints.put(host, endpoint);
        }
        for (InetAddressAndPort host : localElectorate) {
            endpoint = Gossiper.instance.copyEndpointStateForEndpoint(host);
            if (endpoint == null) {
                NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 1L, TimeUnit.MINUTES, "Local electorate {} could not be found in Gossip", host);
                continue;
            }
            endpoints.putIfAbsent(host, endpoint);
        }
        return endpoints;
    }

    public static boolean useV2() {
        switch (PAXOS_VARIANT) {
            case v2_without_linearizable_reads_or_rejected_writes: 
            case v2_without_linearizable_reads: 
            case v2: {
                return true;
            }
            case v1: 
            case v1_without_linearizable_reads_or_rejected_writes: {
                return false;
            }
        }
        throw new AssertionError();
    }

    public static boolean isLinearizable() {
        switch (PAXOS_VARIANT) {
            case v2: 
            case v1: {
                return true;
            }
            case v2_without_linearizable_reads_or_rejected_writes: 
            case v2_without_linearizable_reads: 
            case v1_without_linearizable_reads_or_rejected_writes: {
                return false;
            }
        }
        throw new AssertionError();
    }

    public static void setPaxosVariant(Config.PaxosVariant paxosVariant) {
        Preconditions.checkNotNull((Object)((Object)paxosVariant));
        PAXOS_VARIANT = paxosVariant;
        DatabaseDescriptor.setPaxosVariant(paxosVariant);
    }

    public static Config.PaxosVariant getPaxosVariant() {
        return PAXOS_VARIANT;
    }

    static boolean isOldParticipant(Replica replica) {
        String version = Gossiper.instance.getForEndpoint(replica.endpoint(), ApplicationState.RELEASE_VERSION);
        if (version == null) {
            return false;
        }
        try {
            return new CassandraVersion(version).compareTo(MODERN_PAXOS_RELEASE) < 0;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void evictHungRepairs() {
        PaxosTableRepairs.evictHungRepairs();
    }

    static class BeginResult {
        final Ballot ballot;
        final Participants participants;
        final int failedAttemptsDueToContention;
        final PartitionIterator readResponse;
        final boolean isLinearizableRead;
        final boolean isPromised;
        final Ballot retryWithAtLeast;

        public BeginResult(Ballot ballot, Participants participants, int failedAttemptsDueToContention, PartitionIterator readResponse, boolean isLinearizableRead, boolean isPromised, Ballot retryWithAtLeast) {
            assert (isPromised || isLinearizableRead);
            this.ballot = ballot;
            this.participants = participants;
            this.failedAttemptsDueToContention = failedAttemptsDueToContention;
            this.readResponse = readResponse;
            this.isLinearizableRead = isLinearizableRead;
            this.isPromised = isPromised;
            this.retryWithAtLeast = retryWithAtLeast;
        }
    }

    public static interface Async<Result> {
        public Result awaitUntil(long var1);
    }

    static class MaybeFailure {
        final boolean isFailure;
        final String serverError;
        final int contacted;
        final int required;
        final int successes;
        final Map<InetAddressAndPort, RequestFailureReason> failures;

        static MaybeFailure noResponses(Participants contacted) {
            return new MaybeFailure(false, contacted.sizeOfPoll(), contacted.sizeOfConsensusQuorum, 0, Collections.emptyMap());
        }

        MaybeFailure(Participants contacted, int successes, FailureRecordingCallback.AsMap failures) {
            this(contacted.sizeOfPoll() - failures.failureCount() < contacted.sizeOfConsensusQuorum, contacted.sizeOfPoll(), contacted.sizeOfConsensusQuorum, successes, failures);
        }

        MaybeFailure(int contacted, int required, int successes, FailureRecordingCallback.AsMap failures) {
            this(contacted - failures.failureCount() < required, contacted, required, successes, failures);
        }

        MaybeFailure(boolean isFailure, int contacted, int required, int successes, Map<InetAddressAndPort, RequestFailureReason> failures) {
            this(isFailure, null, contacted, required, successes, failures);
        }

        MaybeFailure(boolean isFailure, String serverError, int contacted, int required, int successes, Map<InetAddressAndPort, RequestFailureReason> failures) {
            this.isFailure = isFailure;
            this.serverError = serverError;
            this.contacted = contacted;
            this.required = required;
            this.successes = successes;
            this.failures = failures;
        }

        private static int failureCount(Map<InetAddressAndPort, RequestFailureReason> failures) {
            int count = 0;
            for (RequestFailureReason reason : failures.values()) {
                count += reason != RequestFailureReason.TIMEOUT ? 1 : 0;
            }
            return count;
        }

        RequestExecutionException markAndThrowAsTimeoutOrFailure(boolean isWrite, ConsistencyLevel consistency, int failedAttemptsDueToContention) {
            if (this.isFailure) {
                Paxos.mark(isWrite, m -> m.failures, consistency);
                throw this.serverError != null ? new RequestFailureException(ExceptionCode.SERVER_ERROR, this.serverError, consistency, this.successes, this.required, this.failures) : (isWrite ? new WriteFailureException(consistency, this.successes, this.required, WriteType.CAS, this.failures) : new ReadFailureException(consistency, this.successes, this.required, false, this.failures));
            }
            Paxos.mark(isWrite, m -> m.timeouts, consistency);
            throw isWrite ? new CasWriteTimeoutException(WriteType.CAS, consistency, this.successes, this.required, failedAttemptsDueToContention) : new ReadTimeoutException(consistency, this.successes, this.required, false);
        }

        public String toString() {
            return (this.isFailure ? "Failure(" : "Timeout(") + this.successes + "," + this.failures + ")";
        }
    }

    static class Participants
    implements ReplicaPlan.ForRead<EndpointsForToken, Participants>,
    Supplier<Participants> {
        final Keyspace keyspace;
        final AbstractReplicationStrategy replicationStrategy;
        final ConsistencyLevel consistencyForConsensus;
        final Electorate electorate;
        private final EndpointsForToken electorateNatural;
        final EndpointsForToken electorateLive;
        final EndpointsForToken all;
        final EndpointsForToken allLive;
        final EndpointsForToken allDown;
        final EndpointsForToken pending;
        final int sizeOfConsensusQuorum;
        final int sizeOfReadQuorum;

        Participants(Keyspace keyspace, ConsistencyLevel consistencyForConsensus, ReplicaLayout.ForTokenWrite all, ReplicaLayout.ForTokenWrite electorate, EndpointsForToken live) {
            this.keyspace = keyspace;
            this.replicationStrategy = all.replicationStrategy();
            this.consistencyForConsensus = consistencyForConsensus;
            this.all = (EndpointsForToken)all.all();
            this.pending = (EndpointsForToken)all.pending();
            this.allDown = all.all() == live ? EndpointsForToken.empty(all.token()) : (EndpointsForToken)((EndpointsForToken)all.all()).without(live.endpoints());
            this.electorate = new Electorate(((EndpointsForToken)electorate.natural()).endpointList(), ((EndpointsForToken)electorate.pending()).endpointList());
            this.electorateNatural = (EndpointsForToken)electorate.natural();
            this.electorateLive = electorate.all() == live ? live : (EndpointsForToken)((EndpointsForToken)electorate.all()).keep(live.endpoints());
            this.allLive = live;
            this.sizeOfReadQuorum = ((EndpointsForToken)electorate.natural()).size() / 2 + 1;
            this.sizeOfConsensusQuorum = this.sizeOfReadQuorum + ((EndpointsForToken)electorate.pending()).size();
        }

        @Override
        public int readQuorum() {
            return this.sizeOfReadQuorum;
        }

        @Override
        public EndpointsForToken readCandidates() {
            return this.electorateNatural;
        }

        static Participants get(TableMetadata table, Token token, ConsistencyLevel consistencyForConsensus) {
            Keyspace keyspace = Keyspace.open(table.keyspace);
            ReplicaLayout.ForTokenWrite all = ReplicaLayout.forTokenWriteLiveAndDown(keyspace, token);
            ReplicaLayout.ForTokenWrite electorate = consistencyForConsensus.isDatacenterLocal() ? all.filter(InOurDc.replicas()) : all;
            EndpointsForToken live = (EndpointsForToken)((EndpointsForToken)all.all()).filter(FailureDetector.isReplicaAlive);
            return new Participants(keyspace, consistencyForConsensus, all, electorate, live);
        }

        static Participants get(TableMetadata cfm, DecoratedKey key, ConsistencyLevel consistency) {
            return Participants.get(cfm, key.getToken(), consistency);
        }

        int sizeOfPoll() {
            return this.electorateLive.size();
        }

        InetAddressAndPort voter(int i) {
            return this.electorateLive.endpoint(i);
        }

        void assureSufficientLiveNodes(boolean isWrite) throws UnavailableException {
            if (this.sizeOfConsensusQuorum > this.sizeOfPoll()) {
                Paxos.mark(isWrite, m -> m.unavailables, this.consistencyForConsensus);
                throw new UnavailableException("Cannot achieve consistency level " + this.consistencyForConsensus, this.consistencyForConsensus, this.sizeOfConsensusQuorum, this.sizeOfPoll());
            }
        }

        void assureSufficientLiveNodesForRepair() throws UnavailableException {
            if (this.sizeOfConsensusQuorum > this.sizeOfPoll()) {
                throw UnavailableException.create(this.consistencyForConsensus, this.sizeOfConsensusQuorum, this.sizeOfPoll());
            }
        }

        int requiredFor(ConsistencyLevel consistency) {
            if (consistency == Paxos.nonSerial(this.consistencyForConsensus)) {
                return this.sizeOfConsensusQuorum;
            }
            return consistency.blockForWrite(this.replicationStrategy(), this.pending);
        }

        public boolean hasOldParticipants() {
            return this.electorateLive.anyMatch(Paxos::isOldParticipant);
        }

        @Override
        public Participants get() {
            return this;
        }

        @Override
        public Keyspace keyspace() {
            return this.keyspace;
        }

        @Override
        public AbstractReplicationStrategy replicationStrategy() {
            return this.replicationStrategy;
        }

        @Override
        public ConsistencyLevel consistencyLevel() {
            return Paxos.nonSerial(this.consistencyForConsensus);
        }

        @Override
        public EndpointsForToken contacts() {
            return this.electorateLive;
        }

        @Override
        public Replica lookup(InetAddressAndPort endpoint) {
            return this.all.lookup(endpoint);
        }

        @Override
        public Participants withContacts(EndpointsForToken newContacts) {
            throw new UnsupportedOperationException();
        }
    }

    static class Electorate
    implements Iterable<InetAddressAndPort> {
        static final Serializer serializer = new Serializer();
        final Collection<InetAddressAndPort> natural;
        final Collection<InetAddressAndPort> pending;

        public Electorate(Collection<InetAddressAndPort> natural, Collection<InetAddressAndPort> pending) {
            this.natural = natural;
            this.pending = pending;
        }

        public int size() {
            return this.natural.size() + this.pending.size();
        }

        @Override
        public Iterator<InetAddressAndPort> iterator() {
            return Iterators.concat(this.natural.iterator(), this.pending.iterator());
        }

        static Electorate get(TableMetadata table, DecoratedKey key, ConsistencyLevel consistency) {
            return Electorate.get(consistency, ReplicaLayout.forTokenWriteLiveAndDown(Keyspace.open(table.keyspace), key.getToken()));
        }

        static Electorate get(ConsistencyLevel consistency, ReplicaLayout.ForTokenWrite all) {
            ReplicaLayout.ForTokenWrite electorate = all;
            if (consistency == ConsistencyLevel.LOCAL_SERIAL) {
                electorate = all.filter(InOurDc.replicas());
            }
            return new Electorate(((EndpointsForToken)electorate.natural()).endpointList(), ((EndpointsForToken)electorate.pending()).endpointList());
        }

        boolean hasPending() {
            return !this.pending.isEmpty();
        }

        boolean isPending(InetAddressAndPort endpoint) {
            return this.hasPending() && this.pending.contains(endpoint);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Electorate that = (Electorate)o;
            return this.natural.equals(that.natural) && this.pending.equals(that.pending);
        }

        public int hashCode() {
            return Objects.hash(this.natural, this.pending);
        }

        public String toString() {
            return "{" + this.natural + ", " + this.pending + "}";
        }

        static class Serializer
        implements IVersionedSerializer<Electorate> {
            Serializer() {
            }

            @Override
            public void serialize(Electorate electorate, DataOutputPlus out, int version) throws IOException {
                CollectionSerializer.serializeCollection(InetAddressAndPort.Serializer.inetAddressAndPortSerializer, electorate.natural, out, version);
                CollectionSerializer.serializeCollection(InetAddressAndPort.Serializer.inetAddressAndPortSerializer, electorate.pending, out, version);
            }

            @Override
            public Electorate deserialize(DataInputPlus in, int version) throws IOException {
                Set<InetAddressAndPort> endpoints = CollectionSerializer.deserializeCollection(InetAddressAndPort.Serializer.inetAddressAndPortSerializer, CollectionSerializer.newHashSet(), in, version);
                Set<InetAddressAndPort> pending = CollectionSerializer.deserializeCollection(InetAddressAndPort.Serializer.inetAddressAndPortSerializer, CollectionSerializer.newHashSet(), in, version);
                return new Electorate(endpoints, pending);
            }

            @Override
            public long serializedSize(Electorate electorate, int version) {
                return CollectionSerializer.serializedSizeCollection(InetAddressAndPort.Serializer.inetAddressAndPortSerializer, electorate.natural, version) + CollectionSerializer.serializedSizeCollection(InetAddressAndPort.Serializer.inetAddressAndPortSerializer, electorate.pending, version);
            }
        }
    }
}

