/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.IOException;
import org.apache.cassandra.io.util.DataOutputPlus;

public final class PageAware {
    public static final int PAGE_SIZE = 4096;
    public static final int PAGE_SIZE_SHIFT = Integer.numberOfTrailingZeros(4096);

    public static long pageLimit(long dstPos) {
        return (dstPos | 0xFFFL) + 1L;
    }

    public static long pageStart(long dstPos) {
        return dstPos & 0xFFFFFFFFFFFFF000L;
    }

    public static long padded(long dstPos) {
        return PageAware.pageStart(dstPos + 4096L - 1L);
    }

    public static int bytesLeftInPage(long dstPos) {
        return 4096 - (int)(dstPos & 0xFFFL);
    }

    public static int numPages(int size) {
        return size + 4096 - 1 >> PAGE_SIZE_SHIFT;
    }

    public static int pageNum(long dstPos) {
        return Math.toIntExact(dstPos >> PAGE_SIZE_SHIFT);
    }

    public static void pad(DataOutputPlus dest) throws IOException {
        long position = dest.position();
        long bytesLeft = PageAware.padded(position) - position;
        dest.write(EmptyPage.EMPTY_PAGE, 0, (int)bytesLeft);
    }

    static class EmptyPage {
        static final byte[] EMPTY_PAGE = new byte[4096];

        EmptyPage() {
        }
    }
}

