/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.plan;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.VectorQueryContext;
import org.apache.cassandra.index.sai.disk.IndexSearchResultIterator;
import org.apache.cassandra.index.sai.disk.SSTableIndex;
import org.apache.cassandra.index.sai.iterators.KeyRangeConcatIterator;
import org.apache.cassandra.index.sai.iterators.KeyRangeIntersectionIterator;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.iterators.KeyRangeOrderingIterator;
import org.apache.cassandra.index.sai.iterators.KeyRangeUnionIterator;
import org.apache.cassandra.index.sai.metrics.TableQueryMetrics;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.plan.QueryViewBuilder;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.Throwables;

public class QueryController {
    private final ColumnFamilyStore cfs;
    private final ReadCommand command;
    private final QueryContext queryContext;
    private final TableQueryMetrics tableQueryMetrics;
    private final RowFilter filterOperation;
    private final List<DataRange> ranges;
    private final AbstractBounds<PartitionPosition> mergeRange;
    private final PrimaryKey.Factory keyFactory;
    private final PrimaryKey firstPrimaryKey;
    private final PrimaryKey lastPrimaryKey;
    private final int orderChunkSize;

    public QueryController(ColumnFamilyStore cfs, ReadCommand command, RowFilter filterOperation, QueryContext queryContext, TableQueryMetrics tableQueryMetrics) {
        this.cfs = cfs;
        this.command = command;
        this.queryContext = queryContext;
        this.tableQueryMetrics = tableQueryMetrics;
        this.filterOperation = filterOperation;
        this.ranges = QueryController.dataRanges(command);
        DataRange first = this.ranges.get(0);
        DataRange last = this.ranges.get(this.ranges.size() - 1);
        this.mergeRange = this.ranges.size() == 1 ? first.keyRange() : first.keyRange().withNewRight((PartitionPosition)last.keyRange().right);
        this.keyFactory = new PrimaryKey.Factory(cfs.getPartitioner(), cfs.getComparator());
        this.firstPrimaryKey = this.keyFactory.create(((PartitionPosition)this.mergeRange.left).getToken());
        this.lastPrimaryKey = this.keyFactory.create(((PartitionPosition)this.mergeRange.right).getToken());
        this.orderChunkSize = CassandraRelevantProperties.SAI_VECTOR_SEARCH_ORDER_CHUNK_SIZE.getInt();
    }

    public PrimaryKey.Factory primaryKeyFactory() {
        return this.keyFactory;
    }

    public PrimaryKey firstPrimaryKeyInRange() {
        return this.firstPrimaryKey;
    }

    public PrimaryKey lastPrimaryKeyInRange() {
        return this.lastPrimaryKey;
    }

    public TableMetadata metadata() {
        return this.command.metadata();
    }

    public RowFilter filterOperation() {
        return this.filterOperation;
    }

    public List<DataRange> dataRanges() {
        return this.ranges;
    }

    public StorageAttachedIndex indexFor(RowFilter.Expression expression) {
        Set<StorageAttachedIndex> indexes = this.cfs.indexManager.getBestIndexFor(expression, StorageAttachedIndex.class);
        return indexes.isEmpty() ? null : indexes.iterator().next();
    }

    public boolean hasAnalyzer(RowFilter.Expression expression) {
        StorageAttachedIndex index = this.indexFor(expression);
        return index != null && index.hasAnalyzer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnfilteredRowIterator queryStorage(PrimaryKey key, ReadExecutionController executionController) {
        if (key == null) {
            throw new IllegalArgumentException("non-null key required");
        }
        try {
            SinglePartitionReadCommand partition = SinglePartitionReadCommand.create(this.cfs.metadata(), this.command.nowInSec(), this.command.columnFilter(), RowFilter.none(), DataLimits.NONE, key.partitionKey(), this.makeFilter(key));
            UnfilteredRowIterator unfilteredRowIterator = partition.queryMemtableAndDisk(this.cfs, executionController);
            return unfilteredRowIterator;
        }
        finally {
            this.queryContext.checkpoint();
        }
    }

    public KeyRangeIterator.Builder getIndexQueryResults(Collection<Expression> expressions) {
        expressions = expressions.stream().filter(e -> e.getIndexOperator() != Expression.IndexOperator.ANN).collect(Collectors.toList());
        KeyRangeIntersectionIterator.Builder builder = KeyRangeIntersectionIterator.builder(expressions.size());
        QueryViewBuilder queryViewBuilder = new QueryViewBuilder(expressions, this.mergeRange);
        QueryViewBuilder.QueryView queryView = queryViewBuilder.build();
        try {
            for (Pair<Expression, Collection<SSTableIndex>> queryViewPair : queryView.view) {
                IndexSearchResultIterator indexIterator = IndexSearchResultIterator.build((Expression)queryViewPair.left, (Collection)queryViewPair.right, this.mergeRange, this.queryContext);
                ((KeyRangeIterator.Builder)builder).add(indexIterator);
            }
        }
        catch (Throwable t) {
            ((KeyRangeIterator.Builder)builder).cleanup();
            queryView.referencedIndexes.forEach(SSTableIndex::releaseQuietly);
            throw t;
        }
        return builder;
    }

    public boolean doesNotSelect(PrimaryKey key) {
        return key.kind() == PrimaryKey.Kind.WIDE && !this.command.clusteringIndexFilter(key.partitionKey()).selects(key.clustering());
    }

    public void finish() {
        if (this.tableQueryMetrics != null) {
            this.tableQueryMetrics.record(this.queryContext);
        }
    }

    public KeyRangeIterator getTopKRows(RowFilter.Expression expression) {
        assert (expression.operator() == Operator.ANN);
        StorageAttachedIndex index = this.indexFor(expression);
        assert (index != null);
        Expression planExpression = Expression.create(index).add(Operator.ANN, expression.getIndexValue().duplicate());
        KeyRangeIterator memtableResults = index.memtableIndexManager().searchMemtableIndexes(this.queryContext, planExpression, this.mergeRange);
        QueryViewBuilder.QueryView queryView = new QueryViewBuilder(Collections.singleton(planExpression), this.mergeRange).build();
        try {
            List<KeyRangeIterator> sstableIntersections = queryView.view.stream().map(this::createRowIdIterator).collect(Collectors.toList());
            return IndexSearchResultIterator.build(sstableIntersections, memtableResults, queryView.referencedIndexes, this.queryContext);
        }
        catch (Throwable t) {
            queryView.referencedIndexes.forEach(SSTableIndex::release);
            throw t;
        }
    }

    public KeyRangeIterator getTopKRows(KeyRangeIterator source, RowFilter.Expression expression) {
        return new KeyRangeOrderingIterator(source, this.orderChunkSize, list -> this.getTopKRows((List<PrimaryKey>)list, expression));
    }

    private KeyRangeIterator getTopKRows(List<PrimaryKey> rawSourceKeys, RowFilter.Expression expression) {
        VectorQueryContext vectorQueryContext = this.queryContext.vectorContext();
        List<PrimaryKey> sourceKeys = rawSourceKeys.stream().filter(vectorQueryContext::shouldInclude).collect(Collectors.toList());
        StorageAttachedIndex index = this.indexFor(expression);
        assert (index != null) : "Cannot do ANN ordering on an unindexed column";
        Expression planExpression = Expression.create(index);
        planExpression.add(Operator.ANN, expression.getIndexValue().duplicate());
        KeyRangeIterator memtableResults = index.memtableIndexManager().limitToTopResults(this.queryContext, sourceKeys, planExpression);
        QueryViewBuilder.QueryView queryView = new QueryViewBuilder(Collections.singleton(planExpression), this.mergeRange).build();
        try {
            List<KeyRangeIterator> sstableIntersections = queryView.view.stream().flatMap(pair -> ((Collection)pair.right).stream()).map(idx -> {
                try {
                    return idx.limitToTopKResults(this.queryContext, sourceKeys, planExpression);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }).collect(Collectors.toList());
            return IndexSearchResultIterator.build(sstableIntersections, memtableResults, queryView.referencedIndexes, this.queryContext);
        }
        catch (Throwable t) {
            queryView.referencedIndexes.forEach(SSTableIndex::release);
            throw t;
        }
    }

    private KeyRangeIterator createRowIdIterator(Pair<Expression, Collection<SSTableIndex>> indexExpression) {
        List<KeyRangeIterator> subIterators = ((Collection)indexExpression.right).stream().map(index -> {
            try {
                List<KeyRangeIterator> iterators = index.search((Expression)indexExpression.left, this.mergeRange, this.queryContext);
                return KeyRangeConcatIterator.builder(iterators.size()).add(iterators).build();
            }
            catch (Throwable ex) {
                throw Throwables.cleaned(ex);
            }
        }).collect(Collectors.toList());
        return KeyRangeUnionIterator.build(subIterators);
    }

    private ClusteringIndexFilter makeFilter(PrimaryKey key) {
        ClusteringIndexFilter clusteringIndexFilter = this.command.clusteringIndexFilter(key.partitionKey());
        assert (this.cfs.metadata().comparator.size() == 0 && !key.kind().hasClustering || this.cfs.metadata().comparator.size() > 0 && key.kind().hasClustering) : "PrimaryKey " + key + " clustering does not match table. There should be a clustering of size " + this.cfs.metadata().comparator.size();
        if (this.cfs.metadata().comparator.size() == 0 || key.kind() == PrimaryKey.Kind.STATIC) {
            return clusteringIndexFilter;
        }
        return new ClusteringIndexNamesFilter(FBUtilities.singleton(key.clustering(), this.cfs.metadata().comparator), clusteringIndexFilter.isReversed());
    }

    private static List<DataRange> dataRanges(ReadCommand command) {
        if (command instanceof SinglePartitionReadCommand) {
            SinglePartitionReadCommand cmd = (SinglePartitionReadCommand)command;
            DecoratedKey key = cmd.partitionKey();
            return Lists.newArrayList((Object[])new DataRange[]{new DataRange(new Range<PartitionPosition>(key, key), cmd.clusteringIndexFilter())});
        }
        if (command instanceof PartitionRangeReadCommand) {
            PartitionRangeReadCommand cmd = (PartitionRangeReadCommand)command;
            return Lists.newArrayList((Object[])new DataRange[]{cmd.dataRange()});
        }
        throw new AssertionError((Object)("Unsupported read command type: " + command.getClass().getName()));
    }
}

