/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1;

import com.carrotsearch.hppc.LongArrayList;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.index.sai.disk.PerColumnIndexWriter;
import org.apache.cassandra.index.sai.disk.RowMapping;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.v1.ColumnCompletionMarkerUtil;
import org.apache.cassandra.index.sai.disk.v1.MetadataWriter;
import org.apache.cassandra.index.sai.disk.v1.bbtree.BlockBalancedTreeIterator;
import org.apache.cassandra.index.sai.disk.v1.bbtree.NumericIndexWriter;
import org.apache.cassandra.index.sai.disk.v1.segment.SegmentMetadata;
import org.apache.cassandra.index.sai.disk.v1.trie.LiteralIndexWriter;
import org.apache.cassandra.index.sai.memory.MemtableIndex;
import org.apache.cassandra.index.sai.memory.MemtableTermsIterator;
import org.apache.cassandra.index.sai.metrics.IndexMetrics;
import org.apache.cassandra.index.sai.utils.IndexIdentifier;
import org.apache.cassandra.index.sai.utils.IndexTermType;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemtableIndexWriter
implements PerColumnIndexWriter {
    private static final Logger logger = LoggerFactory.getLogger(MemtableIndexWriter.class);
    private final IndexDescriptor indexDescriptor;
    private final IndexTermType indexTermType;
    private final IndexIdentifier indexIdentifier;
    private final IndexMetrics indexMetrics;
    private final MemtableIndex memtable;
    private final RowMapping rowMapping;

    public MemtableIndexWriter(MemtableIndex memtable, IndexDescriptor indexDescriptor, IndexTermType indexTermType, IndexIdentifier indexIdentifier, IndexMetrics indexMetrics, RowMapping rowMapping) {
        assert (rowMapping != null && rowMapping != RowMapping.DUMMY) : "Row mapping must exist during FLUSH.";
        this.indexDescriptor = indexDescriptor;
        this.indexTermType = indexTermType;
        this.indexIdentifier = indexIdentifier;
        this.indexMetrics = indexMetrics;
        this.memtable = memtable;
        this.rowMapping = rowMapping;
    }

    @Override
    public void addRow(PrimaryKey key, Row row, long sstableRowId) {
    }

    @Override
    public void abort(Throwable cause) {
        logger.warn(this.indexIdentifier.logMessage("Aborting index memtable flush for {}..."), (Object)this.indexDescriptor.sstableDescriptor, (Object)cause);
        this.indexDescriptor.deleteColumnIndex(this.indexTermType, this.indexIdentifier);
    }

    @Override
    public void complete(Stopwatch stopwatch) throws IOException {
        block10: {
            assert (this.rowMapping.isComplete()) : "Cannot complete the memtable index writer because the row mapping is not complete";
            long start = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            try {
                if (!this.rowMapping.hasRows() || this.memtable == null || this.memtable.isEmpty()) {
                    logger.debug(this.indexIdentifier.logMessage("No indexed rows to flush from SSTable {}."), (Object)this.indexDescriptor.sstableDescriptor);
                    ColumnCompletionMarkerUtil.create(this.indexDescriptor, this.indexIdentifier, true);
                    return;
                }
                if (this.indexTermType.isVector()) {
                    this.flushVectorIndex(start, stopwatch);
                    break block10;
                }
                Iterator<Pair<ByteComparable, LongArrayList>> iterator = this.rowMapping.merge(this.memtable);
                try (MemtableTermsIterator terms = new MemtableTermsIterator(this.memtable.getMinTerm(), this.memtable.getMaxTerm(), iterator);){
                    long cellCount = this.flush(terms, this.rowMapping.maxSSTableRowId);
                    this.completeIndexFlush(cellCount, start, stopwatch);
                }
            }
            catch (Throwable t) {
                logger.error(this.indexIdentifier.logMessage("Error while flushing index {}"), (Object)t.getMessage(), (Object)t);
                this.indexMetrics.memtableIndexFlushErrors.inc();
                throw t;
            }
        }
    }

    private long flush(MemtableTermsIterator terms, long maxSSTableRowId) throws IOException {
        long numRows;
        SegmentMetadata.ComponentMetadataMap indexMetas;
        Object writer;
        if (this.indexTermType.isLiteral()) {
            writer = new LiteralIndexWriter(this.indexDescriptor, this.indexIdentifier);
            try {
                indexMetas = ((LiteralIndexWriter)writer).writeCompleteSegment(terms);
                numRows = ((LiteralIndexWriter)writer).getPostingsCount();
            }
            finally {
                ((LiteralIndexWriter)writer).close();
            }
        } else {
            writer = new NumericIndexWriter(this.indexDescriptor, this.indexIdentifier, this.indexTermType.fixedSizeOf(), maxSSTableRowId);
            indexMetas = ((NumericIndexWriter)writer).writeCompleteSegment(BlockBalancedTreeIterator.fromTermsIterator(terms, this.indexTermType));
            numRows = ((NumericIndexWriter)writer).getValueCount();
        }
        if (numRows == 0L) {
            this.indexDescriptor.deleteColumnIndex(this.indexTermType, this.indexIdentifier);
            return 0L;
        }
        SegmentMetadata metadata = new SegmentMetadata(0L, numRows, terms.getMinSSTableRowId(), terms.getMaxSSTableRowId(), this.rowMapping.minKey, this.rowMapping.maxKey, terms.getMinTerm(), terms.getMaxTerm(), indexMetas);
        try (MetadataWriter writer2 = new MetadataWriter(this.indexDescriptor.openPerIndexOutput(IndexComponent.META, this.indexIdentifier));){
            SegmentMetadata.write(writer2, Collections.singletonList(metadata));
        }
        return numRows;
    }

    private void flushVectorIndex(long startTime, Stopwatch stopwatch) throws IOException {
        SegmentMetadata.ComponentMetadataMap metadataMap = this.memtable.writeDirect(this.indexDescriptor, this.indexIdentifier, this.rowMapping::get);
        this.completeIndexFlush(this.rowMapping.size(), startTime, stopwatch);
        SegmentMetadata metadata = new SegmentMetadata(0L, this.rowMapping.size(), 0L, this.rowMapping.maxSSTableRowId, this.rowMapping.minKey, this.rowMapping.maxKey, ByteBufferUtil.bytes(0), ByteBufferUtil.bytes(0), metadataMap);
        try (MetadataWriter writer = new MetadataWriter(this.indexDescriptor.openPerIndexOutput(IndexComponent.META, this.indexIdentifier));){
            SegmentMetadata.write(writer, Collections.singletonList(metadata));
        }
    }

    private void completeIndexFlush(long cellCount, long startTime, Stopwatch stopwatch) throws IOException {
        ColumnCompletionMarkerUtil.create(this.indexDescriptor, this.indexIdentifier, false);
        this.indexMetrics.memtableIndexFlushCount.inc();
        long elapsedTime = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        logger.debug(this.indexIdentifier.logMessage("Completed flushing {} memtable index cells to SSTable {}. Duration: {} ms. Total elapsed: {} ms"), new Object[]{cellCount, this.indexDescriptor.sstableDescriptor, elapsedTime - startTime, elapsedTime});
        this.indexMetrics.memtableFlushCellsPerSecond.update((long)((double)cellCount * 1000.0 / (double)Math.max(1L, elapsedTime - startTime)));
    }
}

